package de.ciluvien.mensen.data.remote

import android.util.Log
import io.ktor.client.HttpClient
import io.ktor.client.call.body
import io.ktor.client.plugins.ClientRequestException
import io.ktor.client.plugins.ResponseException
import io.ktor.client.request.*
import java.time.LocalDate

class OpenMensaImpl(private val client: HttpClient) : OpenMensaService {
    private val httpRoutes = HttpRoutes()
    override suspend fun getCanteens(): List<CanteenResponse> {
        return try {
            client.get {
                url(httpRoutes.getCanteensURL())
            }.body()
        } catch (e: ResponseException) {
            Log.w("OpenMensaAPI", "Error: ${e.response.status.description}")
            emptyList()
        } catch (e: ClientRequestException) {
            Log.w("OpenMensaAPI", "Error: ${e.response.status.description}")
            emptyList()
        } catch (e: Exception) {
            Log.w("OpenMensaAPI", "Error: ${e.message}")
            emptyList()
        }
    }

    override suspend fun getDays(canteenID: Int): List<DayResponse> {
        return try {
            client.get {
                url(httpRoutes.getDaysURL(canteenID))
            }.body()
        } catch (e: ResponseException) {
            Log.w("OpenMensaAPI", "Error: ${e.response.status.description}")
            emptyList()
        } catch (e: ClientRequestException) {
            Log.w("OpenMensaAPI", "Error: ${e.response.status.description}")
            emptyList()
        } catch (e: Exception) {
            Log.w("OpenMensaAPI", "Error: ${e.message}")
            emptyList()
        }
    }

    override suspend fun getDay(canteenID: Int, date: LocalDate): DayResponse? {
        return try {
            client.get {
                url(httpRoutes.getDayURL(canteenID, date))
            }.body()
        } catch (e: ResponseException) {
            Log.w("OpenMensaAPI", "Error: ${e.response.status.description}")
            null
        } catch (e: ClientRequestException) {
            Log.w("OpenMensaAPI", "Error: ${e.response.status.description}")
            null
        } catch (e: Exception) {
            Log.w("OpenMensaAPI", "Error: ${e.message}")
            null
        }
    }

    override suspend fun getMeals(canteenID: Int, date: LocalDate): List<MealResponse> {
        return try {
            client.get {
                url(httpRoutes.getMealsURL(canteenID, date))
            }.body()
        } catch (e: ResponseException) {
            Log.w("OpenMensaAPI", "Error: ${e.response.status.description}")
            emptyList()
        } catch (e: ClientRequestException) {
            Log.w("OpenMensaAPI", "Error: ${e.response.status.description}")
            emptyList()
        } catch (e: Exception) {
            Log.w("OpenMensaAPI", "Error: ${e.message}")
            emptyList()
        }
    }

    override suspend fun getMeal(canteenID: Int, date: LocalDate, mealID: Int): MealResponse? {
        return try {
            client.get {
                url(httpRoutes.getMealURL(canteenID, date, mealID))
            }.body()
        } catch (e: ResponseException) {
            Log.w("OpenMensaAPI", "Error: ${e.response.status.description}")
            null
        } catch (e: ClientRequestException) {
            Log.w("OpenMensaAPI", "Error: ${e.response.status.description}")
            null
        } catch (e: Exception) {
            Log.w("OpenMensaAPI", "Error: ${e.message}")
            null
        }
    }
}