package de.ciluvien.mensen.data.remote

import java.time.LocalDate

data class HttpRoutes(
    var mainURL: String = "https://api.studentenwerk-dresden.de/openmensa/v2"
){
    fun getCanteensURL(): String {
        return "$mainURL/canteens"
    }

    fun getDaysURL(canteenID: Int): String {
        return "$mainURL/canteens/$canteenID/days"
    }

    fun getDayURL(canteenID: Int, date: LocalDate): String {
        return "$mainURL/canteens/$canteenID/days/$date"
    }

    fun getMealsURL(canteenID: Int, date: LocalDate): String {
        return "$mainURL/canteens/$canteenID/days/$date/meals"
    }

    fun getMealURL(canteenID: Int, date: LocalDate, mealID: Int): String {
        return "$mainURL/canteens/$canteenID/days/$date/meals/$mealID"
    }
}