package de.ciluvien.mensen.data.parser

import android.util.Log
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import org.jsoup.Jsoup
import org.jsoup.nodes.Document
import org.jsoup.select.Selector.SelectorParseException
import java.math.BigDecimal

class MenuDetailParser(private val url: String) {
    private val tag: String = "MenuDetailParser"
    private var doc: Document? = null

    suspend fun setHTMLDoc() {
        doc = withContext(Dispatchers.IO) {
            try {
                Jsoup.connect(url).get()
            } catch (e: Exception) {
                Log.e(tag, "Jsoup Error: ${e.message}")
                null
            }
        }
    }

    fun isMealSoldOut(mealId: Int): Boolean? {
        if(doc == null) {
            return null
        }
        val links = try {
            doc!!.select("a[href]")
        } catch(e: SelectorParseException) {
            Log.e(tag, "Failed to parse menu details page\n${e.message}")
            emptyList()
        }

        val mealElement = links.find { link ->
            val href = link.attr("href")
            href.contains(mealId.toString())
        }?.parent()

        return mealElement?.text()?.contains("ausverkauft", ignoreCase = true)
    }

    fun isClimatePlate(mealId: Int): Boolean? {
        if(doc == null) {
            return null
        }
        val links = try {
            doc!!.select("a[href]")
        } catch(e: SelectorParseException) {
            Log.e(tag, "Failed to parse menu details page\n${e.message}")
            emptyList()
        }

        val mealElement = links.find { link ->
            val href = link.attr("href")
            href.contains(mealId.toString())
        }?.parent()

        return mealElement
            ?.getElementsByAttributeValueContaining("src","klimateller")
            ?.isNotEmpty()
    }

    fun getAllPrices(mealId: Int): Map<String, BigDecimal>? {
        if(doc == null) {
            return null
        }
        val links = try {
            doc!!.select("a[href]")
        } catch(e: SelectorParseException) {
            Log.e(tag, "Failed to parse menu details page\n${e.message}")
            emptyList()
        }

        val mealElement = links.find { link ->
            val href = link.attr("href")
            href.contains(mealId.toString())
        }?.parent()

        return mealElement
            ?.getElementsContainingOwnText("€")
            ?.last()
            ?.text()
            ?.let { priceString ->
                val priceList = try {
                    priceString.split("/ ").map { price ->
                        price.filterNot { it == '€' }.trim().replace(',', '.').toBigDecimal()
                    }
                } catch (e: NumberFormatException) {
                    Log.e(tag,"Failed to convert price string to BigDecimal\n${e.message}")
                    emptyList()
                }
                if (priceList.size >= 3) {
                    mutableMapOf(
                        "Studierende" to priceList[0],
                        "Bedienstete" to priceList[1],
                        "Externe" to priceList[2]
                    )
                } else {
                    null
                }
            }
    }
}