package de.ciluvien.mensen.data.local

import de.ciluvien.mensen.data.remote.CanteenResponse

fun findImage(canteenResponse: CanteenResponse): String {
    val regex = """([^./]*)\.html""".toRegex()
    val matchResult = regex.find(canteenResponse.menu)

    return when(val internalHandle = matchResult?.groups?.get(1)) {
        null -> "https://www.studentenwerk-dresden.de/apple-touch-icon.png"
        else -> {"https://static.studentenwerk-dresden.de/mensen/logos/"+internalHandle.value+".png"}
    }
}