package de.ciluvien.mensen

import android.app.ActivityOptions
import android.app.PendingIntent
import android.content.Intent
import android.nfc.NfcAdapter
import android.os.Build
import android.os.Bundle
import androidx.activity.ComponentActivity
import kotlinx.coroutines.runBlocking

class BootstrapActivity : ComponentActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        val nfcAutoLaunchEnabled = runBlocking {
            MensenApp.appModule.settings.isNfcAutoLaunchEnabledOnce()
        }

        val launchedByNFC = intent?.action == NfcAdapter.ACTION_TAG_DISCOVERED ||
                intent?.action == NfcAdapter.ACTION_TECH_DISCOVERED

        super.onCreate(savedInstanceState)

        if (launchedByNFC && !nfcAutoLaunchEnabled) {
            moveTaskToBack(true)
            finish()
            return
        }

        val forward = Intent(this, MainActivity::class.java).apply {
            action = intent?.action
            data = intent?.data
            intent?.extras?.let { putExtras(it) }
            addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP or Intent.FLAG_ACTIVITY_CLEAR_TOP or Intent.FLAG_ACTIVITY_NEW_TASK)
        }

        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.UPSIDE_DOWN_CAKE) {
                val options = ActivityOptions.makeBasic()
                if (Build.VERSION.SDK_INT == Build.VERSION_CODES.UPSIDE_DOWN_CAKE
                    || Build.VERSION.SDK_INT == Build.VERSION_CODES.VANILLA_ICE_CREAM) {
                    options.pendingIntentCreatorBackgroundActivityStartMode =
                        ActivityOptions.MODE_BACKGROUND_ACTIVITY_START_ALLOWED
                } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.BAKLAVA) {
                    options.pendingIntentCreatorBackgroundActivityStartMode =
                        ActivityOptions.MODE_BACKGROUND_ACTIVITY_START_ALLOW_ALWAYS
                }

                val pi = PendingIntent.getActivity(
                    this,
                    0,
                    forward,
                    PendingIntent.FLAG_MUTABLE or PendingIntent.FLAG_UPDATE_CURRENT,
                    options.toBundle()
                )
                pi.send()
            } else {
                val pi = PendingIntent.getActivity(
                    this,
                    0,
                    forward,
                    PendingIntent.FLAG_IMMUTABLE or PendingIntent.FLAG_UPDATE_CURRENT
                )
                pi.send()
            }
        } catch (e: Exception) {
            finish()
        }
        finish()
    }
}