# mensen
## Install
[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" alt="Get it on F-Droid" height="80">](https://f-droid.org/packages/de.ciluvien.mensen)
[<img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png" alt="Get it on Google Play" height="80">](https://play.google.com/store/apps/details?id=de.ciluvien.mensen)

Or get the latest version on the [releases](https://codeberg.org/ciluvien/mensen/releases/latest) page.

## About

This app provides a convenient way to access the menu of your favorite canteens in Dresden. 
The integrated card reader for the Campuscard can show the current card balance.
It includes a map feature to help users locate the nearest canteens, especially beneficial for those unfamiliar with the campus.

The app retrieves data from the Studentenwerk Dresden's API. 
To enhance the user experience, the app also scrapes relevant information from the Studentenwerk Dresden website since the API's data may be limited.
The app automatically updates meal information every hour or upon user request.

## Usage
### Reordering Canteens
Users can easily reorder canteens by dragging them within the list. 
The order of canteens in the list corresponds to the order when swiping from left to right on the meal screen. 
The app displays the meals of the first canteen when switching to the menu screen. 
Pulling down refreshes the canteen list, although this is typically not required as canteen positions usually remain stable. 
This feature can be handy for accessing the latest opening times.

### Viewing the Menu
The app presents a canteen's menu in a list format for the selected date indicated by the floating button in the bottom right corner. 
Users can change the date by tapping on this button. Swiping left or right allows users to switch between canteens. 
The information button in the top left corner provides details about the current canteen. 
Tapping on a meal item reveals additional information such as category and allergens.

### Reading the Campuscard
Holding the card to the back of the device with NFC enabled will bring up a screen showing the card's balance.

### Finding Canteens with the Map
By tapping on a marker on the map, users can view details about the canteen, including its name and address. 
Clicking on the marker opens information about today's menu for that canteen. 
Alternatively, users can navigate to the canteen details screen and click on the icon next to the address to open the location in their preferred map app.

## Interesting or Related Projects
- [Canteen menu app for iOS](https://github.com/kiliankoe/MensaDresden)
- [App for reading current card balance](https://github.com/jakobwenzel/MensaGuthaben)



## Attributions
### Copyrights
#### Data
- [Studentenwerk Dresden API](https://api.studentenwerk-dresden.de/openmensa/v2)
- [Studentenwerk Dresden Website](https://www.studentenwerk-dresden.de/mensen/)

#### Imagery
- [Studentenwerk Dresden Website](https://www.studentenwerk-dresden.de/mensen/)

#### Icons
- [Material Design Icons](https://github.com/google/material-design-icons) 
- [Free Icons](https://free-icons.github.io/free-icons/)

#### Map
- Data and tiles from [OpenStreetMap](https://www.openstreetmap.org/copyright)
- [Contribute](https://www.openstreetmap.org/fixthemap) to the map

### Maintainer
- [ciluvien](https://codeberg.org/ciluvien)

### Contributors
- [appleju](https://codeberg.org/appleju)

## License
    Copyright (C) 2024 Ciluvien

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
