package de.ciluvien.mensen.ui.viewmodels

import androidx.compose.runtime.mutableStateOf
import androidx.lifecycle.ViewModel
import de.ciluvien.mensen.AppModule
import de.ciluvien.mensen.data.local.Canteen

class CanteenDetailsViewModel(appModule: AppModule) : ViewModel(){
    private val dao = appModule.canteenDao
    private val canteenInit = Canteen()

    private var _canteenState = mutableStateOf(canteenInit)
    val canteen = _canteenState
    suspend fun getCanteen(canteenId: Int) {
        _canteenState.value = dao.getCanteen(canteenId) ?: canteenInit
    }

}