package de.ciluvien.mensen.ui.screens

import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Scaffold
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.remember
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalContext
import androidx.lifecycle.viewmodel.compose.viewModel
import androidx.navigation.NavController
import de.ciluvien.mensen.MensenApp
import de.ciluvien.mensen.ui.components.MapViewAdapter
import de.ciluvien.mensen.ui.components.core.BottomNavigationBar
import de.ciluvien.mensen.ui.viewModelFactory
import de.ciluvien.mensen.ui.viewmodels.MapViewModel
import org.osmdroid.config.Configuration
import java.time.LocalDate

@Composable
fun MapScreen(navController: NavController, onNavigateMenu: (Int, LocalDate) -> Unit) {
    val context = LocalContext.current
    val mapViewModel = viewModel<MapViewModel>(
        factory = viewModelFactory {
            MapViewModel(MensenApp.appModule)
        }
    )

    remember {
        Configuration.getInstance().apply {
            userAgentValue = context.packageName
            load(context, context.getSharedPreferences("osmdroid", 0))
        }
    }

    LaunchedEffect(key1 = true) {
        mapViewModel.setCanteens()
    }

    Scaffold(
        bottomBar = { BottomNavigationBar(navController) }
    ) {padding ->
        Box(modifier = Modifier.padding(padding)){
            MapViewAdapter(mapViewModel.canteensAndPositions.value, onNavigateMenu)
        }
    }
}