package de.ciluvien.mensen.ui.components.settings

import android.content.Intent
import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.outlined.Share
import androidx.compose.material3.Card
import androidx.compose.material3.CardDefaults
import androidx.compose.material3.Icon
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Switch
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.unit.dp
import androidx.core.content.ContextCompat.startActivity
import de.ciluvien.mensen.R
import de.ciluvien.mensen.ui.viewmodels.SettingsViewModel

@Composable
fun Share() {
    val context = LocalContext.current

    Card(
        colors = CardDefaults.cardColors(
            containerColor = MaterialTheme.colorScheme.surfaceContainer,
        ),
        border = BorderStroke(2.dp, MaterialTheme.colorScheme.surfaceContainer),
        modifier = Modifier
            .fillMaxWidth()
            .padding(2.dp)
    ) {
        Column(
            modifier = Modifier.padding(10.dp)
        ) {
            Text(
                text = context.resources.getText(R.string.settings_share).toString(),
                style = MaterialTheme.typography.headlineSmall
            )

            Spacer(modifier = Modifier.size(10.dp))
            Row (
                verticalAlignment = Alignment.CenterVertically,
                modifier = Modifier.clickable {
                    val sendIntent: Intent = Intent().apply {
                        action = Intent.ACTION_SEND
                        putExtra(Intent.EXTRA_TEXT, "https://play.google.com/store/apps/details?id=de.ciluvien.mensen")
                        type = "text/plain"
                    }

                    val shareIntent = Intent.createChooser(sendIntent, null)
                    context.startActivity(shareIntent)

                }
            ) {
                Text(
                    text = context.resources.getText(R.string.settings_share_play_store).toString(),
                    style = MaterialTheme.typography.titleLarge
                )
                Spacer(Modifier.size(10.dp))
                Icon(
                    imageVector = Icons.Outlined.Share,
                    contentDescription = context.resources.getText(R.string.settings_share_play_store_link).toString()
                )
            }

            Spacer(modifier = Modifier.size(10.dp))
            Row (
                verticalAlignment = Alignment.CenterVertically,
                modifier = Modifier.clickable {
                    val sendIntent: Intent = Intent().apply {
                        action = Intent.ACTION_SEND
                        putExtra(Intent.EXTRA_TEXT, "https://f-droid.org/packages/de.ciluvien.mensen/")
                        type = "text/plain"
                    }

                    val shareIntent = Intent.createChooser(sendIntent, null)
                    context.startActivity(shareIntent)

                }
            ) {
                Text(
                    text = context.resources.getText(R.string.settings_share_fdroid).toString(),
                    style = MaterialTheme.typography.titleLarge
                )
                Spacer(Modifier.size(10.dp))
                Icon(
                    imageVector = Icons.Outlined.Share,
                    contentDescription = context.resources.getText(R.string.settings_share_fdroid_link).toString()
                )
            }
        }
    }
}
