package de.ciluvien.mensen.ui.components.core

import androidx.compose.material3.CenterAlignedTopAppBar
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.Icon
import androidx.compose.material3.IconButton
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.material3.TopAppBarDefaults
import androidx.compose.material3.TopAppBarScrollBehavior
import androidx.compose.runtime.Composable

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun MultiActionTopAppBar(
    title: String,
    scrollBehavior: TopAppBarScrollBehavior = TopAppBarDefaults.pinnedScrollBehavior(),
    leftIcon: CustomTextIcon? = null,
    rightIcons: List<CustomTextIcon>
) {
    CenterAlignedTopAppBar(
        title = {
            Text(
                text = title,
                style = MaterialTheme.typography.headlineMedium
            )
        },
        navigationIcon = {
            if (leftIcon != null) {
                IconButton(onClick = leftIcon.onClick) {
                    Icon(
                        imageVector = leftIcon.icon,
                        contentDescription = leftIcon.description
                    )
                }
            }
        },
        actions = {
            rightIcons.forEach {
                IconButton(onClick = it.onClick) {
                    Icon(
                        imageVector = it.icon,
                        contentDescription = it.description
                    )
                }
            }
        },
        scrollBehavior = scrollBehavior
    )
}

