package de.ciluvien.mensen.data.remote

import kotlinx.serialization.Serializable

@Serializable
data class MealResponse(
    val category: String,
    val id: Int,
    val image: String,
    val name: String,
    val notes: List<String>,
    val prices: Map<String, String?>,
    val url: String
) {
    fun getGeneralNotes(): List<String> {
        return notes.filter {
                string -> !string.contains("(") && string.isNotBlank()
        }.map {
                string -> string.trim()
        }
    }

    fun getAdditives(): List<String> {
        return notes.filter {
                string -> string.contains("""\(\d+\)""".toRegex())
        }.map {
                string -> string.trim()
        }
    }

    fun getAllergens(): List<String> {
        return notes.filter {
                string -> string.contains("""\(\w+\)""".toRegex())
        }.filter {
                string -> !getAdditives().contains(string.trim())
        }.map {
                string -> string.trim()
        }
    }

    fun isVegan(): Boolean {
        return notes.plus(name).stream().anyMatch() {string ->
            string.contains("vegan", ignoreCase = true)
        }
    }

    fun isVegetarian(): Boolean {
        return notes.plus(name).stream().anyMatch { string ->
            string.contains("vegetarisch", ignoreCase = true)
        } || this.isVegan()
    }

    fun isPescetarian(): Boolean {
        return (notes.plus(name).stream().anyMatch { string ->
            string.contains("Fisch", ignoreCase = true)
        } || this.isVegetarian()) && !containsMeat()
    }

    private fun containsMeat(): Boolean {
        return notes.plus(name).stream().anyMatch { string ->
            string.contains("fleisch", ignoreCase = true)
        }
    }

    fun isEveningOffer(): Boolean {
        return notes.plus(name).plus(category).stream().anyMatch { string ->
            string.contains("Abendangebot", ignoreCase = true)
        }
    }
}
