package de.ciluvien.mensen.data.parser

import android.util.Log
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.coroutineScope
import kotlinx.coroutines.withContext
import org.jsoup.Jsoup
import org.jsoup.nodes.Document
import org.jsoup.select.Selector.SelectorParseException

class CanteenDetailParser(private val url: String) {
    private val tag: String = "CanteenDetailParser"
    private var doc: Document? = null
    suspend fun setHTMLDoc() {
        doc = withContext(Dispatchers.IO) {
            try {
                Jsoup.connect(url).get()
            } catch (e: Exception) {
                Log.e(tag, "Jsoup Error: ${e.message}")
                null
            }
        }
    }

    fun getCanteenLogoURL(): String {
        val result = doc?.getElementsByAttributeValueContaining("alt", "Logo")?.first()?.attr("src")
            ?: return "https://www.studentenwerk-dresden.de/apple-touch-icon.png"

        return "https:$result"
    }

    fun getRegularOpeningTimes(): Map<String, String> {
        return getOpeningTimeTable("Reguläre Öffnungszeiten")
    }

    fun getSpecialOpeningTimes(): Map<String, String> {
        return getOpeningTimeTable("Aktuell veränderte Öffnungszeiten")
    }

    private fun getOpeningTimeTable(string: String): Map<String, String> {
        return try {
            val rows = doc?.select(".card.my-4:contains(${string}) .table tbody tr")
                ?: return emptyMap()

            val openingTimeMap = rows.filter { row ->
                val columns = row.select("th, td")
                columns.size >= 2 && columns[0].text().isNotBlank() && columns[1].text().isNotBlank()
            }.associate { row ->
                val columns = row.select("th, td")
                val key = columns[0].text()
                val value = columns.drop(1).joinToString(separator = "\n") { it.text() }
                key to value
            }
            openingTimeMap.filter { it.key.isNotBlank() }
        } catch (e: SelectorParseException) {
            Log.e(tag, "Failed to parse opening times\n${e.message}")
            emptyMap()
        }
    }
}