package de.ciluvien.mensen.data.local

import androidx.room.ColumnInfo
import androidx.room.Entity
import java.math.BigDecimal
import java.time.LocalDate

@Entity(primaryKeys = ["id", "menuDate"])
data class Meal(
    val id: Int,
    val name: String,
    val category: String,
    val generalNotes: List<String>,
    val allergens: List<String>,
    val additives: List<String>,
    val prices: Map<String, BigDecimal>,
    val imageULR: String,
    val menuDate: LocalDate,
    val canteenId: Int,
    val isSoldOut: Boolean?,
    val isVegan: Boolean,
    val isVegetarian: Boolean,
    @ColumnInfo(defaultValue = "true") val isPescetarian: Boolean,
    @ColumnInfo(defaultValue = "false") val isEveningOffer: Boolean
)

fun Meal(): Meal {
    return Meal(
        id = 0,
        name = "",
        category = "",
        generalNotes = emptyList(),
        allergens = emptyList(),
        additives = emptyList(),
        prices = emptyMap(),
        imageULR = "",
        menuDate = LocalDate.now(),
        canteenId = 0,
        isSoldOut = null,
        isVegan = true,
        isVegetarian = true,
        isPescetarian = true,
        isEveningOffer = false
    )
}