package de.ciluvien.mensen.data.local

import androidx.room.Entity
import androidx.room.PrimaryKey
import java.time.LocalDateTime

@Entity
data class Canteen(
    @PrimaryKey
    val id: Int,
    val name: String,
    val address: String,
    val coordinates: List<Double>,
    val organisation: String,
    val detailURL: String,
    val imageURL: String,
    val menuURL: String,
    var menuRefreshDateTime: LocalDateTime?,
    val regularOpeningTime: Map<String, String>,
    val specialOpeningTime: Map<String, String>
){
    fun isMenuStale(): Boolean {
        return menuRefreshDateTime?.isBefore(LocalDateTime.now().minusDays(1))
            ?: true
    }
}

fun Canteen(): Canteen {
    return Canteen(
        0,
        "",
        "",
        emptyList(),
        "",
        "",
        "",
        "",
        LocalDateTime.now(),
        emptyMap(),
        emptyMap()
    )
}
