package de.ciluvien.mensen.data

import android.content.Context
import androidx.room.AutoMigration
import androidx.room.Database
import androidx.room.Room
import androidx.room.RoomDatabase
import androidx.room.TypeConverters
import de.ciluvien.mensen.data.local.Bookmark
import de.ciluvien.mensen.data.local.Canteen
import de.ciluvien.mensen.data.local.CardBalance
import de.ciluvien.mensen.data.local.Position
import de.ciluvien.mensen.data.local.DailyMenu
import de.ciluvien.mensen.data.local.Organisation
import de.ciluvien.mensen.data.local.Meal

@Database(
    entities = [
        Canteen::class,
        DailyMenu::class,
        Meal::class,
        Organisation::class,
        Position::class,
        CardBalance::class,
        Bookmark::class],
    version = 6,
    autoMigrations = [
        AutoMigration(from = 1, to = 2),
        AutoMigration(from = 2, to = 3),
        AutoMigration(from = 3, to = 4),
        AutoMigration(from = 4, to = 5),
        AutoMigration(from = 5, to = 6)
    ]
)
@TypeConverters(Converters::class)
abstract class CanteenDatabase: RoomDatabase() {
    abstract val canteenDao: CanteenDao

    companion object {
        @Volatile
        private var INSTANCE: CanteenDatabase? = null

        fun getInstance(context: Context): CanteenDatabase {
            synchronized(this) {
                return INSTANCE ?: Room.databaseBuilder(
                    context.applicationContext,
                    CanteenDatabase::class.java,
                    "canteen_db"
                ).build().also {
                    INSTANCE = it
                }
            }
        }
    }
}