package de.ciluvien.mensen.ui.viewmodels

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import de.ciluvien.mensen.AppModule
import kotlinx.coroutines.flow.SharingStarted
import kotlinx.coroutines.flow.stateIn
import kotlinx.coroutines.launch

class SettingsViewModel(appModule: AppModule) : ViewModel() {
    private val settings = appModule.settings

    val isVegan = settings.isVeganFlow.stateIn(
        viewModelScope,
        SharingStarted.WhileSubscribed(5000L),
        false
    )
    val isVegetarian = settings.isVegetarianFlow.stateIn(
        viewModelScope,
        SharingStarted.WhileSubscribed(5000L),
        false
    )
    val isPescetarian = settings.isPescetarianFlow.stateIn(
        viewModelScope,
        SharingStarted.WhileSubscribed(5000L),
        false
    )
    val isUltraDark = settings.isUltraDarkFlow.stateIn(
        viewModelScope,
        SharingStarted.WhileSubscribed(5000L),
        false
    )
    val areAllergensVisible = settings.areAllergensVisibleFlow.stateIn(
        viewModelScope,
        SharingStarted.WhileSubscribed(5000L),
        false
    )

    fun setUltraDark(boolean: Boolean) {
        viewModelScope.launch {
            if (boolean) {
                settings.enableUltraDarkTheme()
            } else {
                settings.disableUltraDarkTheme()
            }
        }
    }

    fun setAllergensVisible(boolean: Boolean) {
        viewModelScope.launch {
            if (boolean) {
                settings.enableAllergensVisible()
            } else {
                settings.disableAllergensVisible()
            }
        }
    }

    private fun setVegan() {
        viewModelScope.launch {
            settings.enableVegan()
            settings.disableVegetarian()
            settings.disablePescetarian()
        }
    }

    private fun setVegetarian() {
        viewModelScope.launch {
            settings.disableVegan()
            settings.enableVegetarian()
            settings.disablePescetarian()
        }
    }

    private fun setPescetarian() {
        viewModelScope.launch {
            settings.disableVegan()
            settings.disableVegetarian()
            settings.enablePescetarian()
        }
    }

    private fun setEverything() {
        viewModelScope.launch {
            settings.disableVegan()
            settings.disableVegetarian()
            settings.disablePescetarian()
        }
    }

    enum class Filter() {
        VEGAN,
        VEGETARIAN,
        PESCETARIAN,
        EVERYTHING
    }

    private fun getFilter(): Filter {
        return if (isVegan.value) {
            Filter.VEGAN
        } else if (isVegetarian.value) {
            Filter.VEGETARIAN
        } else if (isPescetarian.value) {
            Filter.PESCETARIAN
        } else {
            Filter.EVERYTHING
        }
    }

    fun setFilter(ordinal: Int) {
        when(ordinal){
            Filter.EVERYTHING.ordinal -> setEverything()
            Filter.VEGETARIAN.ordinal -> setVegetarian()
            Filter.PESCETARIAN.ordinal -> setPescetarian()
            Filter.VEGAN.ordinal -> setVegan()
        }
    }
}