package de.ciluvien.mensen.ui.viewmodels

import androidx.compose.runtime.mutableStateOf
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import de.ciluvien.mensen.AppModule
import de.ciluvien.mensen.data.local.CardBalance
import de.ciluvien.mensen.ui.states.CardState
import kotlinx.coroutines.launch
import java.math.BigDecimal
import java.time.LocalDateTime

class CardViewModel(appModule: AppModule): ViewModel() {
    private val dao = appModule.canteenDao

    private var _cardState = mutableStateOf(CardState(null, emptyList()))
    val cardState = _cardState

    fun setCurrentBalance(balance: BigDecimal) {
        viewModelScope.launch {
            dao.insertCardBalance(CardBalance(LocalDateTime.now(), balance))
            setBalanceList()
            _cardState.value = _cardState.value.copy(
                currentBalance = balance,
            )
        }
    }

    suspend fun setBalanceList() {
        val cardBalanceList = dao.getCardBalanceList()
        val filterSize = 3
        if (cardBalanceList.size > filterSize) {
            cardBalanceList.filterIndexed { i, _ -> i > filterSize - 1 }
                .forEach{ dao.deleteCardBalance(it) }
        }
        _cardState.value = _cardState.value.copy(
            balanceList = dao.getCardBalanceList()
        )
    }
}