package de.ciluvien.mensen.ui.screens

import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.outlined.ArrowBack
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.Scaffold
import androidx.compose.material3.TopAppBarDefaults
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.input.nestedscroll.nestedScroll
import androidx.compose.ui.platform.LocalContext
import com.mikepenz.aboutlibraries.ui.compose.m3.LibrariesContainer
import de.ciluvien.mensen.R
import de.ciluvien.mensen.ui.components.core.CustomTextIcon
import de.ciluvien.mensen.ui.components.core.SingleActionTopAppBar

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun Libraries(onNavigateBack: () -> Unit) {
    val context = LocalContext.current
    val scrollBehavior = TopAppBarDefaults.pinnedScrollBehavior()
    Scaffold (
        modifier = Modifier.nestedScroll(scrollBehavior.nestedScrollConnection),
        topBar = {
            SingleActionTopAppBar(
                title = context.resources.getText(R.string.libraries_title).toString(),
                scrollBehavior = scrollBehavior,
                leftIcon = CustomTextIcon(
                    onClick = onNavigateBack,
                    icon = Icons.AutoMirrored.Outlined.ArrowBack,
                    description = context.resources.getText(R.string.settings_back).toString()
                )
            )
        }
    ) {padding ->
        LibrariesContainer(
            modifier = Modifier
                .fillMaxSize()
                .padding(padding)
        )
    }
}
