package de.ciluvien.mensen.ui.screens

import androidx.compose.foundation.gestures.detectTransformGestures
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.outlined.ArrowBack
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.Scaffold
import androidx.compose.runtime.Composable
import androidx.compose.runtime.mutableFloatStateOf
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.graphics.RectangleShape
import androidx.compose.ui.graphics.graphicsLayer
import androidx.compose.ui.input.pointer.pointerInput
import androidx.compose.ui.layout.onSizeChanged
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.unit.IntSize
import coil.compose.AsyncImage
import de.ciluvien.mensen.R
import de.ciluvien.mensen.ui.components.core.CustomTextIcon
import de.ciluvien.mensen.ui.components.core.SingleActionTopAppBar
import kotlin.math.absoluteValue

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun ImageScreen(onNavigateBack: () -> Unit, imageURL: String) {
    val context = LocalContext.current
    Scaffold (
        topBar = {
            SingleActionTopAppBar(
                title = "",
                leftIcon = CustomTextIcon(
                    onClick = onNavigateBack,
                    icon = Icons.AutoMirrored.Outlined.ArrowBack,
                    description = context.resources.getText(R.string.settings_back).toString()
                )
            )
        }
    ) {padding ->
        Column(
            modifier = Modifier.padding(padding).fillMaxSize(),
            verticalArrangement = Arrangement.Center,
            horizontalAlignment = Alignment.CenterHorizontally
        ){
            val minScale = 1f
            val maxScale = 3f
            val scale = remember { mutableFloatStateOf(1.2f) }
            val translationX = remember { mutableFloatStateOf(0f) }
            val translationY = remember { mutableFloatStateOf(0f) }
            val size = remember { mutableStateOf(IntSize.Zero) }
            Box(
                modifier = Modifier
                    .clip(RectangleShape)
                    .fillMaxSize()
                    .onSizeChanged { size.value = it }
                    .pointerInput(Unit) {
                        detectTransformGestures { _, pan, zoom, _ ->
                            scale.floatValue = maxOf(minScale, minOf(scale.floatValue * zoom.absoluteValue, maxScale))
                            val maxX = (size.value.width * (scale.floatValue - 1)) / 2
                            val minX = -maxX
                            translationX.floatValue = maxOf(minX, minOf(maxX, translationX.floatValue + pan.x))
                            val maxY = (size.value.height * (scale.floatValue - 1)) / 2
                            val minY = -maxY
                            translationY.floatValue = maxOf(minY, minOf(maxY, translationY.floatValue + pan.y))
                        }
                    }
            ) {
                AsyncImage(
                    model = imageURL,
                    contentDescription = context.resources.getText(R.string.meal_image).toString(),
                    modifier = Modifier
                        .align(Alignment.Center)
                        .graphicsLayer(
                            scaleX = scale.floatValue.coerceIn(minScale, maxScale),
                            scaleY = scale.floatValue.coerceIn(minScale, maxScale),
                            translationX = translationX.floatValue,
                            translationY = translationY.floatValue
                        ),
                )
            }
        }
    }
}