package de.ciluvien.mensen.ui.components.settings

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.rememberScrollState
import androidx.compose.foundation.verticalScroll
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.TopAppBarDefaults
import androidx.compose.material3.TopAppBarScrollBehavior
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.input.nestedscroll.nestedScroll
import androidx.compose.ui.unit.dp
import de.ciluvien.mensen.ui.viewmodels.SettingsViewModel

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun Settings(
    onNavigateLibraries: () -> Unit,
    settingsViewModel: SettingsViewModel,
    scrollBehavior: TopAppBarScrollBehavior = TopAppBarDefaults.pinnedScrollBehavior()
) {
    Column(
        verticalArrangement = Arrangement.spacedBy(10.dp) ,
        modifier = Modifier
            .verticalScroll(rememberScrollState())
            .padding(5.dp, 10.dp)
            .nestedScroll(scrollBehavior.nestedScrollConnection)
    ) {
        Filters(settingsViewModel)
        Appearance(settingsViewModel)
        About(onNavigateLibraries)
        Share()
    }
}