package de.ciluvien.mensen.ui.components.core

import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.TopAppBarDefaults
import androidx.compose.material3.TopAppBarScrollBehavior
import androidx.compose.runtime.Composable

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun SingleActionTopAppBar(
    title: String,
    scrollBehavior: TopAppBarScrollBehavior = TopAppBarDefaults.pinnedScrollBehavior(),
    leftIcon: CustomTextIcon? = null,
    rightIcon: CustomTextIcon? = null
) {
    MultiActionTopAppBar(
        title,
        scrollBehavior,
        leftIcon,
        if (rightIcon != null) listOf(rightIcon) else emptyList()
    )
}

