package de.ciluvien.mensen.ui.components.core

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material3.Icon
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp

@Composable
fun IconRow(iconId: Int, iconDescription: String, text: List<String>) {
    Row(
        modifier = Modifier.padding(10.dp),
        verticalAlignment = Alignment.Top
    ) {
        Icon(
            painter = painterResource(id = iconId),
            contentDescription = iconDescription,
        )
        Spacer(modifier = Modifier.size(10.dp))
        Column(
            horizontalAlignment = Alignment.Start
        ) {
            text.forEach{line ->
                Text(
                    text = line.trim(),
                    style = MaterialTheme.typography.bodyLarge
                )
            }
        }
    }
}
