package de.ciluvien.mensen.data.settings

import android.content.Context
import androidx.datastore.core.DataStore
import androidx.datastore.preferences.core.Preferences
import androidx.datastore.preferences.core.booleanPreferencesKey
import androidx.datastore.preferences.core.edit
import androidx.datastore.preferences.preferencesDataStore
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.map

class SettingsService(private val context: Context) {

    private val Context.dataStore: DataStore<Preferences> by preferencesDataStore(name = "settings")
    private object SettingsKeys {
        val isVegetarian = booleanPreferencesKey("vegetarian")
        val isVegan = booleanPreferencesKey("vegan")
        val isPescetarian = booleanPreferencesKey("pescetarian")
        val isUltraDarkTheme = booleanPreferencesKey("oled")
        val areAllergensVisible = booleanPreferencesKey("allergens")
    }

    suspend fun enablePescetarian() {
        context.dataStore.edit {
            it[SettingsKeys.isPescetarian] = true
        }
    }

    suspend fun disablePescetarian() {
        context.dataStore.edit {
            it[SettingsKeys.isPescetarian] = false
        }
    }

    suspend fun enableVegetarian() {
        context.dataStore.edit {
            it[SettingsKeys.isVegetarian] = true
        }
    }

    suspend fun disableVegetarian() {
        context.dataStore.edit {
            it[SettingsKeys.isVegetarian] = false
        }
    }

    suspend fun enableVegan() {
        context.dataStore.edit {
            it[SettingsKeys.isVegan] = true
        }
    }

    suspend fun disableVegan() {
        context.dataStore.edit {
            it[SettingsKeys.isVegan] = false
        }
    }

    suspend fun enableUltraDarkTheme() {
        context.dataStore.edit {
            it[SettingsKeys.isUltraDarkTheme] = true
        }
    }

    suspend fun disableUltraDarkTheme() {
        context.dataStore.edit {
            it[SettingsKeys.isUltraDarkTheme] = false
        }
    }

    suspend fun enableAllergensVisible() {
        context.dataStore.edit {
            it[SettingsKeys.areAllergensVisible] = true
        }
    }

    suspend fun disableAllergensVisible() {
        context.dataStore.edit {
            it[SettingsKeys.areAllergensVisible] = false
        }
    }

    val isVeganFlow: Flow<Boolean> = context.dataStore.data.map {
        it[SettingsKeys.isVegan] ?: false
    }

    val isVegetarianFlow: Flow<Boolean> = context.dataStore.data.map {
        it[SettingsKeys.isVegetarian] ?: false
    }

    val isPescetarianFlow: Flow<Boolean> = context.dataStore.data.map {
        it[SettingsKeys.isPescetarian] ?: false
    }

    val isUltraDarkFlow: Flow<Boolean> = context.dataStore.data.map {
        it[SettingsKeys.isUltraDarkTheme] ?: false
    }

    val areAllergensVisibleFlow: Flow<Boolean> = context.dataStore.data.map {
        it[SettingsKeys.areAllergensVisible] ?: false
    }
}