package de.ciluvien.mensen.data.local

import androidx.room.Entity
import androidx.room.PrimaryKey
import java.time.LocalDateTime

@Entity
data class Organisation(
    @PrimaryKey
    val name: String,
    var canteenRefreshDateTime: LocalDateTime? = null
) {
    fun areCanteensStale(): Boolean {
        return canteenRefreshDateTime?.isBefore(LocalDateTime.now().minusDays(7))
            ?: true
    }
}