package de.ciluvien.mensen.data.local

import androidx.room.Entity
import java.time.LocalDate
import java.time.LocalDateTime

@Entity(primaryKeys = ["date", "canteenId"])
data class DailyMenu(
    val date: LocalDate,
    val closed: Boolean,
    val canteenId: Int,
    var mealRefreshDateTime: LocalDateTime?
){
    fun areMealsStale(): Boolean {
        return mealRefreshDateTime?.isBefore(LocalDateTime.now().minusMinutes(10))
            ?: true
    }
}

