package de.ciluvien.mensen.data

import androidx.room.TypeConverter
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import java.math.BigDecimal
import java.time.LocalDate
import java.time.LocalDateTime
import java.time.LocalTime

class Converters {
    @TypeConverter
    fun fromMapStringBigDecimal(map: Map<String,BigDecimal>?): String {
        return Gson().toJson(map)
    }

    @TypeConverter
    fun stringToMapStringBigDecimal(string: String): Map<String, BigDecimal> {
        val type = object: TypeToken<Map<String, BigDecimal>>() {}.type
        return Gson().fromJson(string, type)
    }

    @TypeConverter
    fun fromMapStringString(map: Map<String,String>?): String {
        return Gson().toJson(map)
    }

    @TypeConverter
    fun stringToMapStringString(string: String): Map<String, String> {
        val type = object: TypeToken<Map<String, String>>() {}.type
        return Gson().fromJson(string, type)
    }

    @TypeConverter
    fun dateFromString(string: String): LocalDate {
        return LocalDate.parse(string)
    }

    @TypeConverter
    fun dateToString(date: LocalDate): String {
        return date.toString()
    }

    @TypeConverter
    fun timeFromString(string: String): LocalTime {
        return LocalTime.parse(string)
    }

    @TypeConverter
    fun timeToString(time: LocalTime): String {
        return time.toString()
    }

    @TypeConverter
    fun dateTimeFromString(string: String): LocalDateTime {
        return LocalDateTime.parse(string)
    }

    @TypeConverter
    fun dateTimeToString(dateTime: LocalDateTime): String {
        return dateTime.toString()
    }

    @TypeConverter
    fun doubleListToString(list: List<Double>): String {
        return list.toString()
    }

    @TypeConverter
    fun doubleListFromString(string: String): List<Double> {
        return string.drop(1).dropLast(1).split(",").map { it.toDouble() }
    }

    @TypeConverter
    fun stringListToString(list: List<String>): String {
        return list.toString()
    }

    @TypeConverter
    fun stringListFromString(string: String): List<String> {
        return string.drop(1).dropLast(1).split(",").map { it.trim() }.filter { it.isNotBlank() }
    }

    @TypeConverter
    fun bigDecimalToString(bigDecimal: BigDecimal): String {
        return bigDecimal.toString()
    }

    @TypeConverter
    fun bigDecimalFromString(string: String): BigDecimal {
        return string.toBigDecimal()
    }
}