package de.ciluvien.mensen

import android.content.Context
import de.ciluvien.mensen.data.CanteenDao
import de.ciluvien.mensen.data.CanteenDatabase
import de.ciluvien.mensen.data.DataService
import de.ciluvien.mensen.data.remote.OpenMensaService
import de.ciluvien.mensen.data.settings.SettingsService

interface AppModule {
    val openMensaApi: OpenMensaService
    val canteenDao: CanteenDao
    val dataService: DataService
    val settings: SettingsService
}

class AppModuleImpl (
    private val appContext: Context
) : AppModule {
    override val openMensaApi: OpenMensaService by lazy{
        OpenMensaService.create(appContext)
    }
    override val canteenDao: CanteenDao by lazy {
        CanteenDatabase.getInstance(context = appContext).canteenDao
    }
    override val dataService: DataService by lazy {
        DataService(canteenDao, openMensaApi)
    }
    override val settings: SettingsService by lazy {
        SettingsService(appContext)
    }
}