/*
 * Copyright by the original author or authors.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package de.ccc.events.badge.card10.mood

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import de.ccc.events.badge.card10.PersonalState
import de.ccc.events.badge.card10.R
import de.ccc.events.badge.card10.common.ConnectionService
import kotlinx.android.synthetic.main.mood_fragment.*

@ExperimentalUnsignedTypes
class MoodFragment : Fragment() {
    private val card10Service = ConnectionService.card10Service

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.mood_fragment, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        mood_chaos.setOnClickListener{
            card10Service?.setPersonalState(PersonalState.CHAOS)
        }
        mood_communication.setOnClickListener{
            card10Service?.setPersonalState(PersonalState.COMMUNICATION)
        }
        mood_camp.setOnClickListener{
            card10Service?.setPersonalState(PersonalState.CAMP)
        }
        no_contact.setOnClickListener{
            card10Service?.setPersonalState(PersonalState.NO_CONTACT)
        }
        no_state.setOnClickListener{
            card10Service?.setPersonalState(PersonalState.NONE)
        }
    }
}
