/*
 * Copyright by the original author or authors.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package de.ccc.events.badge.card10

import java.util.*

const val CARD10_BLUETOOTH_MAC_PREFIX = "CA:4D:10"

val GENERIC_ACCESS_SERVICE_UUID = UUID.fromString("00001800-0000-1000-8000-00805f9b34fb")
val DEVICE_NAME_CHARACTERISTIC_UUID = UUID.fromString("00002a00-0000-1000-8000-00805f9b34fb")

// Card10 File SVC
val FILE_SERVICE_UUID = UUID.fromString("42230100-2342-2342-2342-234223422342")
val FILE_TX_UUID = UUID.fromString("42230101-2342-2342-2342-234223422342")
val FILE_RX_UUID = UUID.fromString("42230102-2342-2342-2342-234223422342")

// Card10 SVC
val CARD10_SERVICE_UUID = UUID.fromString("42230200-2342-2342-2342-234223422342")
val TIME_CHARACTERISTIC_UUID = UUID.fromString("42230201-2342-2342-2342-234223422342")

val VIBRA_CHARACTERISTIC_UUID = UUID.fromString("4223020f-2342-2342-2342-234223422342")
val ROCKETS_CHARACTERISTIC_UUID = UUID.fromString("42230210-2342-2342-2342-234223422342")
val BG_LED_BOTTOM_LEFT_CHARACTERISTIC_UUID = UUID.fromString("42230211-2342-2342-2342-234223422342")
val BG_LED_BOTTOM_RIGHT_CHARACTERISTIC_UUID = UUID.fromString("42230212-2342-2342-2342-234223422342")
val BG_LED_TOP_RIGHT_CHARACTERISTIC_UUID = UUID.fromString("42230213-2342-2342-2342-234223422342")
val BG_LED_TOP_LEFT_CHARACTERISTIC_UUID = UUID.fromString("42230214-2342-2342-2342-234223422342")
val DIM_BOTTOM_CHARACTERISTIC_UUID = UUID.fromString("42230215-2342-2342-2342-234223422342")
val DIM_TOP_CHARACTERISTIC_UUID = UUID.fromString("42230216-2342-2342-2342-234223422342")
val LEDS_POWERSAFE_CHARACTERISTIC_UUID = UUID.fromString("42230217-2342-2342-2342-234223422342")
val FLASHLIGHT_CHARACTERISTIC_UUID = UUID.fromString("42230218-2342-2342-2342-234223422342")
val PERSONAL_STATE_CHARACTERISTIC_UUID = UUID.fromString("42230219-2342-2342-2342-234223422342")

enum class PersonalState(val v: Int) {
    NONE(0x0000),
    NO_CONTACT(0x0100),
    CHAOS(0x0200),
    COMMUNICATION(0x0300),
    CAMP(0x0400)
}

val LEDS_ABOVE_CHARACTERISTIC_UUID = UUID.fromString("42230220-2342-2342-2342-234223422342")

val LIGHT_SENSOR_CHARACTERISTIC_UUID = UUID.fromString("422302f0-2342-2342-2342-234223422342")

const val UPDATE_CLOCK_FREQUENCY_MINS = 5

const val HATCHERY_BASE_URL = "https://badge.team"
