---
hide:
  - navigation
---

# Privacy statement

Vespucci is a collaboratively developed app for editing OpenStreetMap data via its editing API. The developers do not collect, store or otherwise process any personal data related to your usage of the app, you should however be aware of the following:

* Using the OpenStreetMap Foundations infrastructure and contributing to OpenStreetMap is subject to the [OSMFs privacy policy](https://wiki.osmfoundation.org/wiki/Privacy_Policy) and [Terms of Use](https://wiki.osmfoundation.org/wiki/Terms_of_Use), you should have studied these when you created your OpenStreetMap account and should be aware of the privacy consequences.
* Vespucci automatically adds an indication of the app name and version ( __created_by__ changeset tag), the background imagery used ( __imagery_used__ changeset tag) and the locale (language) setting of your device ( __locale__ changeset tag), and a summary of your edits. This information is currently visible to anybody visiting the openstreetmap.org website or processing changeset data.
* The vespucci.io site and the Vespucci source code repository and issue tracker is hosted on [github (likely in the USA)](https://help.github.com/articles/github-privacy-statement/) the developers have no access to any data on use of the site, IP addresses or similar.
* Using the _Provide feedback_ functionality without a github account will create an issue that contains information on your device (you can review that prior to submitting the data) and, if available, your OpenStreetMap display name so that we can contact you with any questions. You can have the information removed by sending mail to the e-mail address below. Processing of this data is based on a legitimate interest of the developers see [GDPR Art 6.(1) f)](https://gdpr-info.eu/art-6-gdpr/).
* Crash dumps contain IP addresses, detailed information on your device and log information from your device immediately before the crash. This information is stored on a server operated by Simon Poole and located in Germany, when you submit a report. The information is deleted after 90 days if it is not required further for issue identification and resolution, general web server logfiles are retained for 15 days. None of this data is shared with 3rd parties. Processing of this data is based on a legitimate interest of the developers see [GDPR Art 6.(1) f)](https://gdpr-info.eu/art-6-gdpr/).
* Updating background, overlay and other layers will result in your device connecting to the [JOSM project](https://josm.openstreetmap.de) or [Editor Layer Index github repo](https://github.com/osmlab/editor-layer-index) and using the layers will connect you to the sites of the respective operators. More information on the provenance of such layers can be found via the per layer information displays, or from the respective source repositories.
* Using the Tasks layer can result in your device connecting to the OSMOSE QA service operated by [OpenStreetMap France](http://openstreetmap.fr/).
* Accessing the OpenAerialMap catalogue and retrieving imagery from the service will transmit your IP address and other information to its operator, which might be governed by this [privacy policy](https://www.hotosm.org/privacy).
* Using the Mapillary layer will connect your devices to services operated by Mapillary AB, Sweden, [privacy policy](https://www.mapillary.com/privacy).
* The Panoramax meta-catalogue and overview layer are operated by [OpenStreetMap France](http://openstreetmap.fr/). Panoramax instances have individual operators and you will need to check their privacy policies for more details, in particular you should determine your personal liability exposure for content you upload that could violate privacy and intellectual property regulations at least where you generated it and at your domicile.
* Wikimedia Commons is operated by the [Wikimedia Foundation, Inc. California, USA](https://wikimediafoundation.org/contact/), [WMF privacy policy](https://wikimediafoundation.org/privacy-policy/). As Wikimedia Commons does not  support any measures to ensure uploaded content does not display any privacy sensitive information, you should avoid uploading content that contains such. As above you need to determine your personal liability exposure for any such uploaded content.   
* Installing the app from Amazon, google or F-Droid requires you to access these sites and potentially submit personal data (at least IP addresses) to them. 
* Recording a GPX track, or starting location based auto-download, will lead to a service continuously updating your current position, including when you navigate away from the app for example by starting a different application. If GPX recording is enabled the location information will be stored on your device until you explicitly clear it or de-install the app. Such location access will stop if you either turn recording or auto-download off, or exit the app. No location information is made available to the Vespucci developers or other third parties. It is at your sole discretion how to use the recorded location data, for example if you upload it to OpenStreetMap or if you use it simply for private documentation. A notification is persistently displayed as long as the service is actively using location data. 
* Background and overlay layers are generally operated by third parties over which we have no control. Links to their privacy policies are provided if available. A one time metadata retrieval call per session is required for use of the Bing orthoimagery layer, this happens in an asynchronous fashion when imagery is being configured regardless if you are using the Bing layer or not. You can disable this behaviour by removing the Bing key from the configuration, see the FAQs for more information. 

If you have questions with respect to this document, please feel free to contact us at privacy@vespucci.io

November 5th 2025
