/*
 *    Copyright 2023, Petr Laštovička as Lasta apps, All rights reserved
 *
 *     This file is part of Menza.
 *
 *     Menza is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Menza is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Menza.  If not, see <https://www.gnu.org/licenses/>.
 */

package cz.lastaapps.scraping

import io.ktor.client.HttpClient
import io.ktor.client.plugins.DefaultRequest
import io.ktor.client.plugins.HttpRequestRetry
import io.ktor.client.request.url

internal const val backendUrlTest = "https://agata-new.suz.cvut.cz/jidelnicky/"
internal const val backendUrlNormal = "https://agata.suz.cvut.cz/jidelnicky/"

internal val agataClient = HttpClient() {
    install(DefaultRequest) {
        url(backendUrlNormal)
    }

    // delete after the migration to API
    install(HttpRequestRetry) {
        retryOnException(
            maxRetries = 1,
            retryOnTimeout = false,
        )
        modifyRequest {
            it.url(backendUrlTest)
        }
    }
}
