/*
 *    Copyright 2025, Petr Laštovička as Lasta apps, All rights reserved
 *
 *     This file is part of Menza.
 *
 *     Menza is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Menza is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Menza.  If not, see <https://www.gnu.org/licenses/>.
 */

package cz.lastaapps.core.di

import cz.lastaapps.core.data.httpClient
import cz.lastaapps.core.domain.UCContext
import cz.lastaapps.core.domain.usecase.GetAppVersionUC
import cz.lastaapps.core.domain.usecase.IsOnMeteredUC
import cz.lastaapps.core.domain.usecase.OpenAppSocialUC
import kotlinx.coroutines.Dispatchers
import org.koin.core.module.Module
import org.koin.core.module.dsl.factoryOf
import org.koin.dsl.bind
import org.koin.dsl.module
import kotlin.time.Clock

internal expect val platform: Module

val coreModule =
    module {
        includes(platform)

        single { Clock.System } bind Clock::class
        single { UCContext(Dispatchers.Default) }
        single { httpClient }

        factoryOf(::GetAppVersionUC)
        factoryOf(::IsOnMeteredUC)
        factoryOf(::OpenAppSocialUC)
    }
