/*
 *    Copyright 2023, Petr Laštovička as Lasta apps, All rights reserved
 *
 *     This file is part of Menza.
 *
 *     Menza is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Menza is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Menza.  If not, see <https://www.gnu.org/licenses/>.
 */

package cz.lastaapps.menza.ui.theme

import androidx.compose.ui.unit.dp

object Padding {
    val None = 0.dp
    val Tiny = 2.dp
    val Smaller = 4.dp
    val Small = 8.dp
    val MidSmall = 12.dp
    val Medium = 16.dp
    val MidLarge = 24.dp
    val Large = 32.dp

    object More {
        val Screen = MidSmall
        val Dialog = Medium
        val ScrollBottomSpace = 64.dp
        val Icon = 24.dp
        val MaxColumnWidth = (256 + 32).dp
    }
}
