/*
 *    Copyright 2024, Petr Laštovička as Lasta apps, All rights reserved
 *
 *     This file is part of Menza.
 *
 *     Menza is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Menza is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Menza.  If not, see <https://www.gnu.org/licenses/>.
 */

package cz.lastaapps.menza.features.main.ui.widgets

import androidx.compose.animation.Crossfade
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import arrow.core.None
import arrow.core.Option
import arrow.core.Some
import cz.lastaapps.api.core.domain.model.Menza
import cz.lastaapps.menza.R

@Composable
fun WrapMenzaNotSelected(
    menza: Option<Menza>?,
    onOsturak: () -> Unit,
    modifier: Modifier = Modifier,
    content: @Composable () -> Unit,
) {
    Crossfade(
        targetState = menza,
        modifier = modifier,
    ) { current ->
        when (current) {
            None ->
                MenzaNotSelected(
                    onOsturak = onOsturak,
                    modifier = Modifier.fillMaxSize(),
                )

            is Some ->
                content()

            null -> {}
        }
    }
}

@Composable
fun MenzaNotSelected(
    onOsturak: () -> Unit,
    modifier: Modifier = Modifier,
) {
    Box(modifier, contentAlignment = Alignment.Center) {
        Column(
            verticalArrangement = Arrangement.spacedBy(8.dp),
            horizontalAlignment = Alignment.CenterHorizontally,
        ) {
            Column(
                verticalArrangement = Arrangement.spacedBy(8.dp),
                horizontalAlignment = Alignment.CenterHorizontally,
            ) {
                Text(stringResource(R.string.menza_none_selected))

                Text(
                    stringResource(R.string.menza_none_swipe),
                    style = MaterialTheme.typography.bodySmall,
                )
            }
            TextButton(onClick = onOsturak) {
                Text(stringResource(R.string.menza_none_osturak))
            }
        }
    }
}
