import 'package:flutter/foundation.dart';

import '../api/core.dart';
import '../api/notifications.dart';
import '../api/route/notifications.dart';
import '../log.dart';
import '../model/binding.dart';
import 'display.dart';
import 'open.dart';

@pragma('vm:entry-point')
class NotificationService {
  static NotificationService get instance => (_instance ??= NotificationService._());
  static NotificationService? _instance;

  NotificationService._();

  /// Reset the state of the [NotificationService], for testing.
  ///
  /// TODO refactor this better, perhaps unify with ZulipBinding
  @visibleForTesting
  static void debugReset() {
    instance.token.dispose();
    _instance = null;
    assert(debugBackgroundIsolateIsLive = true);
    NotificationOpenService.debugReset();
  }

  /// Whether a background isolate should initialize [LiveZulipBinding].
  ///
  /// will be invoked in a background isolate where it must set up its
  /// [ZulipBinding], just as the `main` function does for most of the app.
  /// Consequently, by default we have that callback initialize
  /// [LiveZulipBinding], just like `main` does.
  ///
  /// In a test that behavior is undesirable.  Tests that will cause
  /// to get invoked should therefore set this to false.
  static bool debugBackgroundIsolateIsLive = true;

  /// The FCM registration token for this install of the app.
  ///
  /// This is unique to the (app, device) pair, but not permanent.
  /// Most often it's the same from one run of the app to the next,
  /// but it can change either during a run or between them.
  ///
  /// See also:
  ///  * Upstream docs on FCM registration tokens in general:
  ValueNotifier<String?> token = ValueNotifier(null);

  Future<void> start() async {
    switch (defaultTargetPlatform) {
      case TargetPlatform.android:























      case TargetPlatform.iOS: // TODO(#324): defer requesting notif permission















      case TargetPlatform.linux:
      case TargetPlatform.macOS:
      case TargetPlatform.windows:
      case TargetPlatform.fuchsia:
        // Do nothing; we don't offer notifications on these platforms.
        break;
    }
  }





  Future<void> registerToken(ApiConnection connection) async {
    final token = this.token.value;
    if (token == null) return;

    switch (defaultTargetPlatform) {
      case TargetPlatform.android:


      case TargetPlatform.iOS:





      case TargetPlatform.linux:
      case TargetPlatform.macOS:
      case TargetPlatform.windows:
      case TargetPlatform.fuchsia:
        assert(false);
    }
  }

  static Future<void> unregisterToken(ApiConnection connection, {required String token}) async {
    switch (defaultTargetPlatform) {
      case TargetPlatform.android:


      case TargetPlatform.iOS:


      case TargetPlatform.linux:
      case TargetPlatform.macOS:
      case TargetPlatform.windows:
      case TargetPlatform.fuchsia:
        assert(false);
    }
  }


  // This pragma `vm:entry-point` is needed in release mode, when this method
  // is needed at all (i.e. on Android):
  //   https://github.com/zulip/zulip-flutter/issues/528#issuecomment-1960646800
  
}
