// dart format width=80
import 'package:drift/internal/versioned_schema.dart' as i0;
import 'package:drift/drift.dart' as i1;
import 'package:drift/drift.dart'; // ignore_for_file: type=lint,unused_import

// GENERATED BY drift_dev, DO NOT MODIFY.
final class Schema2 extends i0.VersionedSchema {
  Schema2({required super.database}) : super(version: 2);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [accounts];
  late final Shape0 accounts = Shape0(
    source: i0.VersionedTable(
      entityName: 'accounts',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [
        'UNIQUE(realm_url, user_id)',
        'UNIQUE(realm_url, email)',
      ],
      columns: [
        _column_0,
        _column_1,
        _column_2,
        _column_3,
        _column_4,
        _column_5,
        _column_6,
        _column_7,
        _column_8,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
}

class Shape0 extends i0.VersionedTable {
  Shape0({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get realmUrl =>
      columnsByName['realm_url']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get userId =>
      columnsByName['user_id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get email =>
      columnsByName['email']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get apiKey =>
      columnsByName['api_key']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get zulipVersion =>
      columnsByName['zulip_version']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get zulipMergeBase =>
      columnsByName['zulip_merge_base']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get zulipFeatureLevel =>
      columnsByName['zulip_feature_level']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get ackedPushToken =>
      columnsByName['acked_push_token']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<int> _column_0(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'id',
      aliasedName,
      false,
      hasAutoIncrement: true,
      type: i1.DriftSqlType.int,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'PRIMARY KEY AUTOINCREMENT',
      ),
    );
i1.GeneratedColumn<String> _column_1(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'realm_url',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<int> _column_2(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'user_id',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<String> _column_3(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'email',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_4(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'api_key',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_5(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'zulip_version',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_6(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'zulip_merge_base',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<int> _column_7(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'zulip_feature_level',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<String> _column_8(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'acked_push_token',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );

final class Schema3 extends i0.VersionedSchema {
  Schema3({required super.database}) : super(version: 3);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    globalSettings,
    accounts,
  ];
  late final Shape1 globalSettings = Shape1(
    source: i0.VersionedTable(
      entityName: 'global_settings',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [],
      columns: [_column_9],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape0 accounts = Shape0(
    source: i0.VersionedTable(
      entityName: 'accounts',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [
        'UNIQUE(realm_url, user_id)',
        'UNIQUE(realm_url, email)',
      ],
      columns: [
        _column_0,
        _column_1,
        _column_2,
        _column_3,
        _column_4,
        _column_5,
        _column_6,
        _column_7,
        _column_8,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
}

class Shape1 extends i0.VersionedTable {
  Shape1({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get themeSetting =>
      columnsByName['theme_setting']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_9(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'theme_setting',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );

final class Schema4 extends i0.VersionedSchema {
  Schema4({required super.database}) : super(version: 4);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    globalSettings,
    accounts,
  ];
  late final Shape2 globalSettings = Shape2(
    source: i0.VersionedTable(
      entityName: 'global_settings',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [],
      columns: [_column_9, _column_10],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape0 accounts = Shape0(
    source: i0.VersionedTable(
      entityName: 'accounts',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [
        'UNIQUE(realm_url, user_id)',
        'UNIQUE(realm_url, email)',
      ],
      columns: [
        _column_0,
        _column_1,
        _column_2,
        _column_3,
        _column_4,
        _column_5,
        _column_6,
        _column_7,
        _column_8,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
}

class Shape2 extends i0.VersionedTable {
  Shape2({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get themeSetting =>
      columnsByName['theme_setting']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get browserPreference =>
      columnsByName['browser_preference']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_10(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'browser_preference',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );

final class Schema5 extends i0.VersionedSchema {
  Schema5({required super.database}) : super(version: 5);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    globalSettings,
    accounts,
  ];
  late final Shape2 globalSettings = Shape2(
    source: i0.VersionedTable(
      entityName: 'global_settings',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [],
      columns: [_column_9, _column_10],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape0 accounts = Shape0(
    source: i0.VersionedTable(
      entityName: 'accounts',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [
        'UNIQUE(realm_url, user_id)',
        'UNIQUE(realm_url, email)',
      ],
      columns: [
        _column_0,
        _column_1,
        _column_2,
        _column_3,
        _column_4,
        _column_5,
        _column_6,
        _column_7,
        _column_8,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
}

final class Schema6 extends i0.VersionedSchema {
  Schema6({required super.database}) : super(version: 6);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    globalSettings,
    boolGlobalSettings,
    accounts,
  ];
  late final Shape2 globalSettings = Shape2(
    source: i0.VersionedTable(
      entityName: 'global_settings',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [],
      columns: [_column_9, _column_10],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape3 boolGlobalSettings = Shape3(
    source: i0.VersionedTable(
      entityName: 'bool_global_settings',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: ['PRIMARY KEY(name)'],
      columns: [_column_11, _column_12],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape0 accounts = Shape0(
    source: i0.VersionedTable(
      entityName: 'accounts',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [
        'UNIQUE(realm_url, user_id)',
        'UNIQUE(realm_url, email)',
      ],
      columns: [
        _column_0,
        _column_1,
        _column_2,
        _column_3,
        _column_4,
        _column_5,
        _column_6,
        _column_7,
        _column_8,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
}

class Shape3 extends i0.VersionedTable {
  Shape3({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get value =>
      columnsByName['value']! as i1.GeneratedColumn<bool>;
}

i1.GeneratedColumn<String> _column_11(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'name',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<bool> _column_12(String aliasedName) =>
    i1.GeneratedColumn<bool>(
      'value',
      aliasedName,
      false,
      type: i1.DriftSqlType.bool,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'CHECK ("value" IN (0, 1))',
      ),
    );

final class Schema7 extends i0.VersionedSchema {
  Schema7({required super.database}) : super(version: 7);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    globalSettings,
    boolGlobalSettings,
    accounts,
  ];
  late final Shape4 globalSettings = Shape4(
    source: i0.VersionedTable(
      entityName: 'global_settings',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [],
      columns: [_column_9, _column_10, _column_13],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape3 boolGlobalSettings = Shape3(
    source: i0.VersionedTable(
      entityName: 'bool_global_settings',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: ['PRIMARY KEY(name)'],
      columns: [_column_11, _column_12],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape0 accounts = Shape0(
    source: i0.VersionedTable(
      entityName: 'accounts',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [
        'UNIQUE(realm_url, user_id)',
        'UNIQUE(realm_url, email)',
      ],
      columns: [
        _column_0,
        _column_1,
        _column_2,
        _column_3,
        _column_4,
        _column_5,
        _column_6,
        _column_7,
        _column_8,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
}

class Shape4 extends i0.VersionedTable {
  Shape4({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get themeSetting =>
      columnsByName['theme_setting']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get browserPreference =>
      columnsByName['browser_preference']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get visitFirstUnread =>
      columnsByName['visit_first_unread']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_13(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'visit_first_unread',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );

final class Schema8 extends i0.VersionedSchema {
  Schema8({required super.database}) : super(version: 8);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    globalSettings,
    boolGlobalSettings,
    accounts,
  ];
  late final Shape5 globalSettings = Shape5(
    source: i0.VersionedTable(
      entityName: 'global_settings',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [],
      columns: [_column_9, _column_10, _column_13, _column_14],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape3 boolGlobalSettings = Shape3(
    source: i0.VersionedTable(
      entityName: 'bool_global_settings',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: ['PRIMARY KEY(name)'],
      columns: [_column_11, _column_12],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape0 accounts = Shape0(
    source: i0.VersionedTable(
      entityName: 'accounts',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [
        'UNIQUE(realm_url, user_id)',
        'UNIQUE(realm_url, email)',
      ],
      columns: [
        _column_0,
        _column_1,
        _column_2,
        _column_3,
        _column_4,
        _column_5,
        _column_6,
        _column_7,
        _column_8,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
}

class Shape5 extends i0.VersionedTable {
  Shape5({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get themeSetting =>
      columnsByName['theme_setting']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get browserPreference =>
      columnsByName['browser_preference']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get visitFirstUnread =>
      columnsByName['visit_first_unread']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get markReadOnScroll =>
      columnsByName['mark_read_on_scroll']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_14(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'mark_read_on_scroll',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );

final class Schema9 extends i0.VersionedSchema {
  Schema9({required super.database}) : super(version: 9);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    globalSettings,
    boolGlobalSettings,
    accounts,
  ];
  late final Shape6 globalSettings = Shape6(
    source: i0.VersionedTable(
      entityName: 'global_settings',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [],
      columns: [_column_9, _column_10, _column_13, _column_14, _column_15],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape3 boolGlobalSettings = Shape3(
    source: i0.VersionedTable(
      entityName: 'bool_global_settings',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: ['PRIMARY KEY(name)'],
      columns: [_column_11, _column_12],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape0 accounts = Shape0(
    source: i0.VersionedTable(
      entityName: 'accounts',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [
        'UNIQUE(realm_url, user_id)',
        'UNIQUE(realm_url, email)',
      ],
      columns: [
        _column_0,
        _column_1,
        _column_2,
        _column_3,
        _column_4,
        _column_5,
        _column_6,
        _column_7,
        _column_8,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
}

class Shape6 extends i0.VersionedTable {
  Shape6({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get themeSetting =>
      columnsByName['theme_setting']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get browserPreference =>
      columnsByName['browser_preference']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get visitFirstUnread =>
      columnsByName['visit_first_unread']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get markReadOnScroll =>
      columnsByName['mark_read_on_scroll']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get legacyUpgradeState =>
      columnsByName['legacy_upgrade_state']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_15(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'legacy_upgrade_state',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );

final class Schema10 extends i0.VersionedSchema {
  Schema10({required super.database}) : super(version: 10);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    globalSettings,
    boolGlobalSettings,
    intGlobalSettings,
    accounts,
  ];
  late final Shape6 globalSettings = Shape6(
    source: i0.VersionedTable(
      entityName: 'global_settings',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [],
      columns: [_column_9, _column_10, _column_13, _column_14, _column_15],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape3 boolGlobalSettings = Shape3(
    source: i0.VersionedTable(
      entityName: 'bool_global_settings',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: ['PRIMARY KEY(name)'],
      columns: [_column_11, _column_12],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape7 intGlobalSettings = Shape7(
    source: i0.VersionedTable(
      entityName: 'int_global_settings',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: ['PRIMARY KEY(name)'],
      columns: [_column_11, _column_16],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape0 accounts = Shape0(
    source: i0.VersionedTable(
      entityName: 'accounts',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [
        'UNIQUE(realm_url, user_id)',
        'UNIQUE(realm_url, email)',
      ],
      columns: [
        _column_0,
        _column_1,
        _column_2,
        _column_3,
        _column_4,
        _column_5,
        _column_6,
        _column_7,
        _column_8,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
}

class Shape7 extends i0.VersionedTable {
  Shape7({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get value =>
      columnsByName['value']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<int> _column_16(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'value',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
    );

final class Schema11 extends i0.VersionedSchema {
  Schema11({required super.database}) : super(version: 11);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    globalSettings,
    boolGlobalSettings,
    intGlobalSettings,
    accounts,
  ];
  late final Shape6 globalSettings = Shape6(
    source: i0.VersionedTable(
      entityName: 'global_settings',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [],
      columns: [_column_9, _column_10, _column_13, _column_14, _column_15],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape3 boolGlobalSettings = Shape3(
    source: i0.VersionedTable(
      entityName: 'bool_global_settings',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: ['PRIMARY KEY(name)'],
      columns: [_column_11, _column_12],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape7 intGlobalSettings = Shape7(
    source: i0.VersionedTable(
      entityName: 'int_global_settings',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: ['PRIMARY KEY(name)'],
      columns: [_column_11, _column_16],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape0 accounts = Shape0(
    source: i0.VersionedTable(
      entityName: 'accounts',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [
        'UNIQUE(realm_url, user_id)',
        'UNIQUE(realm_url, email)',
      ],
      columns: [
        _column_0,
        _column_1,
        _column_2,
        _column_3,
        _column_4,
        _column_5,
        _column_6,
        _column_7,
        _column_8,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
}

final class Schema12 extends i0.VersionedSchema {
  Schema12({required super.database}) : super(version: 12);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    globalSettings,
    boolGlobalSettings,
    intGlobalSettings,
    accounts,
  ];
  late final Shape6 globalSettings = Shape6(
    source: i0.VersionedTable(
      entityName: 'global_settings',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [],
      columns: [_column_9, _column_10, _column_13, _column_14, _column_15],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape3 boolGlobalSettings = Shape3(
    source: i0.VersionedTable(
      entityName: 'bool_global_settings',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: ['PRIMARY KEY(name)'],
      columns: [_column_11, _column_12],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape7 intGlobalSettings = Shape7(
    source: i0.VersionedTable(
      entityName: 'int_global_settings',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: ['PRIMARY KEY(name)'],
      columns: [_column_11, _column_16],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape8 accounts = Shape8(
    source: i0.VersionedTable(
      entityName: 'accounts',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [
        'UNIQUE(realm_url, user_id)',
        'UNIQUE(realm_url, email)',
      ],
      columns: [
        _column_0,
        _column_1,
        _column_17,
        _column_18,
        _column_2,
        _column_3,
        _column_4,
        _column_5,
        _column_6,
        _column_7,
        _column_8,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
}

class Shape8 extends i0.VersionedTable {
  Shape8({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get realmUrl =>
      columnsByName['realm_url']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get realmName =>
      columnsByName['realm_name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get realmIcon =>
      columnsByName['realm_icon']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get userId =>
      columnsByName['user_id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get email =>
      columnsByName['email']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get apiKey =>
      columnsByName['api_key']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get zulipVersion =>
      columnsByName['zulip_version']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get zulipMergeBase =>
      columnsByName['zulip_merge_base']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get zulipFeatureLevel =>
      columnsByName['zulip_feature_level']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get ackedPushToken =>
      columnsByName['acked_push_token']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_17(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'realm_name',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_18(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'realm_icon',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i0.MigrationStepWithVersion migrationSteps({
  required Future<void> Function(i1.Migrator m, Schema2 schema) from1To2,
  required Future<void> Function(i1.Migrator m, Schema3 schema) from2To3,
  required Future<void> Function(i1.Migrator m, Schema4 schema) from3To4,
  required Future<void> Function(i1.Migrator m, Schema5 schema) from4To5,
  required Future<void> Function(i1.Migrator m, Schema6 schema) from5To6,
  required Future<void> Function(i1.Migrator m, Schema7 schema) from6To7,
  required Future<void> Function(i1.Migrator m, Schema8 schema) from7To8,
  required Future<void> Function(i1.Migrator m, Schema9 schema) from8To9,
  required Future<void> Function(i1.Migrator m, Schema10 schema) from9To10,
  required Future<void> Function(i1.Migrator m, Schema11 schema) from10To11,
  required Future<void> Function(i1.Migrator m, Schema12 schema) from11To12,
}) {
  return (currentVersion, database) async {
    switch (currentVersion) {
      case 1:
        final schema = Schema2(database: database);
        final migrator = i1.Migrator(database, schema);
        await from1To2(migrator, schema);
        return 2;
      case 2:
        final schema = Schema3(database: database);
        final migrator = i1.Migrator(database, schema);
        await from2To3(migrator, schema);
        return 3;
      case 3:
        final schema = Schema4(database: database);
        final migrator = i1.Migrator(database, schema);
        await from3To4(migrator, schema);
        return 4;
      case 4:
        final schema = Schema5(database: database);
        final migrator = i1.Migrator(database, schema);
        await from4To5(migrator, schema);
        return 5;
      case 5:
        final schema = Schema6(database: database);
        final migrator = i1.Migrator(database, schema);
        await from5To6(migrator, schema);
        return 6;
      case 6:
        final schema = Schema7(database: database);
        final migrator = i1.Migrator(database, schema);
        await from6To7(migrator, schema);
        return 7;
      case 7:
        final schema = Schema8(database: database);
        final migrator = i1.Migrator(database, schema);
        await from7To8(migrator, schema);
        return 8;
      case 8:
        final schema = Schema9(database: database);
        final migrator = i1.Migrator(database, schema);
        await from8To9(migrator, schema);
        return 9;
      case 9:
        final schema = Schema10(database: database);
        final migrator = i1.Migrator(database, schema);
        await from9To10(migrator, schema);
        return 10;
      case 10:
        final schema = Schema11(database: database);
        final migrator = i1.Migrator(database, schema);
        await from10To11(migrator, schema);
        return 11;
      case 11:
        final schema = Schema12(database: database);
        final migrator = i1.Migrator(database, schema);
        await from11To12(migrator, schema);
        return 12;
      default:
        throw ArgumentError.value('Unknown migration from $currentVersion');
    }
  };
}

i1.OnUpgrade stepByStep({
  required Future<void> Function(i1.Migrator m, Schema2 schema) from1To2,
  required Future<void> Function(i1.Migrator m, Schema3 schema) from2To3,
  required Future<void> Function(i1.Migrator m, Schema4 schema) from3To4,
  required Future<void> Function(i1.Migrator m, Schema5 schema) from4To5,
  required Future<void> Function(i1.Migrator m, Schema6 schema) from5To6,
  required Future<void> Function(i1.Migrator m, Schema7 schema) from6To7,
  required Future<void> Function(i1.Migrator m, Schema8 schema) from7To8,
  required Future<void> Function(i1.Migrator m, Schema9 schema) from8To9,
  required Future<void> Function(i1.Migrator m, Schema10 schema) from9To10,
  required Future<void> Function(i1.Migrator m, Schema11 schema) from10To11,
  required Future<void> Function(i1.Migrator m, Schema12 schema) from11To12,
}) => i0.VersionedSchema.stepByStepHelper(
  step: migrationSteps(
    from1To2: from1To2,
    from2To3: from2To3,
    from3To4: from3To4,
    from4To5: from4To5,
    from5To6: from5To6,
    from6To7: from6To7,
    from7To8: from7To8,
    from8To9: from8To9,
    from9To10: from9To10,
    from10To11: from10To11,
    from11To12: from11To12,
  ),
);
