// Copyright 2013 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// Autogenerated from Pigeon, do not edit directly.
// See also: https://pub.dev/packages/pigeon
@file:Suppress("UNCHECKED_CAST", "ArrayInDataClass")

package com.example.test_plugin

import android.util.Log
import io.flutter.plugin.common.BasicMessageChannel
import io.flutter.plugin.common.BinaryMessenger
import io.flutter.plugin.common.MessageCodec
import io.flutter.plugin.common.StandardMessageCodec
import java.io.ByteArrayOutputStream
import java.nio.ByteBuffer

private object ProxyApiTestsPigeonUtils {

  fun createConnectionError(channelName: String): ProxyApiTestsError {
    return ProxyApiTestsError(
        "channel-error", "Unable to establish connection on channel: '$channelName'.", "")
  }

  fun wrapResult(result: Any?): List<Any?> {
    return listOf(result)
  }

  fun wrapError(exception: Throwable): List<Any?> {
    return if (exception is ProxyApiTestsError) {
      listOf(exception.code, exception.message, exception.details)
    } else {
      listOf(
          exception.javaClass.simpleName,
          exception.toString(),
          "Cause: " + exception.cause + ", Stacktrace: " + Log.getStackTraceString(exception))
    }
  }
}

/**
 * Error class for passing custom error details to Flutter via a thrown PlatformException.
 *
 * @property code The error code.
 * @property message The error message.
 * @property details The error details. Must be a datatype supported by the api codec.
 */
class ProxyApiTestsError(
    val code: String,
    override val message: String? = null,
    val details: Any? = null
) : Throwable()
/**
 * Maintains instances used to communicate with the corresponding objects in Dart.
 *
 * Objects stored in this container are represented by an object in Dart that is also stored in an
 * InstanceManager with the same identifier.
 *
 * When an instance is added with an identifier, either can be used to retrieve the other.
 *
 * Added instances are added as a weak reference and a strong reference. When the strong reference
 * is removed with [remove] and the weak reference is deallocated, the
 * `finalizationListener.onFinalize` is called with the instance's identifier. However, if the
 * strong reference is removed and then the identifier is retrieved with the intention to pass the
 * identifier to Dart (e.g. calling [getIdentifierForStrongReference]), the strong reference to the
 * instance is recreated. The strong reference will then need to be removed manually again.
 */
@Suppress("UNCHECKED_CAST", "MemberVisibilityCanBePrivate")
class ProxyApiTestsPigeonInstanceManager(
    private val finalizationListener: PigeonFinalizationListener
) {
  /** Interface for listening when a weak reference of an instance is removed from the manager. */
  interface PigeonFinalizationListener {
    fun onFinalize(identifier: Long)
  }

  // Extends WeakReference and overrides the `equals` and `hashCode` methods using identity rather
  // than equality.
  //
  // Two `IdentityWeakReference`s are equal if either
  // 1: `get()` returns the identical nonnull value for both references.
  // 2: `get()` returns null for both references and the references are identical.
  class IdentityWeakReference<T : Any> : java.lang.ref.WeakReference<T> {
    private val savedHashCode: Int

    constructor(instance: T) : this(instance, null)

    constructor(instance: T, queue: java.lang.ref.ReferenceQueue<T>?) : super(instance, queue) {
      savedHashCode = System.identityHashCode(instance)
    }

    override fun equals(other: Any?): Boolean {
      val instance = get()
      if (instance != null) {
        return other is IdentityWeakReference<*> && other.get() === instance
      }
      return other === this
    }

    override fun hashCode(): Int {
      return savedHashCode
    }
  }

  private val identifiers = java.util.WeakHashMap<IdentityWeakReference<Any>, Long>()
  private val weakInstances = HashMap<Long, IdentityWeakReference<Any>>()
  private val strongInstances = HashMap<Long, Any>()
  private val referenceQueue = java.lang.ref.ReferenceQueue<Any>()
  private val weakReferencesToIdentifiers = HashMap<IdentityWeakReference<Any>, Long>()
  private val handler = android.os.Handler(android.os.Looper.getMainLooper())
  private val releaseAllFinalizedInstancesRunnable = Runnable {
    this.releaseAllFinalizedInstances()
  }
  private var nextIdentifier: Long = minHostCreatedIdentifier
  private var hasFinalizationListenerStopped = false

  /**
   * Modifies the time interval used to define how often this instance removes garbage collected
   * weak references to native Android objects that this instance was managing.
   */
  var clearFinalizedWeakReferencesInterval: Long = 3000
    set(value) {
      handler.removeCallbacks(releaseAllFinalizedInstancesRunnable)
      field = value
      releaseAllFinalizedInstances()
    }

  init {
    handler.postDelayed(releaseAllFinalizedInstancesRunnable, clearFinalizedWeakReferencesInterval)
  }

  companion object {
    // Identifiers are locked to a specific range to avoid collisions with objects
    // created simultaneously from Dart.
    // Host uses identifiers >= 2^16 and Dart is expected to use values n where,
    // 0 <= n < 2^16.
    private const val minHostCreatedIdentifier: Long = 65536
    private const val tag = "PigeonInstanceManager"

    /**
     * Instantiate a new manager with a listener for garbage collected weak references.
     *
     * When the manager is no longer needed, [stopFinalizationListener] must be called.
     */
    fun create(
        finalizationListener: PigeonFinalizationListener
    ): ProxyApiTestsPigeonInstanceManager {
      return ProxyApiTestsPigeonInstanceManager(finalizationListener)
    }
  }

  /**
   * Removes `identifier` and return its associated strongly referenced instance, if present, from
   * the manager.
   */
  fun <T> remove(identifier: Long): T? {
    logWarningIfFinalizationListenerHasStopped()
    return strongInstances.remove(identifier) as T?
  }

  /**
   * Retrieves the identifier paired with an instance, if present, otherwise `null`.
   *
   * If the manager contains a strong reference to `instance`, it will return the identifier
   * associated with `instance`. If the manager contains only a weak reference to `instance`, a new
   * strong reference to `instance` will be added and will need to be removed again with [remove].
   *
   * If this method returns a nonnull identifier, this method also expects the Dart
   * `ProxyApiTestsPigeonInstanceManager` to have, or recreate, a weak reference to the Dart
   * instance the identifier is associated with.
   */
  fun getIdentifierForStrongReference(instance: Any?): Long? {
    logWarningIfFinalizationListenerHasStopped()
    if (instance == null) {
      return null
    }
    val identifier = identifiers[IdentityWeakReference(instance)]
    if (identifier != null) {
      strongInstances[identifier] = instance
    }
    return identifier
  }

  /**
   * Adds a new instance that was instantiated from Dart.
   *
   * The same instance can be added multiple times, but each identifier must be unique. This allows
   * two objects that are equivalent (e.g. the `equals` method returns true and their hashcodes are
   * equal) to both be added.
   *
   * [identifier] must be >= 0 and unique.
   */
  fun addDartCreatedInstance(instance: Any, identifier: Long) {
    logWarningIfFinalizationListenerHasStopped()
    addInstance(instance, identifier)
  }

  /**
   * Adds a new unique instance that was instantiated from the host platform.
   *
   * If the manager contains [instance], this returns the corresponding identifier. If the manager
   * does not contain [instance], this adds the instance and returns a unique identifier for that
   * [instance].
   */
  fun addHostCreatedInstance(instance: Any): Long {
    logWarningIfFinalizationListenerHasStopped()
    require(!containsInstance(instance)) {
      "Instance of ${instance.javaClass} has already been added."
    }
    val identifier = nextIdentifier++
    addInstance(instance, identifier)
    return identifier
  }

  /** Retrieves the instance associated with identifier, if present, otherwise `null`. */
  fun <T : Any> getInstance(identifier: Long): T? {
    logWarningIfFinalizationListenerHasStopped()
    val instance = weakInstances[identifier] as IdentityWeakReference<T>?
    return instance?.get()
  }

  /** Returns whether this manager contains the given `instance`. */
  fun containsInstance(instance: Any?): Boolean {
    logWarningIfFinalizationListenerHasStopped()
    return instance != null && identifiers.containsKey(IdentityWeakReference(instance))
  }

  /**
   * Stops the periodic run of the [PigeonFinalizationListener] for instances that have been garbage
   * collected.
   *
   * The InstanceManager can continue to be used, but the [PigeonFinalizationListener] will no
   * longer be called and methods will log a warning.
   */
  fun stopFinalizationListener() {
    handler.removeCallbacks(releaseAllFinalizedInstancesRunnable)
    hasFinalizationListenerStopped = true
  }

  /**
   * Removes all of the instances from this manager.
   *
   * The manager will be empty after this call returns.
   */
  fun clear() {
    identifiers.clear()
    weakInstances.clear()
    strongInstances.clear()
    weakReferencesToIdentifiers.clear()
  }

  /**
   * Whether the [PigeonFinalizationListener] is still being called for instances that are garbage
   * collected.
   *
   * See [stopFinalizationListener].
   */
  fun hasFinalizationListenerStopped(): Boolean {
    return hasFinalizationListenerStopped
  }

  private fun releaseAllFinalizedInstances() {
    if (hasFinalizationListenerStopped()) {
      return
    }
    var reference: IdentityWeakReference<Any>?
    while ((referenceQueue.poll() as IdentityWeakReference<Any>?).also { reference = it } != null) {
      val identifier = weakReferencesToIdentifiers.remove(reference)
      if (identifier != null) {
        weakInstances.remove(identifier)
        strongInstances.remove(identifier)
        finalizationListener.onFinalize(identifier)
      }
    }
    handler.postDelayed(releaseAllFinalizedInstancesRunnable, clearFinalizedWeakReferencesInterval)
  }

  private fun addInstance(instance: Any, identifier: Long) {
    require(identifier >= 0) { "Identifier must be >= 0: $identifier" }
    require(!weakInstances.containsKey(identifier)) {
      "Identifier has already been added: $identifier"
    }
    val weakReference = IdentityWeakReference(instance, referenceQueue)
    identifiers[weakReference] = identifier
    weakInstances[identifier] = weakReference
    weakReferencesToIdentifiers[weakReference] = identifier
    strongInstances[identifier] = instance
  }

  private fun logWarningIfFinalizationListenerHasStopped() {
    if (hasFinalizationListenerStopped()) {
      Log.w(
          tag,
          "The manager was used after calls to the PigeonFinalizationListener has been stopped.")
    }
  }
}

/** Generated API for managing the Dart and native `InstanceManager`s. */
private class ProxyApiTestsPigeonInstanceManagerApi(val binaryMessenger: BinaryMessenger) {
  companion object {
    /** The codec used by ProxyApiTestsPigeonInstanceManagerApi. */
    val codec: MessageCodec<Any?> by lazy { ProxyApiTestsPigeonCodec() }

    /**
     * Sets up an instance of `ProxyApiTestsPigeonInstanceManagerApi` to handle messages from the
     * `binaryMessenger`.
     */
    fun setUpMessageHandlers(
        binaryMessenger: BinaryMessenger,
        instanceManager: ProxyApiTestsPigeonInstanceManager?
    ) {
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.PigeonInternalInstanceManager.removeStrongReference",
                codec)
        if (instanceManager != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val identifierArg = args[0] as Long
            val wrapped: List<Any?> =
                try {
                  instanceManager.remove<Any?>(identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.PigeonInternalInstanceManager.clear",
                codec)
        if (instanceManager != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> =
                try {
                  instanceManager.clear()
                  listOf(null)
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  fun removeStrongReference(identifierArg: Long, callback: (Result<Unit>) -> Unit) {
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.PigeonInternalInstanceManager.removeStrongReference"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(identifierArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
}
/**
 * Provides implementations for each ProxyApi implementation and provides access to resources needed
 * by any implementation.
 */
abstract class ProxyApiTestsPigeonProxyApiRegistrar(val binaryMessenger: BinaryMessenger) {
  /** Whether APIs should ignore calling to Dart. */
  public var ignoreCallsToDart = false
  val instanceManager: ProxyApiTestsPigeonInstanceManager
  private var _codec: MessageCodec<Any?>? = null
  val codec: MessageCodec<Any?>
    get() {
      if (_codec == null) {
        _codec = ProxyApiTestsPigeonProxyApiBaseCodec(this)
      }
      return _codec!!
    }

  init {
    val api = ProxyApiTestsPigeonInstanceManagerApi(binaryMessenger)
    instanceManager =
        ProxyApiTestsPigeonInstanceManager.create(
            object : ProxyApiTestsPigeonInstanceManager.PigeonFinalizationListener {
              override fun onFinalize(identifier: Long) {
                api.removeStrongReference(identifier) {
                  if (it.isFailure) {
                    Log.e(
                        "PigeonProxyApiRegistrar",
                        "Failed to remove Dart strong reference with identifier: $identifier")
                  }
                }
              }
            })
  }
  /**
   * An implementation of [PigeonApiProxyApiTestClass] used to add a new Dart instance of
   * `ProxyApiTestClass` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiProxyApiTestClass(): PigeonApiProxyApiTestClass

  /**
   * An implementation of [PigeonApiProxyApiSuperClass] used to add a new Dart instance of
   * `ProxyApiSuperClass` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiProxyApiSuperClass(): PigeonApiProxyApiSuperClass

  /**
   * An implementation of [PigeonApiProxyApiInterface] used to add a new Dart instance of
   * `ProxyApiInterface` to the Dart `InstanceManager`.
   */
  open fun getPigeonApiProxyApiInterface(): PigeonApiProxyApiInterface {
    return PigeonApiProxyApiInterface(this)
  }

  /**
   * An implementation of [PigeonApiClassWithApiRequirement] used to add a new Dart instance of
   * `ClassWithApiRequirement` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiClassWithApiRequirement(): PigeonApiClassWithApiRequirement

  fun setUp() {
    ProxyApiTestsPigeonInstanceManagerApi.setUpMessageHandlers(binaryMessenger, instanceManager)
    PigeonApiProxyApiTestClass.setUpMessageHandlers(
        binaryMessenger, getPigeonApiProxyApiTestClass())
    PigeonApiProxyApiSuperClass.setUpMessageHandlers(
        binaryMessenger, getPigeonApiProxyApiSuperClass())
    PigeonApiClassWithApiRequirement.setUpMessageHandlers(
        binaryMessenger, getPigeonApiClassWithApiRequirement())
  }

  fun tearDown() {
    ProxyApiTestsPigeonInstanceManagerApi.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiProxyApiTestClass.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiProxyApiSuperClass.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiClassWithApiRequirement.setUpMessageHandlers(binaryMessenger, null)
  }
}

private class ProxyApiTestsPigeonProxyApiBaseCodec(
    val registrar: ProxyApiTestsPigeonProxyApiRegistrar
) : ProxyApiTestsPigeonCodec() {
  override fun readValueOfType(type: Byte, buffer: ByteBuffer): Any? {
    return when (type) {
      128.toByte() -> {
        val identifier: Long = readValue(buffer) as Long
        val instance: Any? = registrar.instanceManager.getInstance(identifier)
        if (instance == null) {
          Log.e("PigeonProxyApiBaseCodec", "Failed to find instance with identifier: $identifier")
        }
        return instance
      }
      else -> super.readValueOfType(type, buffer)
    }
  }

  override fun writeValue(stream: ByteArrayOutputStream, value: Any?) {
    if (value is Boolean ||
        value is ByteArray ||
        value is Double ||
        value is DoubleArray ||
        value is FloatArray ||
        value is Int ||
        value is IntArray ||
        value is List<*> ||
        value is Long ||
        value is LongArray ||
        value is Map<*, *> ||
        value is String ||
        value is ProxyApiTestEnum ||
        value == null) {
      super.writeValue(stream, value)
      return
    }

    fun logNewInstanceFailure(apiName: String, value: Any, exception: Throwable?) {
      Log.w(
          "PigeonProxyApiBaseCodec",
          "Failed to create new Dart proxy instance of $apiName: $value. $exception")
    }

    if (value is ProxyApiTestClass) {
      registrar.getPigeonApiProxyApiTestClass().pigeon_newInstance(value) {
        if (it.isFailure) {
          logNewInstanceFailure("ProxyApiTestClass", value, it.exceptionOrNull())
        }
      }
    } else if (value is com.example.test_plugin.ProxyApiSuperClass) {
      registrar.getPigeonApiProxyApiSuperClass().pigeon_newInstance(value) {
        if (it.isFailure) {
          logNewInstanceFailure("ProxyApiSuperClass", value, it.exceptionOrNull())
        }
      }
    } else if (value is ProxyApiInterface) {
      registrar.getPigeonApiProxyApiInterface().pigeon_newInstance(value) {
        if (it.isFailure) {
          logNewInstanceFailure("ProxyApiInterface", value, it.exceptionOrNull())
        }
      }
    } else if (android.os.Build.VERSION.SDK_INT >= 25 && value is ClassWithApiRequirement) {
      registrar.getPigeonApiClassWithApiRequirement().pigeon_newInstance(value) {
        if (it.isFailure) {
          logNewInstanceFailure("ClassWithApiRequirement", value, it.exceptionOrNull())
        }
      }
    }

    when {
      registrar.instanceManager.containsInstance(value) -> {
        stream.write(128)
        writeValue(stream, registrar.instanceManager.getIdentifierForStrongReference(value))
      }
      else ->
          throw IllegalArgumentException(
              "Unsupported value: '$value' of type '${value.javaClass.name}'")
    }
  }
}

enum class ProxyApiTestEnum(val raw: Int) {
  ONE(0),
  TWO(1),
  THREE(2);

  companion object {
    fun ofRaw(raw: Int): ProxyApiTestEnum? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

private open class ProxyApiTestsPigeonCodec : StandardMessageCodec() {
  override fun readValueOfType(type: Byte, buffer: ByteBuffer): Any? {
    return when (type) {
      129.toByte() -> {
        return (readValue(buffer) as Long?)?.let { ProxyApiTestEnum.ofRaw(it.toInt()) }
      }
      else -> super.readValueOfType(type, buffer)
    }
  }

  override fun writeValue(stream: ByteArrayOutputStream, value: Any?) {
    when (value) {
      is ProxyApiTestEnum -> {
        stream.write(129)
        writeValue(stream, value.raw.toLong())
      }
      else -> super.writeValue(stream, value)
    }
  }
}

/**
 * The core ProxyApi test class that each supported host language must implement in platform_tests
 * integration tests.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiProxyApiTestClass(
    open val pigeonRegistrar: ProxyApiTestsPigeonProxyApiRegistrar
) {
  abstract fun pigeon_defaultConstructor(
      aBool: Boolean,
      anInt: Long,
      aDouble: Double,
      aString: String,
      aUint8List: ByteArray,
      aList: List<Any?>,
      aMap: Map<String?, Any?>,
      anEnum: ProxyApiTestEnum,
      aProxyApi: com.example.test_plugin.ProxyApiSuperClass,
      aNullableBool: Boolean?,
      aNullableInt: Long?,
      aNullableDouble: Double?,
      aNullableString: String?,
      aNullableUint8List: ByteArray?,
      aNullableList: List<Any?>?,
      aNullableMap: Map<String?, Any?>?,
      aNullableEnum: ProxyApiTestEnum?,
      aNullableProxyApi: com.example.test_plugin.ProxyApiSuperClass?,
      boolParam: Boolean,
      intParam: Long,
      doubleParam: Double,
      stringParam: String,
      aUint8ListParam: ByteArray,
      listParam: List<Any?>,
      mapParam: Map<String?, Any?>,
      enumParam: ProxyApiTestEnum,
      proxyApiParam: com.example.test_plugin.ProxyApiSuperClass,
      nullableBoolParam: Boolean?,
      nullableIntParam: Long?,
      nullableDoubleParam: Double?,
      nullableStringParam: String?,
      nullableUint8ListParam: ByteArray?,
      nullableListParam: List<Any?>?,
      nullableMapParam: Map<String?, Any?>?,
      nullableEnumParam: ProxyApiTestEnum?,
      nullableProxyApiParam: com.example.test_plugin.ProxyApiSuperClass?
  ): ProxyApiTestClass

  abstract fun namedConstructor(
      aBool: Boolean,
      anInt: Long,
      aDouble: Double,
      aString: String,
      aUint8List: ByteArray,
      aList: List<Any?>,
      aMap: Map<String?, Any?>,
      anEnum: ProxyApiTestEnum,
      aProxyApi: com.example.test_plugin.ProxyApiSuperClass,
      aNullableBool: Boolean?,
      aNullableInt: Long?,
      aNullableDouble: Double?,
      aNullableString: String?,
      aNullableUint8List: ByteArray?,
      aNullableList: List<Any?>?,
      aNullableMap: Map<String?, Any?>?,
      aNullableEnum: ProxyApiTestEnum?,
      aNullableProxyApi: com.example.test_plugin.ProxyApiSuperClass?
  ): ProxyApiTestClass

  abstract fun attachedField(
      pigeon_instance: ProxyApiTestClass
  ): com.example.test_plugin.ProxyApiSuperClass

  abstract fun staticAttachedField(): com.example.test_plugin.ProxyApiSuperClass

  /** A no-op function taking no arguments and returning no value, to sanity test basic calling. */
  abstract fun noop(pigeon_instance: ProxyApiTestClass)

  /** Returns an error, to test error handling. */
  abstract fun throwError(pigeon_instance: ProxyApiTestClass): Any?

  /** Returns an error from a void function, to test error handling. */
  abstract fun throwErrorFromVoid(pigeon_instance: ProxyApiTestClass)

  /** Returns a Flutter error, to test error handling. */
  abstract fun throwFlutterError(pigeon_instance: ProxyApiTestClass): Any?

  /** Returns passed in int. */
  abstract fun echoInt(pigeon_instance: ProxyApiTestClass, anInt: Long): Long

  /** Returns passed in double. */
  abstract fun echoDouble(pigeon_instance: ProxyApiTestClass, aDouble: Double): Double

  /** Returns the passed in boolean. */
  abstract fun echoBool(pigeon_instance: ProxyApiTestClass, aBool: Boolean): Boolean

  /** Returns the passed in string. */
  abstract fun echoString(pigeon_instance: ProxyApiTestClass, aString: String): String

  /** Returns the passed in Uint8List. */
  abstract fun echoUint8List(pigeon_instance: ProxyApiTestClass, aUint8List: ByteArray): ByteArray

  /** Returns the passed in generic Object. */
  abstract fun echoObject(pigeon_instance: ProxyApiTestClass, anObject: Any): Any

  /** Returns the passed list, to test serialization and deserialization. */
  abstract fun echoList(pigeon_instance: ProxyApiTestClass, aList: List<Any?>): List<Any?>

  /** Returns the passed list with ProxyApis, to test serialization and deserialization. */
  abstract fun echoProxyApiList(
      pigeon_instance: ProxyApiTestClass,
      aList: List<ProxyApiTestClass>
  ): List<ProxyApiTestClass>

  /** Returns the passed map, to test serialization and deserialization. */
  abstract fun echoMap(
      pigeon_instance: ProxyApiTestClass,
      aMap: Map<String?, Any?>
  ): Map<String?, Any?>

  /** Returns the passed map with ProxyApis, to test serialization and deserialization. */
  abstract fun echoProxyApiMap(
      pigeon_instance: ProxyApiTestClass,
      aMap: Map<String, ProxyApiTestClass>
  ): Map<String, ProxyApiTestClass>

  /** Returns the passed enum to test serialization and deserialization. */
  abstract fun echoEnum(
      pigeon_instance: ProxyApiTestClass,
      anEnum: ProxyApiTestEnum
  ): ProxyApiTestEnum

  /** Returns the passed ProxyApi to test serialization and deserialization. */
  abstract fun echoProxyApi(
      pigeon_instance: ProxyApiTestClass,
      aProxyApi: com.example.test_plugin.ProxyApiSuperClass
  ): com.example.test_plugin.ProxyApiSuperClass

  /** Returns passed in int. */
  abstract fun echoNullableInt(pigeon_instance: ProxyApiTestClass, aNullableInt: Long?): Long?

  /** Returns passed in double. */
  abstract fun echoNullableDouble(
      pigeon_instance: ProxyApiTestClass,
      aNullableDouble: Double?
  ): Double?

  /** Returns the passed in boolean. */
  abstract fun echoNullableBool(
      pigeon_instance: ProxyApiTestClass,
      aNullableBool: Boolean?
  ): Boolean?

  /** Returns the passed in string. */
  abstract fun echoNullableString(
      pigeon_instance: ProxyApiTestClass,
      aNullableString: String?
  ): String?

  /** Returns the passed in Uint8List. */
  abstract fun echoNullableUint8List(
      pigeon_instance: ProxyApiTestClass,
      aNullableUint8List: ByteArray?
  ): ByteArray?

  /** Returns the passed in generic Object. */
  abstract fun echoNullableObject(pigeon_instance: ProxyApiTestClass, aNullableObject: Any?): Any?

  /** Returns the passed list, to test serialization and deserialization. */
  abstract fun echoNullableList(
      pigeon_instance: ProxyApiTestClass,
      aNullableList: List<Any?>?
  ): List<Any?>?

  /** Returns the passed map, to test serialization and deserialization. */
  abstract fun echoNullableMap(
      pigeon_instance: ProxyApiTestClass,
      aNullableMap: Map<String?, Any?>?
  ): Map<String?, Any?>?

  abstract fun echoNullableEnum(
      pigeon_instance: ProxyApiTestClass,
      aNullableEnum: ProxyApiTestEnum?
  ): ProxyApiTestEnum?

  /** Returns the passed ProxyApi to test serialization and deserialization. */
  abstract fun echoNullableProxyApi(
      pigeon_instance: ProxyApiTestClass,
      aNullableProxyApi: com.example.test_plugin.ProxyApiSuperClass?
  ): com.example.test_plugin.ProxyApiSuperClass?

  /**
   * A no-op function taking no arguments and returning no value, to sanity test basic asynchronous
   * calling.
   */
  abstract fun noopAsync(pigeon_instance: ProxyApiTestClass, callback: (Result<Unit>) -> Unit)

  /** Returns passed in int asynchronously. */
  abstract fun echoAsyncInt(
      pigeon_instance: ProxyApiTestClass,
      anInt: Long,
      callback: (Result<Long>) -> Unit
  )

  /** Returns passed in double asynchronously. */
  abstract fun echoAsyncDouble(
      pigeon_instance: ProxyApiTestClass,
      aDouble: Double,
      callback: (Result<Double>) -> Unit
  )

  /** Returns the passed in boolean asynchronously. */
  abstract fun echoAsyncBool(
      pigeon_instance: ProxyApiTestClass,
      aBool: Boolean,
      callback: (Result<Boolean>) -> Unit
  )

  /** Returns the passed string asynchronously. */
  abstract fun echoAsyncString(
      pigeon_instance: ProxyApiTestClass,
      aString: String,
      callback: (Result<String>) -> Unit
  )

  /** Returns the passed in Uint8List asynchronously. */
  abstract fun echoAsyncUint8List(
      pigeon_instance: ProxyApiTestClass,
      aUint8List: ByteArray,
      callback: (Result<ByteArray>) -> Unit
  )

  /** Returns the passed in generic Object asynchronously. */
  abstract fun echoAsyncObject(
      pigeon_instance: ProxyApiTestClass,
      anObject: Any,
      callback: (Result<Any>) -> Unit
  )

  /** Returns the passed list, to test asynchronous serialization and deserialization. */
  abstract fun echoAsyncList(
      pigeon_instance: ProxyApiTestClass,
      aList: List<Any?>,
      callback: (Result<List<Any?>>) -> Unit
  )

  /** Returns the passed map, to test asynchronous serialization and deserialization. */
  abstract fun echoAsyncMap(
      pigeon_instance: ProxyApiTestClass,
      aMap: Map<String?, Any?>,
      callback: (Result<Map<String?, Any?>>) -> Unit
  )

  /** Returns the passed enum, to test asynchronous serialization and deserialization. */
  abstract fun echoAsyncEnum(
      pigeon_instance: ProxyApiTestClass,
      anEnum: ProxyApiTestEnum,
      callback: (Result<ProxyApiTestEnum>) -> Unit
  )

  /** Responds with an error from an async function returning a value. */
  abstract fun throwAsyncError(pigeon_instance: ProxyApiTestClass, callback: (Result<Any?>) -> Unit)

  /** Responds with an error from an async void function. */
  abstract fun throwAsyncErrorFromVoid(
      pigeon_instance: ProxyApiTestClass,
      callback: (Result<Unit>) -> Unit
  )

  /** Responds with a Flutter error from an async function returning a value. */
  abstract fun throwAsyncFlutterError(
      pigeon_instance: ProxyApiTestClass,
      callback: (Result<Any?>) -> Unit
  )

  /** Returns passed in int asynchronously. */
  abstract fun echoAsyncNullableInt(
      pigeon_instance: ProxyApiTestClass,
      anInt: Long?,
      callback: (Result<Long?>) -> Unit
  )

  /** Returns passed in double asynchronously. */
  abstract fun echoAsyncNullableDouble(
      pigeon_instance: ProxyApiTestClass,
      aDouble: Double?,
      callback: (Result<Double?>) -> Unit
  )

  /** Returns the passed in boolean asynchronously. */
  abstract fun echoAsyncNullableBool(
      pigeon_instance: ProxyApiTestClass,
      aBool: Boolean?,
      callback: (Result<Boolean?>) -> Unit
  )

  /** Returns the passed string asynchronously. */
  abstract fun echoAsyncNullableString(
      pigeon_instance: ProxyApiTestClass,
      aString: String?,
      callback: (Result<String?>) -> Unit
  )

  /** Returns the passed in Uint8List asynchronously. */
  abstract fun echoAsyncNullableUint8List(
      pigeon_instance: ProxyApiTestClass,
      aUint8List: ByteArray?,
      callback: (Result<ByteArray?>) -> Unit
  )

  /** Returns the passed in generic Object asynchronously. */
  abstract fun echoAsyncNullableObject(
      pigeon_instance: ProxyApiTestClass,
      anObject: Any?,
      callback: (Result<Any?>) -> Unit
  )

  /** Returns the passed list, to test asynchronous serialization and deserialization. */
  abstract fun echoAsyncNullableList(
      pigeon_instance: ProxyApiTestClass,
      aList: List<Any?>?,
      callback: (Result<List<Any?>?>) -> Unit
  )

  /** Returns the passed map, to test asynchronous serialization and deserialization. */
  abstract fun echoAsyncNullableMap(
      pigeon_instance: ProxyApiTestClass,
      aMap: Map<String?, Any?>?,
      callback: (Result<Map<String?, Any?>?>) -> Unit
  )

  /** Returns the passed enum, to test asynchronous serialization and deserialization. */
  abstract fun echoAsyncNullableEnum(
      pigeon_instance: ProxyApiTestClass,
      anEnum: ProxyApiTestEnum?,
      callback: (Result<ProxyApiTestEnum?>) -> Unit
  )

  abstract fun staticNoop()

  abstract fun echoStaticString(aString: String): String

  abstract fun staticAsyncNoop(callback: (Result<Unit>) -> Unit)

  abstract fun callFlutterNoop(pigeon_instance: ProxyApiTestClass, callback: (Result<Unit>) -> Unit)

  abstract fun callFlutterThrowError(
      pigeon_instance: ProxyApiTestClass,
      callback: (Result<Any?>) -> Unit
  )

  abstract fun callFlutterThrowErrorFromVoid(
      pigeon_instance: ProxyApiTestClass,
      callback: (Result<Unit>) -> Unit
  )

  abstract fun callFlutterEchoBool(
      pigeon_instance: ProxyApiTestClass,
      aBool: Boolean,
      callback: (Result<Boolean>) -> Unit
  )

  abstract fun callFlutterEchoInt(
      pigeon_instance: ProxyApiTestClass,
      anInt: Long,
      callback: (Result<Long>) -> Unit
  )

  abstract fun callFlutterEchoDouble(
      pigeon_instance: ProxyApiTestClass,
      aDouble: Double,
      callback: (Result<Double>) -> Unit
  )

  abstract fun callFlutterEchoString(
      pigeon_instance: ProxyApiTestClass,
      aString: String,
      callback: (Result<String>) -> Unit
  )

  abstract fun callFlutterEchoUint8List(
      pigeon_instance: ProxyApiTestClass,
      aUint8List: ByteArray,
      callback: (Result<ByteArray>) -> Unit
  )

  abstract fun callFlutterEchoList(
      pigeon_instance: ProxyApiTestClass,
      aList: List<Any?>,
      callback: (Result<List<Any?>>) -> Unit
  )

  abstract fun callFlutterEchoProxyApiList(
      pigeon_instance: ProxyApiTestClass,
      aList: List<ProxyApiTestClass?>,
      callback: (Result<List<ProxyApiTestClass?>>) -> Unit
  )

  abstract fun callFlutterEchoMap(
      pigeon_instance: ProxyApiTestClass,
      aMap: Map<String?, Any?>,
      callback: (Result<Map<String?, Any?>>) -> Unit
  )

  abstract fun callFlutterEchoProxyApiMap(
      pigeon_instance: ProxyApiTestClass,
      aMap: Map<String?, ProxyApiTestClass?>,
      callback: (Result<Map<String?, ProxyApiTestClass?>>) -> Unit
  )

  abstract fun callFlutterEchoEnum(
      pigeon_instance: ProxyApiTestClass,
      anEnum: ProxyApiTestEnum,
      callback: (Result<ProxyApiTestEnum>) -> Unit
  )

  abstract fun callFlutterEchoProxyApi(
      pigeon_instance: ProxyApiTestClass,
      aProxyApi: com.example.test_plugin.ProxyApiSuperClass,
      callback: (Result<com.example.test_plugin.ProxyApiSuperClass>) -> Unit
  )

  abstract fun callFlutterEchoNullableBool(
      pigeon_instance: ProxyApiTestClass,
      aBool: Boolean?,
      callback: (Result<Boolean?>) -> Unit
  )

  abstract fun callFlutterEchoNullableInt(
      pigeon_instance: ProxyApiTestClass,
      anInt: Long?,
      callback: (Result<Long?>) -> Unit
  )

  abstract fun callFlutterEchoNullableDouble(
      pigeon_instance: ProxyApiTestClass,
      aDouble: Double?,
      callback: (Result<Double?>) -> Unit
  )

  abstract fun callFlutterEchoNullableString(
      pigeon_instance: ProxyApiTestClass,
      aString: String?,
      callback: (Result<String?>) -> Unit
  )

  abstract fun callFlutterEchoNullableUint8List(
      pigeon_instance: ProxyApiTestClass,
      aUint8List: ByteArray?,
      callback: (Result<ByteArray?>) -> Unit
  )

  abstract fun callFlutterEchoNullableList(
      pigeon_instance: ProxyApiTestClass,
      aList: List<Any?>?,
      callback: (Result<List<Any?>?>) -> Unit
  )

  abstract fun callFlutterEchoNullableMap(
      pigeon_instance: ProxyApiTestClass,
      aMap: Map<String?, Any?>?,
      callback: (Result<Map<String?, Any?>?>) -> Unit
  )

  abstract fun callFlutterEchoNullableEnum(
      pigeon_instance: ProxyApiTestClass,
      anEnum: ProxyApiTestEnum?,
      callback: (Result<ProxyApiTestEnum?>) -> Unit
  )

  abstract fun callFlutterEchoNullableProxyApi(
      pigeon_instance: ProxyApiTestClass,
      aProxyApi: com.example.test_plugin.ProxyApiSuperClass?,
      callback: (Result<com.example.test_plugin.ProxyApiSuperClass?>) -> Unit
  )

  abstract fun callFlutterNoopAsync(
      pigeon_instance: ProxyApiTestClass,
      callback: (Result<Unit>) -> Unit
  )

  abstract fun callFlutterEchoAsyncString(
      pigeon_instance: ProxyApiTestClass,
      aString: String,
      callback: (Result<String>) -> Unit
  )

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiProxyApiTestClass?) {
      val codec = api?.pigeonRegistrar?.codec ?: ProxyApiTestsPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.pigeon_defaultConstructor",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val aBoolArg = args[1] as Boolean
            val anIntArg = args[2] as Long
            val aDoubleArg = args[3] as Double
            val aStringArg = args[4] as String
            val aUint8ListArg = args[5] as ByteArray
            val aListArg = args[6] as List<Any?>
            val aMapArg = args[7] as Map<String?, Any?>
            val anEnumArg = args[8] as ProxyApiTestEnum
            val aProxyApiArg = args[9] as com.example.test_plugin.ProxyApiSuperClass
            val aNullableBoolArg = args[10] as Boolean?
            val aNullableIntArg = args[11] as Long?
            val aNullableDoubleArg = args[12] as Double?
            val aNullableStringArg = args[13] as String?
            val aNullableUint8ListArg = args[14] as ByteArray?
            val aNullableListArg = args[15] as List<Any?>?
            val aNullableMapArg = args[16] as Map<String?, Any?>?
            val aNullableEnumArg = args[17] as ProxyApiTestEnum?
            val aNullableProxyApiArg = args[18] as com.example.test_plugin.ProxyApiSuperClass?
            val boolParamArg = args[19] as Boolean
            val intParamArg = args[20] as Long
            val doubleParamArg = args[21] as Double
            val stringParamArg = args[22] as String
            val aUint8ListParamArg = args[23] as ByteArray
            val listParamArg = args[24] as List<Any?>
            val mapParamArg = args[25] as Map<String?, Any?>
            val enumParamArg = args[26] as ProxyApiTestEnum
            val proxyApiParamArg = args[27] as com.example.test_plugin.ProxyApiSuperClass
            val nullableBoolParamArg = args[28] as Boolean?
            val nullableIntParamArg = args[29] as Long?
            val nullableDoubleParamArg = args[30] as Double?
            val nullableStringParamArg = args[31] as String?
            val nullableUint8ListParamArg = args[32] as ByteArray?
            val nullableListParamArg = args[33] as List<Any?>?
            val nullableMapParamArg = args[34] as Map<String?, Any?>?
            val nullableEnumParamArg = args[35] as ProxyApiTestEnum?
            val nullableProxyApiParamArg = args[36] as com.example.test_plugin.ProxyApiSuperClass?
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.pigeon_defaultConstructor(
                          aBoolArg,
                          anIntArg,
                          aDoubleArg,
                          aStringArg,
                          aUint8ListArg,
                          aListArg,
                          aMapArg,
                          anEnumArg,
                          aProxyApiArg,
                          aNullableBoolArg,
                          aNullableIntArg,
                          aNullableDoubleArg,
                          aNullableStringArg,
                          aNullableUint8ListArg,
                          aNullableListArg,
                          aNullableMapArg,
                          aNullableEnumArg,
                          aNullableProxyApiArg,
                          boolParamArg,
                          intParamArg,
                          doubleParamArg,
                          stringParamArg,
                          aUint8ListParamArg,
                          listParamArg,
                          mapParamArg,
                          enumParamArg,
                          proxyApiParamArg,
                          nullableBoolParamArg,
                          nullableIntParamArg,
                          nullableDoubleParamArg,
                          nullableStringParamArg,
                          nullableUint8ListParamArg,
                          nullableListParamArg,
                          nullableMapParamArg,
                          nullableEnumParamArg,
                          nullableProxyApiParamArg),
                      pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.namedConstructor",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val aBoolArg = args[1] as Boolean
            val anIntArg = args[2] as Long
            val aDoubleArg = args[3] as Double
            val aStringArg = args[4] as String
            val aUint8ListArg = args[5] as ByteArray
            val aListArg = args[6] as List<Any?>
            val aMapArg = args[7] as Map<String?, Any?>
            val anEnumArg = args[8] as ProxyApiTestEnum
            val aProxyApiArg = args[9] as com.example.test_plugin.ProxyApiSuperClass
            val aNullableBoolArg = args[10] as Boolean?
            val aNullableIntArg = args[11] as Long?
            val aNullableDoubleArg = args[12] as Double?
            val aNullableStringArg = args[13] as String?
            val aNullableUint8ListArg = args[14] as ByteArray?
            val aNullableListArg = args[15] as List<Any?>?
            val aNullableMapArg = args[16] as Map<String?, Any?>?
            val aNullableEnumArg = args[17] as ProxyApiTestEnum?
            val aNullableProxyApiArg = args[18] as com.example.test_plugin.ProxyApiSuperClass?
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.namedConstructor(
                          aBoolArg,
                          anIntArg,
                          aDoubleArg,
                          aStringArg,
                          aUint8ListArg,
                          aListArg,
                          aMapArg,
                          anEnumArg,
                          aProxyApiArg,
                          aNullableBoolArg,
                          aNullableIntArg,
                          aNullableDoubleArg,
                          aNullableStringArg,
                          aNullableUint8ListArg,
                          aNullableListArg,
                          aNullableMapArg,
                          aNullableEnumArg,
                          aNullableProxyApiArg),
                      pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.attachedField",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val pigeon_identifierArg = args[1] as Long
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.attachedField(pigeon_instanceArg), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.staticAttachedField",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.staticAttachedField(), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.noop",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val wrapped: List<Any?> =
                try {
                  api.noop(pigeon_instanceArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.throwError",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val wrapped: List<Any?> =
                try {
                  listOf(api.throwError(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.throwErrorFromVoid",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val wrapped: List<Any?> =
                try {
                  api.throwErrorFromVoid(pigeon_instanceArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.throwFlutterError",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val wrapped: List<Any?> =
                try {
                  listOf(api.throwFlutterError(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoInt",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val anIntArg = args[1] as Long
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoInt(pigeon_instanceArg, anIntArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoDouble",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aDoubleArg = args[1] as Double
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoDouble(pigeon_instanceArg, aDoubleArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoBool",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aBoolArg = args[1] as Boolean
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoBool(pigeon_instanceArg, aBoolArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoString",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aStringArg = args[1] as String
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoString(pigeon_instanceArg, aStringArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoUint8List",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aUint8ListArg = args[1] as ByteArray
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoUint8List(pigeon_instanceArg, aUint8ListArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoObject",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val anObjectArg = args[1] as Any
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoObject(pigeon_instanceArg, anObjectArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoList",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aListArg = args[1] as List<Any?>
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoList(pigeon_instanceArg, aListArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoProxyApiList",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aListArg = args[1] as List<ProxyApiTestClass>
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoProxyApiList(pigeon_instanceArg, aListArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoMap",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aMapArg = args[1] as Map<String?, Any?>
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoMap(pigeon_instanceArg, aMapArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoProxyApiMap",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aMapArg = args[1] as Map<String, ProxyApiTestClass>
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoProxyApiMap(pigeon_instanceArg, aMapArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoEnum",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val anEnumArg = args[1] as ProxyApiTestEnum
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoEnum(pigeon_instanceArg, anEnumArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoProxyApi",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aProxyApiArg = args[1] as com.example.test_plugin.ProxyApiSuperClass
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoProxyApi(pigeon_instanceArg, aProxyApiArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableInt",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aNullableIntArg = args[1] as Long?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableInt(pigeon_instanceArg, aNullableIntArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableDouble",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aNullableDoubleArg = args[1] as Double?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableDouble(pigeon_instanceArg, aNullableDoubleArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableBool",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aNullableBoolArg = args[1] as Boolean?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableBool(pigeon_instanceArg, aNullableBoolArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableString",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aNullableStringArg = args[1] as String?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableString(pigeon_instanceArg, aNullableStringArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableUint8List",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aNullableUint8ListArg = args[1] as ByteArray?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableUint8List(pigeon_instanceArg, aNullableUint8ListArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableObject",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aNullableObjectArg = args[1]
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableObject(pigeon_instanceArg, aNullableObjectArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableList",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aNullableListArg = args[1] as List<Any?>?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableList(pigeon_instanceArg, aNullableListArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableMap",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aNullableMapArg = args[1] as Map<String?, Any?>?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableMap(pigeon_instanceArg, aNullableMapArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableEnum",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aNullableEnumArg = args[1] as ProxyApiTestEnum?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableEnum(pigeon_instanceArg, aNullableEnumArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoNullableProxyApi",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aNullableProxyApiArg = args[1] as com.example.test_plugin.ProxyApiSuperClass?
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoNullableProxyApi(pigeon_instanceArg, aNullableProxyApiArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.noopAsync",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            api.noopAsync(pigeon_instanceArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncInt",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val anIntArg = args[1] as Long
            api.echoAsyncInt(pigeon_instanceArg, anIntArg) { result: Result<Long> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncDouble",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aDoubleArg = args[1] as Double
            api.echoAsyncDouble(pigeon_instanceArg, aDoubleArg) { result: Result<Double> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncBool",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aBoolArg = args[1] as Boolean
            api.echoAsyncBool(pigeon_instanceArg, aBoolArg) { result: Result<Boolean> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncString",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aStringArg = args[1] as String
            api.echoAsyncString(pigeon_instanceArg, aStringArg) { result: Result<String> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncUint8List",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aUint8ListArg = args[1] as ByteArray
            api.echoAsyncUint8List(pigeon_instanceArg, aUint8ListArg) { result: Result<ByteArray> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncObject",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val anObjectArg = args[1] as Any
            api.echoAsyncObject(pigeon_instanceArg, anObjectArg) { result: Result<Any> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncList",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aListArg = args[1] as List<Any?>
            api.echoAsyncList(pigeon_instanceArg, aListArg) { result: Result<List<Any?>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncMap",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aMapArg = args[1] as Map<String?, Any?>
            api.echoAsyncMap(pigeon_instanceArg, aMapArg) { result: Result<Map<String?, Any?>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncEnum",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val anEnumArg = args[1] as ProxyApiTestEnum
            api.echoAsyncEnum(pigeon_instanceArg, anEnumArg) { result: Result<ProxyApiTestEnum> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.throwAsyncError",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            api.throwAsyncError(pigeon_instanceArg) { result: Result<Any?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.throwAsyncErrorFromVoid",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            api.throwAsyncErrorFromVoid(pigeon_instanceArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.throwAsyncFlutterError",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            api.throwAsyncFlutterError(pigeon_instanceArg) { result: Result<Any?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableInt",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val anIntArg = args[1] as Long?
            api.echoAsyncNullableInt(pigeon_instanceArg, anIntArg) { result: Result<Long?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableDouble",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aDoubleArg = args[1] as Double?
            api.echoAsyncNullableDouble(pigeon_instanceArg, aDoubleArg) { result: Result<Double?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableBool",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aBoolArg = args[1] as Boolean?
            api.echoAsyncNullableBool(pigeon_instanceArg, aBoolArg) { result: Result<Boolean?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableString",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aStringArg = args[1] as String?
            api.echoAsyncNullableString(pigeon_instanceArg, aStringArg) { result: Result<String?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableUint8List",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aUint8ListArg = args[1] as ByteArray?
            api.echoAsyncNullableUint8List(pigeon_instanceArg, aUint8ListArg) {
                result: Result<ByteArray?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableObject",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val anObjectArg = args[1]
            api.echoAsyncNullableObject(pigeon_instanceArg, anObjectArg) { result: Result<Any?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableList",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aListArg = args[1] as List<Any?>?
            api.echoAsyncNullableList(pigeon_instanceArg, aListArg) { result: Result<List<Any?>?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableMap",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aMapArg = args[1] as Map<String?, Any?>?
            api.echoAsyncNullableMap(pigeon_instanceArg, aMapArg) {
                result: Result<Map<String?, Any?>?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoAsyncNullableEnum",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val anEnumArg = args[1] as ProxyApiTestEnum?
            api.echoAsyncNullableEnum(pigeon_instanceArg, anEnumArg) {
                result: Result<ProxyApiTestEnum?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.staticNoop",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> =
                try {
                  api.staticNoop()
                  listOf(null)
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.echoStaticString",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val aStringArg = args[0] as String
            val wrapped: List<Any?> =
                try {
                  listOf(api.echoStaticString(aStringArg))
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.staticAsyncNoop",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.staticAsyncNoop { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterNoop",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            api.callFlutterNoop(pigeon_instanceArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterThrowError",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            api.callFlutterThrowError(pigeon_instanceArg) { result: Result<Any?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterThrowErrorFromVoid",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            api.callFlutterThrowErrorFromVoid(pigeon_instanceArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoBool",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aBoolArg = args[1] as Boolean
            api.callFlutterEchoBool(pigeon_instanceArg, aBoolArg) { result: Result<Boolean> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoInt",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val anIntArg = args[1] as Long
            api.callFlutterEchoInt(pigeon_instanceArg, anIntArg) { result: Result<Long> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoDouble",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aDoubleArg = args[1] as Double
            api.callFlutterEchoDouble(pigeon_instanceArg, aDoubleArg) { result: Result<Double> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoString",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aStringArg = args[1] as String
            api.callFlutterEchoString(pigeon_instanceArg, aStringArg) { result: Result<String> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoUint8List",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aUint8ListArg = args[1] as ByteArray
            api.callFlutterEchoUint8List(pigeon_instanceArg, aUint8ListArg) {
                result: Result<ByteArray> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoList",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aListArg = args[1] as List<Any?>
            api.callFlutterEchoList(pigeon_instanceArg, aListArg) { result: Result<List<Any?>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoProxyApiList",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aListArg = args[1] as List<ProxyApiTestClass?>
            api.callFlutterEchoProxyApiList(pigeon_instanceArg, aListArg) {
                result: Result<List<ProxyApiTestClass?>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoMap",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aMapArg = args[1] as Map<String?, Any?>
            api.callFlutterEchoMap(pigeon_instanceArg, aMapArg) { result: Result<Map<String?, Any?>>
              ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoProxyApiMap",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aMapArg = args[1] as Map<String?, ProxyApiTestClass?>
            api.callFlutterEchoProxyApiMap(pigeon_instanceArg, aMapArg) {
                result: Result<Map<String?, ProxyApiTestClass?>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoEnum",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val anEnumArg = args[1] as ProxyApiTestEnum
            api.callFlutterEchoEnum(pigeon_instanceArg, anEnumArg) {
                result: Result<ProxyApiTestEnum> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoProxyApi",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aProxyApiArg = args[1] as com.example.test_plugin.ProxyApiSuperClass
            api.callFlutterEchoProxyApi(pigeon_instanceArg, aProxyApiArg) {
                result: Result<com.example.test_plugin.ProxyApiSuperClass> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableBool",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aBoolArg = args[1] as Boolean?
            api.callFlutterEchoNullableBool(pigeon_instanceArg, aBoolArg) { result: Result<Boolean?>
              ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableInt",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val anIntArg = args[1] as Long?
            api.callFlutterEchoNullableInt(pigeon_instanceArg, anIntArg) { result: Result<Long?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableDouble",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aDoubleArg = args[1] as Double?
            api.callFlutterEchoNullableDouble(pigeon_instanceArg, aDoubleArg) {
                result: Result<Double?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableString",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aStringArg = args[1] as String?
            api.callFlutterEchoNullableString(pigeon_instanceArg, aStringArg) {
                result: Result<String?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableUint8List",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aUint8ListArg = args[1] as ByteArray?
            api.callFlutterEchoNullableUint8List(pigeon_instanceArg, aUint8ListArg) {
                result: Result<ByteArray?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableList",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aListArg = args[1] as List<Any?>?
            api.callFlutterEchoNullableList(pigeon_instanceArg, aListArg) {
                result: Result<List<Any?>?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableMap",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aMapArg = args[1] as Map<String?, Any?>?
            api.callFlutterEchoNullableMap(pigeon_instanceArg, aMapArg) {
                result: Result<Map<String?, Any?>?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableEnum",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val anEnumArg = args[1] as ProxyApiTestEnum?
            api.callFlutterEchoNullableEnum(pigeon_instanceArg, anEnumArg) {
                result: Result<ProxyApiTestEnum?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoNullableProxyApi",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aProxyApiArg = args[1] as com.example.test_plugin.ProxyApiSuperClass?
            api.callFlutterEchoNullableProxyApi(pigeon_instanceArg, aProxyApiArg) {
                result: Result<com.example.test_plugin.ProxyApiSuperClass?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterNoopAsync",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            api.callFlutterNoopAsync(pigeon_instanceArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.callFlutterEchoAsyncString",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as ProxyApiTestClass
            val aStringArg = args[1] as String
            api.callFlutterEchoAsyncString(pigeon_instanceArg, aStringArg) { result: Result<String>
              ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ProxyApiTestsPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ProxyApiTestsPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of ProxyApiTestClass and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(pigeon_instanceArg: ProxyApiTestClass, callback: (Result<Unit>) -> Unit) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      callback(
          Result.failure(
              ProxyApiTestsError(
                  "new-instance-error",
                  "Attempting to create a new Dart instance of ProxyApiTestClass, but the class has a nonnull callback method.",
                  "")))
    }
  }

  /** A no-op function taking no arguments and returning no value, to sanity test basic calling. */
  fun flutterNoop(pigeon_instanceArg: ProxyApiTestClass, callback: (Result<Unit>) -> Unit) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName = "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterNoop"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Responds with an error from an async function returning a value. */
  fun flutterThrowError(pigeon_instanceArg: ProxyApiTestClass, callback: (Result<Any?>) -> Unit) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterThrowError"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0]
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Responds with an error from an async void function. */
  fun flutterThrowErrorFromVoid(
      pigeon_instanceArg: ProxyApiTestClass,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterThrowErrorFromVoid"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Returns the passed boolean, to test serialization and deserialization. */
  fun flutterEchoBool(
      pigeon_instanceArg: ProxyApiTestClass,
      aBoolArg: Boolean,
      callback: (Result<Boolean>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoBool"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, aBoolArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  ProxyApiTestsError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as Boolean
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Returns the passed int, to test serialization and deserialization. */
  fun flutterEchoInt(
      pigeon_instanceArg: ProxyApiTestClass,
      anIntArg: Long,
      callback: (Result<Long>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName = "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoInt"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, anIntArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  ProxyApiTestsError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as Long
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Returns the passed double, to test serialization and deserialization. */
  fun flutterEchoDouble(
      pigeon_instanceArg: ProxyApiTestClass,
      aDoubleArg: Double,
      callback: (Result<Double>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoDouble"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, aDoubleArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  ProxyApiTestsError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as Double
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Returns the passed string, to test serialization and deserialization. */
  fun flutterEchoString(
      pigeon_instanceArg: ProxyApiTestClass,
      aStringArg: String,
      callback: (Result<String>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoString"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, aStringArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  ProxyApiTestsError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as String
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Returns the passed byte list, to test serialization and deserialization. */
  fun flutterEchoUint8List(
      pigeon_instanceArg: ProxyApiTestClass,
      aListArg: ByteArray,
      callback: (Result<ByteArray>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoUint8List"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, aListArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  ProxyApiTestsError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as ByteArray
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Returns the passed list, to test serialization and deserialization. */
  fun flutterEchoList(
      pigeon_instanceArg: ProxyApiTestClass,
      aListArg: List<Any?>,
      callback: (Result<List<Any?>>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoList"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, aListArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  ProxyApiTestsError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as List<Any?>
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Returns the passed list with ProxyApis, to test serialization and deserialization. */
  fun flutterEchoProxyApiList(
      pigeon_instanceArg: ProxyApiTestClass,
      aListArg: List<ProxyApiTestClass?>,
      callback: (Result<List<ProxyApiTestClass?>>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoProxyApiList"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, aListArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  ProxyApiTestsError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as List<ProxyApiTestClass?>
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Returns the passed map, to test serialization and deserialization. */
  fun flutterEchoMap(
      pigeon_instanceArg: ProxyApiTestClass,
      aMapArg: Map<String?, Any?>,
      callback: (Result<Map<String?, Any?>>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName = "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoMap"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, aMapArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  ProxyApiTestsError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as Map<String?, Any?>
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Returns the passed map with ProxyApis, to test serialization and deserialization. */
  fun flutterEchoProxyApiMap(
      pigeon_instanceArg: ProxyApiTestClass,
      aMapArg: Map<String?, ProxyApiTestClass?>,
      callback: (Result<Map<String?, ProxyApiTestClass?>>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoProxyApiMap"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, aMapArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  ProxyApiTestsError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as Map<String?, ProxyApiTestClass?>
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Returns the passed enum to test serialization and deserialization. */
  fun flutterEchoEnum(
      pigeon_instanceArg: ProxyApiTestClass,
      anEnumArg: ProxyApiTestEnum,
      callback: (Result<ProxyApiTestEnum>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoEnum"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, anEnumArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  ProxyApiTestsError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as ProxyApiTestEnum
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Returns the passed ProxyApi to test serialization and deserialization. */
  fun flutterEchoProxyApi(
      pigeon_instanceArg: ProxyApiTestClass,
      aProxyApiArg: com.example.test_plugin.ProxyApiSuperClass,
      callback: (Result<com.example.test_plugin.ProxyApiSuperClass>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoProxyApi"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, aProxyApiArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  ProxyApiTestsError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as com.example.test_plugin.ProxyApiSuperClass
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Returns the passed boolean, to test serialization and deserialization. */
  fun flutterEchoNullableBool(
      pigeon_instanceArg: ProxyApiTestClass,
      aBoolArg: Boolean?,
      callback: (Result<Boolean?>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableBool"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, aBoolArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as Boolean?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Returns the passed int, to test serialization and deserialization. */
  fun flutterEchoNullableInt(
      pigeon_instanceArg: ProxyApiTestClass,
      anIntArg: Long?,
      callback: (Result<Long?>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableInt"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, anIntArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as Long?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Returns the passed double, to test serialization and deserialization. */
  fun flutterEchoNullableDouble(
      pigeon_instanceArg: ProxyApiTestClass,
      aDoubleArg: Double?,
      callback: (Result<Double?>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableDouble"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, aDoubleArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as Double?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Returns the passed string, to test serialization and deserialization. */
  fun flutterEchoNullableString(
      pigeon_instanceArg: ProxyApiTestClass,
      aStringArg: String?,
      callback: (Result<String?>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableString"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, aStringArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as String?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Returns the passed byte list, to test serialization and deserialization. */
  fun flutterEchoNullableUint8List(
      pigeon_instanceArg: ProxyApiTestClass,
      aListArg: ByteArray?,
      callback: (Result<ByteArray?>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableUint8List"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, aListArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as ByteArray?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Returns the passed list, to test serialization and deserialization. */
  fun flutterEchoNullableList(
      pigeon_instanceArg: ProxyApiTestClass,
      aListArg: List<Any?>?,
      callback: (Result<List<Any?>?>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableList"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, aListArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as List<Any?>?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Returns the passed map, to test serialization and deserialization. */
  fun flutterEchoNullableMap(
      pigeon_instanceArg: ProxyApiTestClass,
      aMapArg: Map<String?, Any?>?,
      callback: (Result<Map<String?, Any?>?>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableMap"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, aMapArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as Map<String?, Any?>?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Returns the passed enum to test serialization and deserialization. */
  fun flutterEchoNullableEnum(
      pigeon_instanceArg: ProxyApiTestClass,
      anEnumArg: ProxyApiTestEnum?,
      callback: (Result<ProxyApiTestEnum?>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableEnum"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, anEnumArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as ProxyApiTestEnum?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Returns the passed ProxyApi to test serialization and deserialization. */
  fun flutterEchoNullableProxyApi(
      pigeon_instanceArg: ProxyApiTestClass,
      aProxyApiArg: com.example.test_plugin.ProxyApiSuperClass?,
      callback: (Result<com.example.test_plugin.ProxyApiSuperClass?>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoNullableProxyApi"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, aProxyApiArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          val output = it[0] as com.example.test_plugin.ProxyApiSuperClass?
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /**
   * A no-op function taking no arguments and returning no value, to sanity test basic asynchronous
   * calling.
   */
  fun flutterNoopAsync(pigeon_instanceArg: ProxyApiTestClass, callback: (Result<Unit>) -> Unit) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterNoopAsync"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  /** Returns the passed in generic Object asynchronously. */
  fun flutterEchoAsyncString(
      pigeon_instanceArg: ProxyApiTestClass,
      aStringArg: String,
      callback: (Result<String>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiTestClass.flutterEchoAsyncString"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, aStringArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(
              Result.failure(
                  ProxyApiTestsError(
                      "null-error",
                      "Flutter api returned null value for non-null return value.",
                      "")))
        } else {
          val output = it[0] as String
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }

  @Suppress("FunctionName")
  /** An implementation of [PigeonApiProxyApiSuperClass] used to access callback methods */
  fun pigeon_getPigeonApiProxyApiSuperClass(): PigeonApiProxyApiSuperClass {
    return pigeonRegistrar.getPigeonApiProxyApiSuperClass()
  }

  @Suppress("FunctionName")
  /** An implementation of [PigeonApiProxyApiInterface] used to access callback methods */
  fun pigeon_getPigeonApiProxyApiInterface(): PigeonApiProxyApiInterface {
    return pigeonRegistrar.getPigeonApiProxyApiInterface()
  }
}
/** ProxyApi to serve as a super class to the core ProxyApi class. */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiProxyApiSuperClass(
    open val pigeonRegistrar: ProxyApiTestsPigeonProxyApiRegistrar
) {
  abstract fun pigeon_defaultConstructor(): com.example.test_plugin.ProxyApiSuperClass

  abstract fun aSuperMethod(pigeon_instance: com.example.test_plugin.ProxyApiSuperClass)

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiProxyApiSuperClass?) {
      val codec = api?.pigeonRegistrar?.codec ?: ProxyApiTestsPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiSuperClass.pigeon_defaultConstructor",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.pigeon_defaultConstructor(), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiSuperClass.aSuperMethod",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as com.example.test_plugin.ProxyApiSuperClass
            val wrapped: List<Any?> =
                try {
                  api.aSuperMethod(pigeon_instanceArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  ProxyApiTestsPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of ProxyApiSuperClass and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: com.example.test_plugin.ProxyApiSuperClass,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiSuperClass.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(
                    ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/** ProxyApi to serve as an interface to the core ProxyApi class. */
@Suppress("UNCHECKED_CAST")
open class PigeonApiProxyApiInterface(
    open val pigeonRegistrar: ProxyApiTestsPigeonProxyApiRegistrar
) {
  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of ProxyApiInterface and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(pigeon_instanceArg: ProxyApiInterface, callback: (Result<Unit>) -> Unit) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiInterface.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(
                    ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }

  fun anInterfaceMethod(pigeon_instanceArg: ProxyApiInterface, callback: (Result<Unit>) -> Unit) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.pigeon_integration_tests.ProxyApiInterface.anInterfaceMethod"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(
              Result.failure(
                  ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
}

@Suppress("UNCHECKED_CAST")
abstract class PigeonApiClassWithApiRequirement(
    open val pigeonRegistrar: ProxyApiTestsPigeonProxyApiRegistrar
) {
  @androidx.annotation.RequiresApi(api = 25)
  abstract fun pigeon_defaultConstructor(): ClassWithApiRequirement

  @androidx.annotation.RequiresApi(api = 25)
  abstract fun aMethod(pigeon_instance: ClassWithApiRequirement)

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(
        binaryMessenger: BinaryMessenger,
        api: PigeonApiClassWithApiRequirement?
    ) {
      val codec = api?.pigeonRegistrar?.codec ?: ProxyApiTestsPigeonCodec()
      if (android.os.Build.VERSION.SDK_INT >= 25) {
        run {
          val channel =
              BasicMessageChannel<Any?>(
                  binaryMessenger,
                  "dev.flutter.pigeon.pigeon_integration_tests.ClassWithApiRequirement.pigeon_defaultConstructor",
                  codec)
          if (api != null) {
            channel.setMessageHandler { message, reply ->
              val args = message as List<Any?>
              val pigeon_identifierArg = args[0] as Long
              val wrapped: List<Any?> =
                  try {
                    api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                        api.pigeon_defaultConstructor(), pigeon_identifierArg)
                    listOf(null)
                  } catch (exception: Throwable) {
                    ProxyApiTestsPigeonUtils.wrapError(exception)
                  }
              reply.reply(wrapped)
            }
          } else {
            channel.setMessageHandler(null)
          }
        }
      } else {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ClassWithApiRequirement.pigeon_defaultConstructor",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            reply.reply(
                ProxyApiTestsPigeonUtils.wrapError(
                    UnsupportedOperationException(
                        "Call references class `ClassWithApiRequirement`, which requires api version 25.")))
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      if (android.os.Build.VERSION.SDK_INT >= 25) {
        run {
          val channel =
              BasicMessageChannel<Any?>(
                  binaryMessenger,
                  "dev.flutter.pigeon.pigeon_integration_tests.ClassWithApiRequirement.aMethod",
                  codec)
          if (api != null) {
            channel.setMessageHandler { message, reply ->
              val args = message as List<Any?>
              val pigeon_instanceArg = args[0] as ClassWithApiRequirement
              val wrapped: List<Any?> =
                  try {
                    api.aMethod(pigeon_instanceArg)
                    listOf(null)
                  } catch (exception: Throwable) {
                    ProxyApiTestsPigeonUtils.wrapError(exception)
                  }
              reply.reply(wrapped)
            }
          } else {
            channel.setMessageHandler(null)
          }
        }
      } else {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.pigeon_integration_tests.ClassWithApiRequirement.aMethod",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            reply.reply(
                ProxyApiTestsPigeonUtils.wrapError(
                    UnsupportedOperationException(
                        "Call references class `ClassWithApiRequirement`, which requires api version 25.")))
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of ClassWithApiRequirement and attaches it to [pigeon_instanceArg]. */
  @androidx.annotation.RequiresApi(api = 25)
  fun pigeon_newInstance(
      pigeon_instanceArg: ClassWithApiRequirement,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              ProxyApiTestsError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.pigeon_integration_tests.ClassWithApiRequirement.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(
                    ProxyApiTestsError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(ProxyApiTestsPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
