// Copyright 2013 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon, do not edit directly.
// See also: https://pub.dev/packages/pigeon

import Foundation

#if os(iOS)
  import Flutter
#elseif os(macOS)
  import FlutterMacOS
#else
  #error("Unsupported platform.")
#endif

private func isNullish(_ value: Any?) -> Bool {
  return value is NSNull || value == nil
}

private func nilOrValue<T>(_ value: Any?) -> T? {
  if value is NSNull { return nil }
  return value as! T?
}

func deepEqualsEventChannelMessages(_ lhs: Any?, _ rhs: Any?) -> Bool {
  let cleanLhs = nilOrValue(lhs) as Any?
  let cleanRhs = nilOrValue(rhs) as Any?
  switch (cleanLhs, cleanRhs) {
  case (nil, nil):
    return true

  case (nil, _), (_, nil):
    return false

  case is (Void, Void):
    return true

  case let (cleanLhsHashable, cleanRhsHashable) as (AnyHashable, AnyHashable):
    return cleanLhsHashable == cleanRhsHashable

  case let (cleanLhsArray, cleanRhsArray) as ([Any?], [Any?]):
    guard cleanLhsArray.count == cleanRhsArray.count else { return false }
    for (index, element) in cleanLhsArray.enumerated() {
      if !deepEqualsEventChannelMessages(element, cleanRhsArray[index]) {
        return false
      }
    }
    return true

  case let (cleanLhsDictionary, cleanRhsDictionary) as ([AnyHashable: Any?], [AnyHashable: Any?]):
    guard cleanLhsDictionary.count == cleanRhsDictionary.count else { return false }
    for (key, cleanLhsValue) in cleanLhsDictionary {
      guard cleanRhsDictionary.index(forKey: key) != nil else { return false }
      if !deepEqualsEventChannelMessages(cleanLhsValue, cleanRhsDictionary[key]!) {
        return false
      }
    }
    return true

  default:
    // Any other type shouldn't be able to be used with pigeon. File an issue if you find this to be untrue.
    return false
  }
}

func deepHashEventChannelMessages(value: Any?, hasher: inout Hasher) {
  if let valueList = value as? [AnyHashable] {
    for item in valueList { deepHashEventChannelMessages(value: item, hasher: &hasher) }
    return
  }

  if let valueDict = value as? [AnyHashable: AnyHashable] {
    for key in valueDict.keys {
      hasher.combine(key)
      deepHashEventChannelMessages(value: valueDict[key]!, hasher: &hasher)
    }
    return
  }

  if let hashableValue = value as? AnyHashable {
    hasher.combine(hashableValue.hashValue)
  }

  return hasher.combine(String(describing: value))
}

/// Generated class from Pigeon that represents data sent in messages.
/// This protocol should not be extended by any user class outside of the generated file.
protocol PlatformEvent {

}

/// Generated class from Pigeon that represents data sent in messages.
struct IntEvent: PlatformEvent {
  var data: Int64

  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> IntEvent? {
    let data = pigeonVar_list[0] as! Int64

    return IntEvent(
      data: data
    )
  }
  func toList() -> [Any?] {
    return [
      data
    ]
  }
  static func == (lhs: IntEvent, rhs: IntEvent) -> Bool {
    return deepEqualsEventChannelMessages(lhs.toList(), rhs.toList())
  }
  func hash(into hasher: inout Hasher) {
    deepHashEventChannelMessages(value: toList(), hasher: &hasher)
  }
}

/// Generated class from Pigeon that represents data sent in messages.
struct StringEvent: PlatformEvent {
  var data: String

  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> StringEvent? {
    let data = pigeonVar_list[0] as! String

    return StringEvent(
      data: data
    )
  }
  func toList() -> [Any?] {
    return [
      data
    ]
  }
  static func == (lhs: StringEvent, rhs: StringEvent) -> Bool {
    return deepEqualsEventChannelMessages(lhs.toList(), rhs.toList())
  }
  func hash(into hasher: inout Hasher) {
    deepHashEventChannelMessages(value: toList(), hasher: &hasher)
  }
}

private class EventChannelMessagesPigeonCodecReader: FlutterStandardReader {
  override func readValue(ofType type: UInt8) -> Any? {
    switch type {
    case 129:
      return IntEvent.fromList(self.readValue() as! [Any?])
    case 130:
      return StringEvent.fromList(self.readValue() as! [Any?])
    default:
      return super.readValue(ofType: type)
    }
  }
}

private class EventChannelMessagesPigeonCodecWriter: FlutterStandardWriter {
  override func writeValue(_ value: Any) {
    if let value = value as? IntEvent {
      super.writeByte(129)
      super.writeValue(value.toList())
    } else if let value = value as? StringEvent {
      super.writeByte(130)
      super.writeValue(value.toList())
    } else {
      super.writeValue(value)
    }
  }
}

private class EventChannelMessagesPigeonCodecReaderWriter: FlutterStandardReaderWriter {
  override func reader(with data: Data) -> FlutterStandardReader {
    return EventChannelMessagesPigeonCodecReader(data: data)
  }

  override func writer(with data: NSMutableData) -> FlutterStandardWriter {
    return EventChannelMessagesPigeonCodecWriter(data: data)
  }
}

class EventChannelMessagesPigeonCodec: FlutterStandardMessageCodec, @unchecked Sendable {
  static let shared = EventChannelMessagesPigeonCodec(
    readerWriter: EventChannelMessagesPigeonCodecReaderWriter())
}

var eventChannelMessagesPigeonMethodCodec = FlutterStandardMethodCodec(
  readerWriter: EventChannelMessagesPigeonCodecReaderWriter())

private class PigeonStreamHandler<ReturnType>: NSObject, FlutterStreamHandler {
  private let wrapper: PigeonEventChannelWrapper<ReturnType>
  private var pigeonSink: PigeonEventSink<ReturnType>? = nil

  init(wrapper: PigeonEventChannelWrapper<ReturnType>) {
    self.wrapper = wrapper
  }

  func onListen(withArguments arguments: Any?, eventSink events: @escaping FlutterEventSink)
    -> FlutterError?
  {
    pigeonSink = PigeonEventSink<ReturnType>(events)
    wrapper.onListen(withArguments: arguments, sink: pigeonSink!)
    return nil
  }

  func onCancel(withArguments arguments: Any?) -> FlutterError? {
    pigeonSink = nil
    wrapper.onCancel(withArguments: arguments)
    return nil
  }
}

class PigeonEventChannelWrapper<ReturnType> {
  func onListen(withArguments arguments: Any?, sink: PigeonEventSink<ReturnType>) {}
  func onCancel(withArguments arguments: Any?) {}
}

class PigeonEventSink<ReturnType> {
  private let sink: FlutterEventSink

  init(_ sink: @escaping FlutterEventSink) {
    self.sink = sink
  }

  func success(_ value: ReturnType) {
    sink(value)
  }

  func error(code: String, message: String?, details: Any?) {
    sink(FlutterError(code: code, message: message, details: details))
  }

  func endOfStream() {
    sink(FlutterEndOfEventStream)
  }

}

class StreamEventsStreamHandler: PigeonEventChannelWrapper<PlatformEvent> {
  static func register(
    with messenger: FlutterBinaryMessenger,
    instanceName: String = "",
    streamHandler: StreamEventsStreamHandler
  ) {
    var channelName = "dev.flutter.pigeon.pigeon_example_package.EventChannelMethods.streamEvents"
    if !instanceName.isEmpty {
      channelName += ".\(instanceName)"
    }
    let internalStreamHandler = PigeonStreamHandler<PlatformEvent>(wrapper: streamHandler)
    let channel = FlutterEventChannel(
      name: channelName, binaryMessenger: messenger, codec: eventChannelMessagesPigeonMethodCodec)
    channel.setStreamHandler(internalStreamHandler)
  }
}
