// Autogenerated from Pigeon (v26.0.2), do not edit directly.
// See also: https://pub.dev/packages/pigeon
@file:Suppress("UNCHECKED_CAST", "ArrayInDataClass")

package com.zulip.flutter

import android.util.Log
import io.flutter.plugin.common.BasicMessageChannel
import io.flutter.plugin.common.BinaryMessenger
import io.flutter.plugin.common.EventChannel
import io.flutter.plugin.common.MessageCodec
import io.flutter.plugin.common.StandardMethodCodec
import io.flutter.plugin.common.StandardMessageCodec
import java.io.ByteArrayOutputStream
import java.nio.ByteBuffer
private object AndroidIntentsPigeonUtils {
  fun deepEquals(a: Any?, b: Any?): Boolean {
    if (a is ByteArray && b is ByteArray) {
        return a.contentEquals(b)
    }
    if (a is IntArray && b is IntArray) {
        return a.contentEquals(b)
    }
    if (a is LongArray && b is LongArray) {
        return a.contentEquals(b)
    }
    if (a is DoubleArray && b is DoubleArray) {
        return a.contentEquals(b)
    }
    if (a is Array<*> && b is Array<*>) {
      return a.size == b.size &&
          a.indices.all{ deepEquals(a[it], b[it]) }
    }
    if (a is List<*> && b is List<*>) {
      return a.size == b.size &&
          a.indices.all{ deepEquals(a[it], b[it]) }
    }
    if (a is Map<*, *> && b is Map<*, *>) {
      return a.size == b.size && a.all {
          (b as Map<Any?, Any?>).containsKey(it.key) &&
          deepEquals(it.value, b[it.key])
      }
    }
    return a == b
  }
      
}

/** Generated class from Pigeon that represents data sent in messages. */
data class IntentSharedFile (
  val name: String? = null,
  val mimeType: String? = null,
  val bytes: ByteArray
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): IntentSharedFile {
      val name = pigeonVar_list[0] as String?
      val mimeType = pigeonVar_list[1] as String?
      val bytes = pigeonVar_list[2] as ByteArray
      return IntentSharedFile(name, mimeType, bytes)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      name,
      mimeType,
      bytes,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is IntentSharedFile) {
      return false
    }
    if (this === other) {
      return true
    }
    return AndroidIntentsPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * Generated class from Pigeon that represents data sent in messages.
 * This class should not be extended by any user class outside of the generated file.
 */
sealed class AndroidIntentEvent 
/** Generated class from Pigeon that represents data sent in messages. */
data class AndroidIntentSendEvent (
  val action: String,
  val extraText: String? = null,
  val extraStream: List<IntentSharedFile>? = null
) : AndroidIntentEvent()
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): AndroidIntentSendEvent {
      val action = pigeonVar_list[0] as String
      val extraText = pigeonVar_list[1] as String?
      val extraStream = pigeonVar_list[2] as List<IntentSharedFile>?
      return AndroidIntentSendEvent(action, extraText, extraStream)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      action,
      extraText,
      extraStream,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is AndroidIntentSendEvent) {
      return false
    }
    if (this === other) {
      return true
    }
    return AndroidIntentsPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}
private open class AndroidIntentsPigeonCodec : StandardMessageCodec() {
  override fun readValueOfType(type: Byte, buffer: ByteBuffer): Any? {
    return when (type) {
      129.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          IntentSharedFile.fromList(it)
        }
      }
      130.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          AndroidIntentSendEvent.fromList(it)
        }
      }
      else -> super.readValueOfType(type, buffer)
    }
  }
  override fun writeValue(stream: ByteArrayOutputStream, value: Any?)   {
    when (value) {
      is IntentSharedFile -> {
        stream.write(129)
        writeValue(stream, value.toList())
      }
      is AndroidIntentSendEvent -> {
        stream.write(130)
        writeValue(stream, value.toList())
      }
      else -> super.writeValue(stream, value)
    }
  }
}

val AndroidIntentsPigeonMethodCodec = StandardMethodCodec(AndroidIntentsPigeonCodec())


private class AndroidIntentsPigeonStreamHandler<T>(
    val wrapper: AndroidIntentsPigeonEventChannelWrapper<T>
) : EventChannel.StreamHandler {
  var pigeonSink: PigeonEventSink<T>? = null

  override fun onListen(p0: Any?, sink: EventChannel.EventSink) {
    pigeonSink = PigeonEventSink<T>(sink)
    wrapper.onListen(p0, pigeonSink!!)
  }

  override fun onCancel(p0: Any?) {
    pigeonSink = null
    wrapper.onCancel(p0)
  }
}

interface AndroidIntentsPigeonEventChannelWrapper<T> {
  open fun onListen(p0: Any?, sink: PigeonEventSink<T>) {}

  open fun onCancel(p0: Any?) {}
}

class PigeonEventSink<T>(private val sink: EventChannel.EventSink) {
  fun success(value: T) {
    sink.success(value)
  }

  fun error(errorCode: String, errorMessage: String?, errorDetails: Any?) {
    sink.error(errorCode, errorMessage, errorDetails)
  }

  fun endOfStream() {
    sink.endOfStream()
  }
}
      
abstract class AndroidIntentEventsStreamHandler : AndroidIntentsPigeonEventChannelWrapper<AndroidIntentEvent> {
  companion object {
    fun register(messenger: BinaryMessenger, streamHandler: AndroidIntentEventsStreamHandler, instanceName: String = "") {
      var channelName: String = "dev.flutter.pigeon.zulip.AndroidIntentsEventChannelApi.androidIntentEvents"
      if (instanceName.isNotEmpty()) {
        channelName += ".$instanceName"
      }
      val internalStreamHandler = AndroidIntentsPigeonStreamHandler<AndroidIntentEvent>(streamHandler)
      EventChannel(messenger, channelName, AndroidIntentsPigeonMethodCodec).setStreamHandler(internalStreamHandler)
    }
  }
}
      
