// Copyright 2013 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v25.5.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon

#import "./include/video_player_avfoundation/messages.g.h"

#if TARGET_OS_OSX
#import <FlutterMacOS/FlutterMacOS.h>
#else
#import <Flutter/Flutter.h>
#endif

#if !__has_feature(objc_arc)
#error File requires ARC to be enabled.
#endif

static NSArray<id> *wrapResult(id result, FlutterError *error) {
  if (error) {
    return @[
      error.code ?: [NSNull null], error.message ?: [NSNull null], error.details ?: [NSNull null]
    ];
  }
  return @[ result ?: [NSNull null] ];
}

static id GetNullableObjectAtIndex(NSArray<id> *array, NSInteger key) {
  id result = array[key];
  return (result == [NSNull null]) ? nil : result;
}

@interface FVPPlatformVideoViewCreationParams ()
+ (FVPPlatformVideoViewCreationParams *)fromList:(NSArray<id> *)list;
+ (nullable FVPPlatformVideoViewCreationParams *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface FVPCreationOptions ()
+ (FVPCreationOptions *)fromList:(NSArray<id> *)list;
+ (nullable FVPCreationOptions *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface FVPTexturePlayerIds ()
+ (FVPTexturePlayerIds *)fromList:(NSArray<id> *)list;
+ (nullable FVPTexturePlayerIds *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@implementation FVPPlatformVideoViewCreationParams
+ (instancetype)makeWithPlayerId:(NSInteger)playerId {
  FVPPlatformVideoViewCreationParams *pigeonResult =
      [[FVPPlatformVideoViewCreationParams alloc] init];
  pigeonResult.playerId = playerId;
  return pigeonResult;
}
+ (FVPPlatformVideoViewCreationParams *)fromList:(NSArray<id> *)list {
  FVPPlatformVideoViewCreationParams *pigeonResult =
      [[FVPPlatformVideoViewCreationParams alloc] init];
  pigeonResult.playerId = [GetNullableObjectAtIndex(list, 0) integerValue];
  return pigeonResult;
}
+ (nullable FVPPlatformVideoViewCreationParams *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [FVPPlatformVideoViewCreationParams fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    @(self.playerId),
  ];
}
@end

@implementation FVPCreationOptions
+ (instancetype)makeWithUri:(NSString *)uri
                httpHeaders:(NSDictionary<NSString *, NSString *> *)httpHeaders {
  FVPCreationOptions *pigeonResult = [[FVPCreationOptions alloc] init];
  pigeonResult.uri = uri;
  pigeonResult.httpHeaders = httpHeaders;
  return pigeonResult;
}
+ (FVPCreationOptions *)fromList:(NSArray<id> *)list {
  FVPCreationOptions *pigeonResult = [[FVPCreationOptions alloc] init];
  pigeonResult.uri = GetNullableObjectAtIndex(list, 0);
  pigeonResult.httpHeaders = GetNullableObjectAtIndex(list, 1);
  return pigeonResult;
}
+ (nullable FVPCreationOptions *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [FVPCreationOptions fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.uri ?: [NSNull null],
    self.httpHeaders ?: [NSNull null],
  ];
}
@end

@implementation FVPTexturePlayerIds
+ (instancetype)makeWithPlayerId:(NSInteger)playerId textureId:(NSInteger)textureId {
  FVPTexturePlayerIds *pigeonResult = [[FVPTexturePlayerIds alloc] init];
  pigeonResult.playerId = playerId;
  pigeonResult.textureId = textureId;
  return pigeonResult;
}
+ (FVPTexturePlayerIds *)fromList:(NSArray<id> *)list {
  FVPTexturePlayerIds *pigeonResult = [[FVPTexturePlayerIds alloc] init];
  pigeonResult.playerId = [GetNullableObjectAtIndex(list, 0) integerValue];
  pigeonResult.textureId = [GetNullableObjectAtIndex(list, 1) integerValue];
  return pigeonResult;
}
+ (nullable FVPTexturePlayerIds *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [FVPTexturePlayerIds fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    @(self.playerId),
    @(self.textureId),
  ];
}
@end

@interface FVPMessagesPigeonCodecReader : FlutterStandardReader
@end
@implementation FVPMessagesPigeonCodecReader
- (nullable id)readValueOfType:(UInt8)type {
  switch (type) {
    case 129:
      return [FVPPlatformVideoViewCreationParams fromList:[self readValue]];
    case 130:
      return [FVPCreationOptions fromList:[self readValue]];
    case 131:
      return [FVPTexturePlayerIds fromList:[self readValue]];
    default:
      return [super readValueOfType:type];
  }
}
@end

@interface FVPMessagesPigeonCodecWriter : FlutterStandardWriter
@end
@implementation FVPMessagesPigeonCodecWriter
- (void)writeValue:(id)value {
  if ([value isKindOfClass:[FVPPlatformVideoViewCreationParams class]]) {
    [self writeByte:129];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[FVPCreationOptions class]]) {
    [self writeByte:130];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[FVPTexturePlayerIds class]]) {
    [self writeByte:131];
    [self writeValue:[value toList]];
  } else {
    [super writeValue:value];
  }
}
@end

@interface FVPMessagesPigeonCodecReaderWriter : FlutterStandardReaderWriter
@end
@implementation FVPMessagesPigeonCodecReaderWriter
- (FlutterStandardWriter *)writerWithData:(NSMutableData *)data {
  return [[FVPMessagesPigeonCodecWriter alloc] initWithData:data];
}
- (FlutterStandardReader *)readerWithData:(NSData *)data {
  return [[FVPMessagesPigeonCodecReader alloc] initWithData:data];
}
@end

NSObject<FlutterMessageCodec> *FVPGetMessagesCodec(void) {
  static FlutterStandardMessageCodec *sSharedObject = nil;
  static dispatch_once_t sPred = 0;
  dispatch_once(&sPred, ^{
    FVPMessagesPigeonCodecReaderWriter *readerWriter =
        [[FVPMessagesPigeonCodecReaderWriter alloc] init];
    sSharedObject = [FlutterStandardMessageCodec codecWithReaderWriter:readerWriter];
  });
  return sSharedObject;
}
void SetUpFVPAVFoundationVideoPlayerApi(id<FlutterBinaryMessenger> binaryMessenger,
                                        NSObject<FVPAVFoundationVideoPlayerApi> *api) {
  SetUpFVPAVFoundationVideoPlayerApiWithSuffix(binaryMessenger, api, @"");
}

void SetUpFVPAVFoundationVideoPlayerApiWithSuffix(id<FlutterBinaryMessenger> binaryMessenger,
                                                  NSObject<FVPAVFoundationVideoPlayerApi> *api,
                                                  NSString *messageChannelSuffix) {
  messageChannelSuffix = messageChannelSuffix.length > 0
                             ? [NSString stringWithFormat:@".%@", messageChannelSuffix]
                             : @"";
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.video_player_avfoundation."
                                                   @"AVFoundationVideoPlayerApi.initialize",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FVPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(initialize:)],
                @"FVPAVFoundationVideoPlayerApi api (%@) doesn't respond to @selector(initialize:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        [api initialize:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString
                            stringWithFormat:@"%@%@",
                                             @"dev.flutter.pigeon.video_player_avfoundation."
                                             @"AVFoundationVideoPlayerApi.createForPlatformView",
                                             messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FVPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(createPlatformViewPlayerWithOptions:error:)],
                @"FVPAVFoundationVideoPlayerApi api (%@) doesn't respond to "
                @"@selector(createPlatformViewPlayerWithOptions:error:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        FVPCreationOptions *arg_params = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        NSNumber *output = [api createPlatformViewPlayerWithOptions:arg_params error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString
                            stringWithFormat:@"%@%@",
                                             @"dev.flutter.pigeon.video_player_avfoundation."
                                             @"AVFoundationVideoPlayerApi.createForTextureView",
                                             messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FVPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(createTexturePlayerWithOptions:error:)],
                @"FVPAVFoundationVideoPlayerApi api (%@) doesn't respond to "
                @"@selector(createTexturePlayerWithOptions:error:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        FVPCreationOptions *arg_creationOptions = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        FVPTexturePlayerIds *output = [api createTexturePlayerWithOptions:arg_creationOptions
                                                                    error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.video_player_avfoundation."
                                                   @"AVFoundationVideoPlayerApi.setMixWithOthers",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FVPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setMixWithOthers:error:)],
                @"FVPAVFoundationVideoPlayerApi api (%@) doesn't respond to "
                @"@selector(setMixWithOthers:error:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        BOOL arg_mixWithOthers = [GetNullableObjectAtIndex(args, 0) boolValue];
        FlutterError *error;
        [api setMixWithOthers:arg_mixWithOthers error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.video_player_avfoundation."
                                                   @"AVFoundationVideoPlayerApi.getAssetUrl",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FVPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(fileURLForAssetWithName:package:error:)],
                @"FVPAVFoundationVideoPlayerApi api (%@) doesn't respond to "
                @"@selector(fileURLForAssetWithName:package:error:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        NSString *arg_asset = GetNullableObjectAtIndex(args, 0);
        NSString *arg_package = GetNullableObjectAtIndex(args, 1);
        FlutterError *error;
        NSString *output = [api fileURLForAssetWithName:arg_asset package:arg_package error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
}
void SetUpFVPVideoPlayerInstanceApi(id<FlutterBinaryMessenger> binaryMessenger,
                                    NSObject<FVPVideoPlayerInstanceApi> *api) {
  SetUpFVPVideoPlayerInstanceApiWithSuffix(binaryMessenger, api, @"");
}

void SetUpFVPVideoPlayerInstanceApiWithSuffix(id<FlutterBinaryMessenger> binaryMessenger,
                                              NSObject<FVPVideoPlayerInstanceApi> *api,
                                              NSString *messageChannelSuffix) {
  messageChannelSuffix = messageChannelSuffix.length > 0
                             ? [NSString stringWithFormat:@".%@", messageChannelSuffix]
                             : @"";
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.video_player_avfoundation."
                                                   @"VideoPlayerInstanceApi.setLooping",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FVPGetMessagesCodec()];
    if (api) {
      NSCAssert(
          [api respondsToSelector:@selector(setLooping:error:)],
          @"FVPVideoPlayerInstanceApi api (%@) doesn't respond to @selector(setLooping:error:)",
          api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        BOOL arg_looping = [GetNullableObjectAtIndex(args, 0) boolValue];
        FlutterError *error;
        [api setLooping:arg_looping error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.video_player_avfoundation."
                                                   @"VideoPlayerInstanceApi.setVolume",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FVPGetMessagesCodec()];
    if (api) {
      NSCAssert(
          [api respondsToSelector:@selector(setVolume:error:)],
          @"FVPVideoPlayerInstanceApi api (%@) doesn't respond to @selector(setVolume:error:)",
          api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        double arg_volume = [GetNullableObjectAtIndex(args, 0) doubleValue];
        FlutterError *error;
        [api setVolume:arg_volume error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.video_player_avfoundation."
                                                   @"VideoPlayerInstanceApi.setPlaybackSpeed",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FVPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setPlaybackSpeed:error:)],
                @"FVPVideoPlayerInstanceApi api (%@) doesn't respond to "
                @"@selector(setPlaybackSpeed:error:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        double arg_speed = [GetNullableObjectAtIndex(args, 0) doubleValue];
        FlutterError *error;
        [api setPlaybackSpeed:arg_speed error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.video_player_avfoundation."
                                                   @"VideoPlayerInstanceApi.play",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FVPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(playWithError:)],
                @"FVPVideoPlayerInstanceApi api (%@) doesn't respond to @selector(playWithError:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        [api playWithError:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.video_player_avfoundation."
                                                   @"VideoPlayerInstanceApi.getPosition",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FVPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(position:)],
                @"FVPVideoPlayerInstanceApi api (%@) doesn't respond to @selector(position:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        NSNumber *output = [api position:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.video_player_avfoundation."
                                                   @"VideoPlayerInstanceApi.seekTo",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FVPGetMessagesCodec()];
    if (api) {
      NSCAssert(
          [api respondsToSelector:@selector(seekTo:completion:)],
          @"FVPVideoPlayerInstanceApi api (%@) doesn't respond to @selector(seekTo:completion:)",
          api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        NSInteger arg_position = [GetNullableObjectAtIndex(args, 0) integerValue];
        [api seekTo:arg_position
            completion:^(FlutterError *_Nullable error) {
              callback(wrapResult(nil, error));
            }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.video_player_avfoundation."
                                                   @"VideoPlayerInstanceApi.pause",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FVPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(pauseWithError:)],
                @"FVPVideoPlayerInstanceApi api (%@) doesn't respond to @selector(pauseWithError:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        [api pauseWithError:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.video_player_avfoundation."
                                                   @"VideoPlayerInstanceApi.dispose",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FVPGetMessagesCodec()];
    if (api) {
      NSCAssert(
          [api respondsToSelector:@selector(disposeWithError:)],
          @"FVPVideoPlayerInstanceApi api (%@) doesn't respond to @selector(disposeWithError:)",
          api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        [api disposeWithError:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
}
