@file:Suppress("unused")

package com.zoffcc.applications.undereat

import android.annotation.SuppressLint
import androidx.compose.foundation.ScrollState
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.drawWithContent
import androidx.compose.ui.geometry.CornerRadius
import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.geometry.Size
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp

    @SuppressLint("ComposableModifierFactory")
    @Composable
    fun Modifier.verticalColumnScrollbar(
        scrollState: ScrollState,
        width: Dp = 4.dp,
        showScrollBarTrack: Boolean = true,
        scrollBarTrackColor: Color = Color.Gray,
        scrollBarColor: Color = Color.Black,
        scrollBarCornerRadius: Float = 4f,
        endPadding: Float = 12f
    ): Modifier {
        return drawWithContent {
            // Draw the column's content
            drawContent()
            // Dimensions and calculations
            val viewportHeight = this.size.height
            val totalContentHeight = scrollState.maxValue.toFloat() + viewportHeight
            val scrollValue = scrollState.value.toFloat()
            // Compute scrollbar height and position
            val scrollBarHeight =
                (viewportHeight / totalContentHeight) * viewportHeight
            val scrollBarStartOffset =
                (scrollValue / totalContentHeight) * viewportHeight
            // Draw the track (optional)
            if (showScrollBarTrack) {
                drawRoundRect(
                    cornerRadius = CornerRadius(scrollBarCornerRadius),
                    color = scrollBarTrackColor,
                    topLeft = Offset(this.size.width - endPadding, 0f),
                    size = Size(width.toPx(), viewportHeight),
                )
            }
            // Draw the scrollbar
            drawRoundRect(
                cornerRadius = CornerRadius(scrollBarCornerRadius),
                color = scrollBarColor,
                topLeft = Offset(this.size.width - endPadding, scrollBarStartOffset),
                size = Size(width.toPx(), scrollBarHeight)
            )
        }
    }