CREATE TABLE orma_schema_diff_migration_2 (
  "id" INTEGER PRIMARY KEY AUTOINCREMENT,
  "db_version" INTEGER NOT NULL,
  "version_name" TEXT NOT NULL,
  "version_code" INTEGER NOT NULL,
  "schema_hash" TEXT NOT NULL,
  "sql" TEXT NULL,
  "args" TEXT NULL,
  "created_timestamp" DATETIME DEFAULT CURRENT_TIMESTAMP
);

INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (1, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE TABLE `BootstrapNodeEntryDB` (`num` INTEGER NOT NULL, `udp_node` BOOLEAN NOT NULL, `ip` TEXT NOT NULL, `port` INTEGER NOT NULL, `key_hex` TEXT NOT NULL, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (2, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_num_on_BootstrapNodeEntryDB` ON `BootstrapNodeEntryDB` (`num`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (3, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_udp_node_on_BootstrapNodeEntryDB` ON `BootstrapNodeEntryDB` (`udp_node`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (4, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_ip_on_BootstrapNodeEntryDB` ON `BootstrapNodeEntryDB` (`ip`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (5, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_port_on_BootstrapNodeEntryDB` ON `BootstrapNodeEntryDB` (`port`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (6, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_key_hex_on_BootstrapNodeEntryDB` ON `BootstrapNodeEntryDB` (`key_hex`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (7, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE TABLE `ConferenceDB` (`who_invited__tox_public_key_string` TEXT NOT NULL, `name` TEXT , `peer_count` INTEGER NOT NULL DEFAULT -1, `own_peer_number` INTEGER NOT NULL DEFAULT -1, `kind` INTEGER NOT NULL DEFAULT 0, `tox_conference_number` INTEGER NOT NULL DEFAULT -1, `conference_active` BOOLEAN NOT NULL DEFAULT false, `notification_silent` BOOLEAN DEFAULT false, `conference_identifier` TEXT PRIMARY KEY)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (8, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_who_invited__tox_public_key_string_on_ConferenceDB` ON `ConferenceDB` (`who_invited__tox_public_key_string`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (9, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_name_on_ConferenceDB` ON `ConferenceDB` (`name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (10, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_peer_count_on_ConferenceDB` ON `ConferenceDB` (`peer_count`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (11, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_own_peer_number_on_ConferenceDB` ON `ConferenceDB` (`own_peer_number`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (12, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_kind_on_ConferenceDB` ON `ConferenceDB` (`kind`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (13, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_tox_conference_number_on_ConferenceDB` ON `ConferenceDB` (`tox_conference_number`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (14, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_conference_active_on_ConferenceDB` ON `ConferenceDB` (`conference_active`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (15, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_notification_silent_on_ConferenceDB` ON `ConferenceDB` (`notification_silent`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (16, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE TABLE `ConferenceMessage` (`conference_identifier` TEXT NOT NULL DEFAULT -1, `tox_peerpubkey` TEXT NOT NULL, `tox_peername` TEXT , `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `sent_timestamp` INTEGER , `rcvd_timestamp` INTEGER , `read` BOOLEAN NOT NULL, `is_new` BOOLEAN NOT NULL, `text` TEXT , `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (17, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_conference_identifier_on_ConferenceMessage` ON `ConferenceMessage` (`conference_identifier`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (18, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_tox_peerpubkey_on_ConferenceMessage` ON `ConferenceMessage` (`tox_peerpubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (19, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_tox_peername_on_ConferenceMessage` ON `ConferenceMessage` (`tox_peername`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (20, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_direction_on_ConferenceMessage` ON `ConferenceMessage` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (21, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_ConferenceMessage` ON `ConferenceMessage` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (22, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_ConferenceMessage` ON `ConferenceMessage` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (23, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_rcvd_timestamp_on_ConferenceMessage` ON `ConferenceMessage` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (24, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_is_new_on_ConferenceMessage` ON `ConferenceMessage` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (25, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE TABLE `ConferencePeerCacheDB` (`conference_identifier` TEXT NOT NULL, `peer_pubkey` TEXT NOT NULL, `peer_name` TEXT NOT NULL, `last_update_timestamp` INTEGER NOT NULL DEFAULT -1, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (26, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE UNIQUE INDEX `index_conference_identifier_peer_pubkey_on_ConferencePeerCacheDB` ON `ConferencePeerCacheDB` (`conference_identifier`, `peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (27, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_conference_identifier_on_ConferencePeerCacheDB` ON `ConferencePeerCacheDB` (`conference_identifier`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (28, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_peer_pubkey_on_ConferencePeerCacheDB` ON `ConferencePeerCacheDB` (`peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (29, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_peer_name_on_ConferencePeerCacheDB` ON `ConferencePeerCacheDB` (`peer_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (30, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_last_update_timestamp_on_ConferencePeerCacheDB` ON `ConferencePeerCacheDB` (`last_update_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (31, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE TABLE `FileDB` (`kind` INTEGER NOT NULL, `direction` INTEGER NOT NULL, `tox_public_key_string` TEXT NOT NULL, `path_name` TEXT NOT NULL, `file_name` TEXT NOT NULL, `filesize` INTEGER NOT NULL DEFAULT -1, `is_in_VFS` BOOLEAN NOT NULL DEFAULT true, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (32, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_kind_on_FileDB` ON `FileDB` (`kind`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (33, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_direction_on_FileDB` ON `FileDB` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (34, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_tox_public_key_string_on_FileDB` ON `FileDB` (`tox_public_key_string`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (35, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_path_name_on_FileDB` ON `FileDB` (`path_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (36, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_file_name_on_FileDB` ON `FileDB` (`file_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (37, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_filesize_on_FileDB` ON `FileDB` (`filesize`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (38, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_is_in_VFS_on_FileDB` ON `FileDB` (`is_in_VFS`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (39, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE TABLE `Filetransfer` (`tox_public_key_string` TEXT NOT NULL, `direction` INTEGER NOT NULL, `file_number` INTEGER NOT NULL, `kind` INTEGER NOT NULL, `state` INTEGER NOT NULL, `ft_accepted` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_started` BOOLEAN NOT NULL DEFAULT false, `path_name` TEXT NOT NULL, `file_name` TEXT NOT NULL, `fos_open` BOOLEAN NOT NULL DEFAULT false, `filesize` INTEGER NOT NULL DEFAULT -1, `current_position` INTEGER NOT NULL DEFAULT 0, `message_id` INTEGER NOT NULL DEFAULT -1, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (40, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_tox_public_key_string_on_Filetransfer` ON `Filetransfer` (`tox_public_key_string`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (41, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_direction_on_Filetransfer` ON `Filetransfer` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (42, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_file_number_on_Filetransfer` ON `Filetransfer` (`file_number`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (43, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_kind_on_Filetransfer` ON `Filetransfer` (`kind`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (44, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_state_on_Filetransfer` ON `Filetransfer` (`state`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (45, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_ft_accepted_on_Filetransfer` ON `Filetransfer` (`ft_accepted`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (46, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_ft_outgoing_started_on_Filetransfer` ON `Filetransfer` (`ft_outgoing_started`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (47, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_path_name_on_Filetransfer` ON `Filetransfer` (`path_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (48, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_file_name_on_Filetransfer` ON `Filetransfer` (`file_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (49, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_message_id_on_Filetransfer` ON `Filetransfer` (`message_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (50, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE TABLE `FriendList` (`name` TEXT , `alias_name` TEXT , `status_message` TEXT , `TOX_CONNECTION` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off` INTEGER NOT NULL DEFAULT 0, `TOX_USER_STATUS` INTEGER NOT NULL DEFAULT 0, `avatar_pathname` TEXT , `avatar_filename` TEXT , `notification_silent` BOOLEAN DEFAULT false, `sort` INTEGER NOT NULL DEFAULT 0, `last_online_timestamp` INTEGER NOT NULL DEFAULT -1, `tox_public_key_string` TEXT PRIMARY KEY)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (51, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_alias_name_on_FriendList` ON `FriendList` (`alias_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (52, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_TOX_CONNECTION_on_FriendList` ON `FriendList` (`TOX_CONNECTION`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (53, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_TOX_CONNECTION_on_off_on_FriendList` ON `FriendList` (`TOX_CONNECTION_on_off`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (54, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_TOX_USER_STATUS_on_FriendList` ON `FriendList` (`TOX_USER_STATUS`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (55, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_notification_silent_on_FriendList` ON `FriendList` (`notification_silent`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (56, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_sort_on_FriendList` ON `FriendList` (`sort`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (57, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_last_online_timestamp_on_FriendList` ON `FriendList` (`last_online_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (58, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE TABLE `Message` (`message_id` INTEGER NOT NULL, `tox_friendpubkey` TEXT NOT NULL, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `state` INTEGER NOT NULL DEFAULT 1, `ft_accepted` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_started` BOOLEAN NOT NULL DEFAULT false, `filedb_id` INTEGER NOT NULL DEFAULT -1, `filetransfer_id` INTEGER NOT NULL DEFAULT -1, `sent_timestamp` INTEGER , `rcvd_timestamp` INTEGER , `read` BOOLEAN NOT NULL, `is_new` BOOLEAN NOT NULL, `text` TEXT , `filename_fullpath` TEXT , `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (59, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_message_id_on_Message` ON `Message` (`message_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (60, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_tox_friendpubkey_on_Message` ON `Message` (`tox_friendpubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (61, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_direction_on_Message` ON `Message` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (62, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_Message` ON `Message` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (63, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_Message` ON `Message` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (64, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_state_on_Message` ON `Message` (`state`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (65, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_ft_accepted_on_Message` ON `Message` (`ft_accepted`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (66, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_ft_outgoing_started_on_Message` ON `Message` (`ft_outgoing_started`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (67, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_filedb_id_on_Message` ON `Message` (`filedb_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (68, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_filetransfer_id_on_Message` ON `Message` (`filetransfer_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (69, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_rcvd_timestamp_on_Message` ON `Message` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (70, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_is_new_on_Message` ON `Message` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (71, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE TABLE `TRIFADatabaseGlobals` (`key` TEXT NOT NULL, `value` TEXT NOT NULL)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (72, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_key_on_TRIFADatabaseGlobals` ON `TRIFADatabaseGlobals` (`key`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (73, 74, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', 'CREATE INDEX `index_value_on_TRIFADatabaseGlobals` ON `TRIFADatabaseGlobals` (`value`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (74, 75, '1.0.15', 10015, '0D4D662826D43E1FB9BE3BFB026402E6A548EEE9E135B4FDB0E042C72AC137FD', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (75, 94, '1.0.15', 10015, '574FEAD32C333ADEAA445FDF72FD1D78E4DEB8F226B7B4C85824D531EA9CD178', 'CREATE TABLE `__temp_Message` (`message_id` INTEGER NOT NULL, `tox_friendpubkey` TEXT NOT NULL, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `state` INTEGER NOT NULL DEFAULT 1, `ft_accepted` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_started` BOOLEAN NOT NULL DEFAULT false, `filedb_id` INTEGER NOT NULL DEFAULT - 1, `filetransfer_id` INTEGER NOT NULL DEFAULT - 1, `sent_timestamp` INTEGER DEFAULT 0, `sent_timestamp_ms` INTEGER DEFAULT 0, `rcvd_timestamp` INTEGER DEFAULT 0, `rcvd_timestamp_ms` INTEGER DEFAULT 0, `read` BOOLEAN NOT NULL, `is_new` BOOLEAN NOT NULL, `text` TEXT, `filename_fullpath` TEXT, `msg_id_hash` TEXT, `raw_msgv2_bytes` TEXT, `msg_version` INTEGER NOT NULL DEFAULT 0, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (76, 94, '1.0.15', 10015, '574FEAD32C333ADEAA445FDF72FD1D78E4DEB8F226B7B4C85824D531EA9CD178', 'INSERT INTO `__temp_Message` (`message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `filename_fullpath`, `id`) SELECT `message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `filename_fullpath`, `id` FROM `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (77, 94, '1.0.15', 10015, '574FEAD32C333ADEAA445FDF72FD1D78E4DEB8F226B7B4C85824D531EA9CD178', 'DROP TABLE `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (78, 94, '1.0.15', 10015, '574FEAD32C333ADEAA445FDF72FD1D78E4DEB8F226B7B4C85824D531EA9CD178', 'ALTER TABLE `__temp_Message` RENAME TO `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (79, 94, '1.0.15', 10015, '574FEAD32C333ADEAA445FDF72FD1D78E4DEB8F226B7B4C85824D531EA9CD178', 'CREATE INDEX `index_message_id_on_Message` ON `Message` (`message_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (80, 94, '1.0.15', 10015, '574FEAD32C333ADEAA445FDF72FD1D78E4DEB8F226B7B4C85824D531EA9CD178', 'CREATE INDEX `index_tox_friendpubkey_on_Message` ON `Message` (`tox_friendpubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (81, 94, '1.0.15', 10015, '574FEAD32C333ADEAA445FDF72FD1D78E4DEB8F226B7B4C85824D531EA9CD178', 'CREATE INDEX `index_direction_on_Message` ON `Message` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (82, 94, '1.0.15', 10015, '574FEAD32C333ADEAA445FDF72FD1D78E4DEB8F226B7B4C85824D531EA9CD178', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_Message` ON `Message` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (83, 94, '1.0.15', 10015, '574FEAD32C333ADEAA445FDF72FD1D78E4DEB8F226B7B4C85824D531EA9CD178', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_Message` ON `Message` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (84, 94, '1.0.15', 10015, '574FEAD32C333ADEAA445FDF72FD1D78E4DEB8F226B7B4C85824D531EA9CD178', 'CREATE INDEX `index_state_on_Message` ON `Message` (`state`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (85, 94, '1.0.15', 10015, '574FEAD32C333ADEAA445FDF72FD1D78E4DEB8F226B7B4C85824D531EA9CD178', 'CREATE INDEX `index_ft_accepted_on_Message` ON `Message` (`ft_accepted`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (86, 94, '1.0.15', 10015, '574FEAD32C333ADEAA445FDF72FD1D78E4DEB8F226B7B4C85824D531EA9CD178', 'CREATE INDEX `index_ft_outgoing_started_on_Message` ON `Message` (`ft_outgoing_started`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (87, 94, '1.0.15', 10015, '574FEAD32C333ADEAA445FDF72FD1D78E4DEB8F226B7B4C85824D531EA9CD178', 'CREATE INDEX `index_filedb_id_on_Message` ON `Message` (`filedb_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (88, 94, '1.0.15', 10015, '574FEAD32C333ADEAA445FDF72FD1D78E4DEB8F226B7B4C85824D531EA9CD178', 'CREATE INDEX `index_filetransfer_id_on_Message` ON `Message` (`filetransfer_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (89, 94, '1.0.15', 10015, '574FEAD32C333ADEAA445FDF72FD1D78E4DEB8F226B7B4C85824D531EA9CD178', 'CREATE INDEX `index_rcvd_timestamp_on_Message` ON `Message` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (90, 94, '1.0.15', 10015, '574FEAD32C333ADEAA445FDF72FD1D78E4DEB8F226B7B4C85824D531EA9CD178', 'CREATE INDEX `index_rcvd_timestamp_ms_on_Message` ON `Message` (`rcvd_timestamp_ms`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (91, 94, '1.0.15', 10015, '574FEAD32C333ADEAA445FDF72FD1D78E4DEB8F226B7B4C85824D531EA9CD178', 'CREATE INDEX `index_is_new_on_Message` ON `Message` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (92, 94, '1.0.15', 10015, '574FEAD32C333ADEAA445FDF72FD1D78E4DEB8F226B7B4C85824D531EA9CD178', 'CREATE INDEX `index_msg_id_hash_on_Message` ON `Message` (`msg_id_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (93, 94, '1.0.15', 10015, '574FEAD32C333ADEAA445FDF72FD1D78E4DEB8F226B7B4C85824D531EA9CD178', 'CREATE INDEX `index_raw_msgv2_bytes_on_Message` ON `Message` (`raw_msgv2_bytes`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (94, 94, '1.0.15', 10015, '574FEAD32C333ADEAA445FDF72FD1D78E4DEB8F226B7B4C85824D531EA9CD178', 'CREATE INDEX `index_msg_version_on_Message` ON `Message` (`msg_version`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (95, 95, '1.0.15', 10015, '574FEAD32C333ADEAA445FDF72FD1D78E4DEB8F226B7B4C85824D531EA9CD178', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (96, 115, '1.0.15', 10015, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', 'CREATE TABLE `__temp_Message` (`message_id` INTEGER NOT NULL, `tox_friendpubkey` TEXT NOT NULL, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `state` INTEGER NOT NULL DEFAULT 1, `ft_accepted` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_started` BOOLEAN NOT NULL DEFAULT false, `filedb_id` INTEGER NOT NULL DEFAULT - 1, `filetransfer_id` INTEGER NOT NULL DEFAULT - 1, `sent_timestamp` INTEGER DEFAULT 0, `sent_timestamp_ms` INTEGER DEFAULT 0, `rcvd_timestamp` INTEGER DEFAULT 0, `rcvd_timestamp_ms` INTEGER DEFAULT 0, `read` BOOLEAN NOT NULL, `send_retries` INTEGER NOT NULL DEFAULT 0, `is_new` BOOLEAN NOT NULL, `text` TEXT, `filename_fullpath` TEXT, `msg_id_hash` TEXT, `raw_msgv2_bytes` TEXT, `msg_version` INTEGER NOT NULL DEFAULT 0, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (97, 115, '1.0.15', 10015, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', 'INSERT INTO `__temp_Message` (`message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `id`) SELECT `message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `id` FROM `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (98, 115, '1.0.15', 10015, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', 'DROP TABLE `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (99, 115, '1.0.15', 10015, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', 'ALTER TABLE `__temp_Message` RENAME TO `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (100, 115, '1.0.15', 10015, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', 'CREATE INDEX `index_message_id_on_Message` ON `Message` (`message_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (101, 115, '1.0.15', 10015, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', 'CREATE INDEX `index_tox_friendpubkey_on_Message` ON `Message` (`tox_friendpubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (102, 115, '1.0.15', 10015, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', 'CREATE INDEX `index_direction_on_Message` ON `Message` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (103, 115, '1.0.15', 10015, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_Message` ON `Message` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (104, 115, '1.0.15', 10015, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_Message` ON `Message` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (105, 115, '1.0.15', 10015, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', 'CREATE INDEX `index_state_on_Message` ON `Message` (`state`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (106, 115, '1.0.15', 10015, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', 'CREATE INDEX `index_ft_accepted_on_Message` ON `Message` (`ft_accepted`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (107, 115, '1.0.15', 10015, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', 'CREATE INDEX `index_ft_outgoing_started_on_Message` ON `Message` (`ft_outgoing_started`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (108, 115, '1.0.15', 10015, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', 'CREATE INDEX `index_filedb_id_on_Message` ON `Message` (`filedb_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (109, 115, '1.0.15', 10015, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', 'CREATE INDEX `index_filetransfer_id_on_Message` ON `Message` (`filetransfer_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (110, 115, '1.0.15', 10015, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', 'CREATE INDEX `index_rcvd_timestamp_on_Message` ON `Message` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (111, 115, '1.0.15', 10015, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', 'CREATE INDEX `index_rcvd_timestamp_ms_on_Message` ON `Message` (`rcvd_timestamp_ms`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (112, 115, '1.0.15', 10015, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', 'CREATE INDEX `index_send_retries_on_Message` ON `Message` (`send_retries`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (113, 115, '1.0.15', 10015, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', 'CREATE INDEX `index_is_new_on_Message` ON `Message` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (114, 115, '1.0.15', 10015, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', 'CREATE INDEX `index_msg_id_hash_on_Message` ON `Message` (`msg_id_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (115, 115, '1.0.15', 10015, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', 'CREATE INDEX `index_raw_msgv2_bytes_on_Message` ON `Message` (`raw_msgv2_bytes`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (116, 115, '1.0.15', 10015, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', 'CREATE INDEX `index_msg_version_on_Message` ON `Message` (`msg_version`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (117, 116, '1.0.19', 10019, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (118, 117, '1.0.22', 10022, '5E35471B142073C37EAB602A612EBF4BDB591E87F3DABE04D12838EDB58816CC', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (119, 117, '1.0.22', 10022, 'EB56C2DA3D5DAB5D3EA7AF41A5D27D5267AB0E439B16F44A0006F5CB66E28027', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (120, 117, '1.0.24', 10024, '107E69449FCD3E7E43515347A651109BF9EFEE41D3B86AB6063A7B6C2B96B2E3', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (121, 133, '1.0.25', 10025, '822BF8B8354B3790CD2DA24DA79267911FD5DF68123CB7B92E4FFC991699057A', 'CREATE TABLE `__temp_FriendList` (`name` TEXT, `alias_name` TEXT, `status_message` TEXT, `TOX_CONNECTION` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off` INTEGER NOT NULL DEFAULT 0, `TOX_USER_STATUS` INTEGER NOT NULL DEFAULT 0, `avatar_pathname` TEXT, `avatar_filename` TEXT, `notification_silent` BOOLEAN DEFAULT false, `sort` INTEGER NOT NULL DEFAULT 0, `last_online_timestamp` INTEGER NOT NULL DEFAULT - 1, `is_relay` BOOLEAN DEFAULT false, `tox_public_key_string` TEXT PRIMARY KEY)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (122, 133, '1.0.25', 10025, '822BF8B8354B3790CD2DA24DA79267911FD5DF68123CB7B92E4FFC991699057A', 'INSERT INTO `__temp_FriendList` (`name`, `alias_name`, `status_message`, `TOX_CONNECTION`, `TOX_CONNECTION_on_off`, `TOX_USER_STATUS`, `avatar_pathname`, `avatar_filename`, `notification_silent`, `sort`, `last_online_timestamp`, `tox_public_key_string`) SELECT `name`, `alias_name`, `status_message`, `TOX_CONNECTION`, `TOX_CONNECTION_on_off`, `TOX_USER_STATUS`, `avatar_pathname`, `avatar_filename`, `notification_silent`, `sort`, `last_online_timestamp`, `tox_public_key_string` FROM `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (123, 133, '1.0.25', 10025, '822BF8B8354B3790CD2DA24DA79267911FD5DF68123CB7B92E4FFC991699057A', 'DROP TABLE `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (124, 133, '1.0.25', 10025, '822BF8B8354B3790CD2DA24DA79267911FD5DF68123CB7B92E4FFC991699057A', 'ALTER TABLE `__temp_FriendList` RENAME TO `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (125, 133, '1.0.25', 10025, '822BF8B8354B3790CD2DA24DA79267911FD5DF68123CB7B92E4FFC991699057A', 'CREATE INDEX `index_alias_name_on_FriendList` ON `FriendList` (`alias_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (126, 133, '1.0.25', 10025, '822BF8B8354B3790CD2DA24DA79267911FD5DF68123CB7B92E4FFC991699057A', 'CREATE INDEX `index_TOX_CONNECTION_on_FriendList` ON `FriendList` (`TOX_CONNECTION`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (127, 133, '1.0.25', 10025, '822BF8B8354B3790CD2DA24DA79267911FD5DF68123CB7B92E4FFC991699057A', 'CREATE INDEX `index_TOX_CONNECTION_on_off_on_FriendList` ON `FriendList` (`TOX_CONNECTION_on_off`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (128, 133, '1.0.25', 10025, '822BF8B8354B3790CD2DA24DA79267911FD5DF68123CB7B92E4FFC991699057A', 'CREATE INDEX `index_TOX_USER_STATUS_on_FriendList` ON `FriendList` (`TOX_USER_STATUS`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (129, 133, '1.0.25', 10025, '822BF8B8354B3790CD2DA24DA79267911FD5DF68123CB7B92E4FFC991699057A', 'CREATE INDEX `index_notification_silent_on_FriendList` ON `FriendList` (`notification_silent`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (130, 133, '1.0.25', 10025, '822BF8B8354B3790CD2DA24DA79267911FD5DF68123CB7B92E4FFC991699057A', 'CREATE INDEX `index_sort_on_FriendList` ON `FriendList` (`sort`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (131, 133, '1.0.25', 10025, '822BF8B8354B3790CD2DA24DA79267911FD5DF68123CB7B92E4FFC991699057A', 'CREATE INDEX `index_last_online_timestamp_on_FriendList` ON `FriendList` (`last_online_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (132, 133, '1.0.25', 10025, '822BF8B8354B3790CD2DA24DA79267911FD5DF68123CB7B92E4FFC991699057A', 'CREATE INDEX `index_is_relay_on_FriendList` ON `FriendList` (`is_relay`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (133, 133, '1.0.25', 10025, '822BF8B8354B3790CD2DA24DA79267911FD5DF68123CB7B92E4FFC991699057A', 'CREATE TABLE `RelayListDB` (`TOX_CONNECTION` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off` INTEGER NOT NULL DEFAULT 0, `own_relay` BOOLEAN NOT NULL DEFAULT false, `last_online_timestamp` INTEGER NOT NULL DEFAULT -1, `tox_public_key_string` TEXT PRIMARY KEY)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (134, 133, '1.0.25', 10025, '822BF8B8354B3790CD2DA24DA79267911FD5DF68123CB7B92E4FFC991699057A', 'CREATE INDEX `index_TOX_CONNECTION_on_RelayListDB` ON `RelayListDB` (`TOX_CONNECTION`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (135, 133, '1.0.25', 10025, '822BF8B8354B3790CD2DA24DA79267911FD5DF68123CB7B92E4FFC991699057A', 'CREATE INDEX `index_TOX_CONNECTION_on_off_on_RelayListDB` ON `RelayListDB` (`TOX_CONNECTION_on_off`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (136, 133, '1.0.25', 10025, '822BF8B8354B3790CD2DA24DA79267911FD5DF68123CB7B92E4FFC991699057A', 'CREATE INDEX `index_own_relay_on_RelayListDB` ON `RelayListDB` (`own_relay`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (137, 133, '1.0.25', 10025, '822BF8B8354B3790CD2DA24DA79267911FD5DF68123CB7B92E4FFC991699057A', 'CREATE INDEX `index_last_online_timestamp_on_RelayListDB` ON `RelayListDB` (`last_online_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (138, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'CREATE TABLE `__temp_RelayListDB` (`TOX_CONNECTION` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off` INTEGER NOT NULL DEFAULT 0, `own_relay` BOOLEAN NOT NULL DEFAULT false, `last_online_timestamp` INTEGER NOT NULL DEFAULT - 1, `tox_public_key_string_of_owner` TEXT, `tox_public_key_string` TEXT PRIMARY KEY)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (139, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'INSERT INTO `__temp_RelayListDB` (`TOX_CONNECTION`, `TOX_CONNECTION_on_off`, `own_relay`, `last_online_timestamp`, `tox_public_key_string`) SELECT `TOX_CONNECTION`, `TOX_CONNECTION_on_off`, `own_relay`, `last_online_timestamp`, `tox_public_key_string` FROM `RelayListDB`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (140, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'DROP TABLE `RelayListDB`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (141, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'ALTER TABLE `__temp_RelayListDB` RENAME TO `RelayListDB`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (142, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'CREATE INDEX `index_TOX_CONNECTION_on_RelayListDB` ON `RelayListDB` (`TOX_CONNECTION`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (143, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'CREATE INDEX `index_TOX_CONNECTION_on_off_on_RelayListDB` ON `RelayListDB` (`TOX_CONNECTION_on_off`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (144, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'CREATE INDEX `index_own_relay_on_RelayListDB` ON `RelayListDB` (`own_relay`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (145, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'CREATE INDEX `index_last_online_timestamp_on_RelayListDB` ON `RelayListDB` (`last_online_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (146, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'CREATE INDEX `index_tox_public_key_string_of_owner_on_RelayListDB` ON `RelayListDB` (`tox_public_key_string_of_owner`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (147, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'CREATE TABLE `__temp_FriendList` (`name` TEXT, `alias_name` TEXT, `status_message` TEXT, `TOX_CONNECTION` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_real` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off_real` INTEGER NOT NULL DEFAULT 0, `TOX_USER_STATUS` INTEGER NOT NULL DEFAULT 0, `avatar_pathname` TEXT, `avatar_filename` TEXT, `notification_silent` BOOLEAN DEFAULT false, `sort` INTEGER NOT NULL DEFAULT 0, `last_online_timestamp` INTEGER NOT NULL DEFAULT - 1, `is_relay` BOOLEAN DEFAULT false, `tox_public_key_string` TEXT PRIMARY KEY)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (148, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'INSERT INTO `__temp_FriendList` (`name`, `alias_name`, `status_message`, `TOX_CONNECTION`, `TOX_CONNECTION_on_off`, `TOX_USER_STATUS`, `avatar_pathname`, `avatar_filename`, `notification_silent`, `sort`, `last_online_timestamp`, `is_relay`, `tox_public_key_string`) SELECT `name`, `alias_name`, `status_message`, `TOX_CONNECTION`, `TOX_CONNECTION_on_off`, `TOX_USER_STATUS`, `avatar_pathname`, `avatar_filename`, `notification_silent`, `sort`, `last_online_timestamp`, `is_relay`, `tox_public_key_string` FROM `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (149, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'DROP TABLE `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (150, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'ALTER TABLE `__temp_FriendList` RENAME TO `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (151, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'CREATE INDEX `index_alias_name_on_FriendList` ON `FriendList` (`alias_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (152, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'CREATE INDEX `index_TOX_CONNECTION_on_FriendList` ON `FriendList` (`TOX_CONNECTION`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (153, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'CREATE INDEX `index_TOX_CONNECTION_real_on_FriendList` ON `FriendList` (`TOX_CONNECTION_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (154, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'CREATE INDEX `index_TOX_CONNECTION_on_off_on_FriendList` ON `FriendList` (`TOX_CONNECTION_on_off`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (155, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'CREATE INDEX `index_TOX_CONNECTION_on_off_real_on_FriendList` ON `FriendList` (`TOX_CONNECTION_on_off_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (156, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'CREATE INDEX `index_TOX_USER_STATUS_on_FriendList` ON `FriendList` (`TOX_USER_STATUS`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (157, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'CREATE INDEX `index_notification_silent_on_FriendList` ON `FriendList` (`notification_silent`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (158, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'CREATE INDEX `index_sort_on_FriendList` ON `FriendList` (`sort`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (159, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'CREATE INDEX `index_last_online_timestamp_on_FriendList` ON `FriendList` (`last_online_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (160, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', 'CREATE INDEX `index_is_relay_on_FriendList` ON `FriendList` (`is_relay`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (161, 154, '1.0.25', 10025, '86AE4B223449240B1BC711C3F593FDC9C66D8A9CADA1B234D8308BF436FD6705', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (162, 154, '1.0.25', 10025, '85AFEB54BAAA95F1358D2D2110973A22DB20E577AB72E48A722DFA5EA4068466', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (163, 154, '1.0.25', 10025, '86AE4B223449240B1BC711C3F593FDC9C66D8A9CADA1B234D8308BF436FD6705', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (164, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', 'CREATE TABLE `__temp_Message` (`message_id` INTEGER NOT NULL, `tox_friendpubkey` TEXT NOT NULL, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `state` INTEGER NOT NULL DEFAULT 1, `ft_accepted` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_started` BOOLEAN NOT NULL DEFAULT false, `filedb_id` INTEGER NOT NULL DEFAULT - 1, `filetransfer_id` INTEGER NOT NULL DEFAULT - 1, `sent_timestamp` INTEGER DEFAULT 0, `sent_timestamp_ms` INTEGER DEFAULT 0, `rcvd_timestamp` INTEGER DEFAULT 0, `rcvd_timestamp_ms` INTEGER DEFAULT 0, `read` BOOLEAN NOT NULL, `send_retries` INTEGER NOT NULL DEFAULT 0, `is_new` BOOLEAN NOT NULL, `text` TEXT, `filename_fullpath` TEXT, `msg_id_hash` TEXT, `raw_msgv2_bytes` TEXT, `msg_version` INTEGER NOT NULL DEFAULT 0, `resend_count` INTEGER NOT NULL DEFAULT 2, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (165, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', 'INSERT INTO `__temp_Message` (`message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `send_retries`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `id`) SELECT `message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `send_retries`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `id` FROM `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (166, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', 'DROP TABLE `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (167, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', 'ALTER TABLE `__temp_Message` RENAME TO `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (168, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', 'CREATE INDEX `index_message_id_on_Message` ON `Message` (`message_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (169, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', 'CREATE INDEX `index_tox_friendpubkey_on_Message` ON `Message` (`tox_friendpubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (170, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', 'CREATE INDEX `index_direction_on_Message` ON `Message` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (171, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_Message` ON `Message` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (172, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_Message` ON `Message` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (173, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', 'CREATE INDEX `index_state_on_Message` ON `Message` (`state`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (174, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', 'CREATE INDEX `index_ft_accepted_on_Message` ON `Message` (`ft_accepted`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (175, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', 'CREATE INDEX `index_ft_outgoing_started_on_Message` ON `Message` (`ft_outgoing_started`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (176, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', 'CREATE INDEX `index_filedb_id_on_Message` ON `Message` (`filedb_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (177, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', 'CREATE INDEX `index_filetransfer_id_on_Message` ON `Message` (`filetransfer_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (178, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', 'CREATE INDEX `index_rcvd_timestamp_on_Message` ON `Message` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (179, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', 'CREATE INDEX `index_rcvd_timestamp_ms_on_Message` ON `Message` (`rcvd_timestamp_ms`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (180, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', 'CREATE INDEX `index_send_retries_on_Message` ON `Message` (`send_retries`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (181, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', 'CREATE INDEX `index_is_new_on_Message` ON `Message` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (182, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', 'CREATE INDEX `index_msg_id_hash_on_Message` ON `Message` (`msg_id_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (183, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', 'CREATE INDEX `index_raw_msgv2_bytes_on_Message` ON `Message` (`raw_msgv2_bytes`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (184, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', 'CREATE INDEX `index_msg_version_on_Message` ON `Message` (`msg_version`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (185, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', 'CREATE INDEX `index_resend_count_on_Message` ON `Message` (`resend_count`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (186, 175, '1.0.26', 10026, '4158A8CD2272C68CF639B2A2E65E67D2F2FA7C679B3A1FE7BF39B9382E4A13CD', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (187, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (188, 175, '1.0.26', 10026, '4158A8CD2272C68CF639B2A2E65E67D2F2FA7C679B3A1FE7BF39B9382E4A13CD', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (189, 175, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (190, 176, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (191, 177, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (192, 177, '1.0.26', 10026, '4158A8CD2272C68CF639B2A2E65E67D2F2FA7C679B3A1FE7BF39B9382E4A13CD', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (193, 177, '1.0.26', 10026, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (194, 178, '1.0.27', 10027, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (195, 178, '1.0.27', 10027, '4158A8CD2272C68CF639B2A2E65E67D2F2FA7C679B3A1FE7BF39B9382E4A13CD', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (196, 178, '1.0.27', 10027, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (197, 179, '1.0.27', 10027, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (198, 180, '1.0.28', 10028, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (199, 181, '1.0.28', 10028, '5D4829DA179E28E252E81F21A2F78377F6C20AD59586397F9D3117EBEA7CD7CD', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (200, 183, '1.0.28', 10028, 'F375F5ACDCEE1A766DE420FB7F462771C54CE7DBA5E70CCECC1031747C48D897', 'CREATE TABLE `TRIFADatabaseGlobalsNew` (`value` TEXT NOT NULL, `key` TEXT PRIMARY KEY)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (201, 183, '1.0.28', 10028, 'F375F5ACDCEE1A766DE420FB7F462771C54CE7DBA5E70CCECC1031747C48D897', 'CREATE INDEX `index_value_on_TRIFADatabaseGlobalsNew` ON `TRIFADatabaseGlobalsNew` (`value`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (202, 197, '1.0.28', 10028, '3F1F4462F7CD3492134E18A2C3A74E1332C489D67C33AF06C5ED39237EACEC20', 'CREATE TABLE `__temp_FriendList` (`name` TEXT, `alias_name` TEXT, `status_message` TEXT, `TOX_CONNECTION` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_real` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off_real` INTEGER NOT NULL DEFAULT 0, `TOX_USER_STATUS` INTEGER NOT NULL DEFAULT 0, `avatar_pathname` TEXT, `avatar_filename` TEXT, `avatar_update` BOOLEAN DEFAULT false, `notification_silent` BOOLEAN DEFAULT false, `sort` INTEGER NOT NULL DEFAULT 0, `last_online_timestamp` INTEGER NOT NULL DEFAULT - 1, `is_relay` BOOLEAN DEFAULT false, `tox_public_key_string` TEXT PRIMARY KEY)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (203, 197, '1.0.28', 10028, '3F1F4462F7CD3492134E18A2C3A74E1332C489D67C33AF06C5ED39237EACEC20', 'INSERT INTO `__temp_FriendList` (`name`, `alias_name`, `status_message`, `TOX_CONNECTION`, `TOX_CONNECTION_real`, `TOX_CONNECTION_on_off`, `TOX_CONNECTION_on_off_real`, `TOX_USER_STATUS`, `avatar_pathname`, `avatar_filename`, `notification_silent`, `sort`, `last_online_timestamp`, `is_relay`, `tox_public_key_string`) SELECT `name`, `alias_name`, `status_message`, `TOX_CONNECTION`, `TOX_CONNECTION_real`, `TOX_CONNECTION_on_off`, `TOX_CONNECTION_on_off_real`, `TOX_USER_STATUS`, `avatar_pathname`, `avatar_filename`, `notification_silent`, `sort`, `last_online_timestamp`, `is_relay`, `tox_public_key_string` FROM `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (204, 197, '1.0.28', 10028, '3F1F4462F7CD3492134E18A2C3A74E1332C489D67C33AF06C5ED39237EACEC20', 'DROP TABLE `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (205, 197, '1.0.28', 10028, '3F1F4462F7CD3492134E18A2C3A74E1332C489D67C33AF06C5ED39237EACEC20', 'ALTER TABLE `__temp_FriendList` RENAME TO `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (206, 197, '1.0.28', 10028, '3F1F4462F7CD3492134E18A2C3A74E1332C489D67C33AF06C5ED39237EACEC20', 'CREATE INDEX `index_alias_name_on_FriendList` ON `FriendList` (`alias_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (207, 197, '1.0.28', 10028, '3F1F4462F7CD3492134E18A2C3A74E1332C489D67C33AF06C5ED39237EACEC20', 'CREATE INDEX `index_TOX_CONNECTION_on_FriendList` ON `FriendList` (`TOX_CONNECTION`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (208, 197, '1.0.28', 10028, '3F1F4462F7CD3492134E18A2C3A74E1332C489D67C33AF06C5ED39237EACEC20', 'CREATE INDEX `index_TOX_CONNECTION_real_on_FriendList` ON `FriendList` (`TOX_CONNECTION_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (209, 197, '1.0.28', 10028, '3F1F4462F7CD3492134E18A2C3A74E1332C489D67C33AF06C5ED39237EACEC20', 'CREATE INDEX `index_TOX_CONNECTION_on_off_on_FriendList` ON `FriendList` (`TOX_CONNECTION_on_off`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (210, 197, '1.0.28', 10028, '3F1F4462F7CD3492134E18A2C3A74E1332C489D67C33AF06C5ED39237EACEC20', 'CREATE INDEX `index_TOX_CONNECTION_on_off_real_on_FriendList` ON `FriendList` (`TOX_CONNECTION_on_off_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (211, 197, '1.0.28', 10028, '3F1F4462F7CD3492134E18A2C3A74E1332C489D67C33AF06C5ED39237EACEC20', 'CREATE INDEX `index_TOX_USER_STATUS_on_FriendList` ON `FriendList` (`TOX_USER_STATUS`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (212, 197, '1.0.28', 10028, '3F1F4462F7CD3492134E18A2C3A74E1332C489D67C33AF06C5ED39237EACEC20', 'CREATE INDEX `index_avatar_update_on_FriendList` ON `FriendList` (`avatar_update`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (213, 197, '1.0.28', 10028, '3F1F4462F7CD3492134E18A2C3A74E1332C489D67C33AF06C5ED39237EACEC20', 'CREATE INDEX `index_notification_silent_on_FriendList` ON `FriendList` (`notification_silent`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (214, 197, '1.0.28', 10028, '3F1F4462F7CD3492134E18A2C3A74E1332C489D67C33AF06C5ED39237EACEC20', 'CREATE INDEX `index_sort_on_FriendList` ON `FriendList` (`sort`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (215, 197, '1.0.28', 10028, '3F1F4462F7CD3492134E18A2C3A74E1332C489D67C33AF06C5ED39237EACEC20', 'CREATE INDEX `index_last_online_timestamp_on_FriendList` ON `FriendList` (`last_online_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (216, 197, '1.0.28', 10028, '3F1F4462F7CD3492134E18A2C3A74E1332C489D67C33AF06C5ED39237EACEC20', 'CREATE INDEX `index_is_relay_on_FriendList` ON `FriendList` (`is_relay`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (217, 198, '1.0.28', 10028, '3F1F4462F7CD3492134E18A2C3A74E1332C489D67C33AF06C5ED39237EACEC20', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (218, 213, '1.0.28', 10028, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', 'CREATE TABLE `__temp_FriendList` (`name` TEXT, `alias_name` TEXT, `status_message` TEXT, `TOX_CONNECTION` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_real` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off_real` INTEGER NOT NULL DEFAULT 0, `TOX_USER_STATUS` INTEGER NOT NULL DEFAULT 0, `avatar_pathname` TEXT, `avatar_filename` TEXT, `avatar_update` BOOLEAN DEFAULT false, `avatar_update_timestamp` INTEGER NOT NULL DEFAULT - 1, `notification_silent` BOOLEAN DEFAULT false, `sort` INTEGER NOT NULL DEFAULT 0, `last_online_timestamp` INTEGER NOT NULL DEFAULT - 1, `is_relay` BOOLEAN DEFAULT false, `tox_public_key_string` TEXT PRIMARY KEY)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (219, 213, '1.0.28', 10028, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', 'INSERT INTO `__temp_FriendList` (`name`, `alias_name`, `status_message`, `TOX_CONNECTION`, `TOX_CONNECTION_real`, `TOX_CONNECTION_on_off`, `TOX_CONNECTION_on_off_real`, `TOX_USER_STATUS`, `avatar_pathname`, `avatar_filename`, `avatar_update`, `notification_silent`, `sort`, `last_online_timestamp`, `is_relay`, `tox_public_key_string`) SELECT `name`, `alias_name`, `status_message`, `TOX_CONNECTION`, `TOX_CONNECTION_real`, `TOX_CONNECTION_on_off`, `TOX_CONNECTION_on_off_real`, `TOX_USER_STATUS`, `avatar_pathname`, `avatar_filename`, `avatar_update`, `notification_silent`, `sort`, `last_online_timestamp`, `is_relay`, `tox_public_key_string` FROM `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (220, 213, '1.0.28', 10028, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', 'DROP TABLE `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (221, 213, '1.0.28', 10028, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', 'ALTER TABLE `__temp_FriendList` RENAME TO `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (222, 213, '1.0.28', 10028, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', 'CREATE INDEX `index_alias_name_on_FriendList` ON `FriendList` (`alias_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (223, 213, '1.0.28', 10028, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', 'CREATE INDEX `index_TOX_CONNECTION_on_FriendList` ON `FriendList` (`TOX_CONNECTION`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (224, 213, '1.0.28', 10028, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', 'CREATE INDEX `index_TOX_CONNECTION_real_on_FriendList` ON `FriendList` (`TOX_CONNECTION_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (225, 213, '1.0.28', 10028, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', 'CREATE INDEX `index_TOX_CONNECTION_on_off_on_FriendList` ON `FriendList` (`TOX_CONNECTION_on_off`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (226, 213, '1.0.28', 10028, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', 'CREATE INDEX `index_TOX_CONNECTION_on_off_real_on_FriendList` ON `FriendList` (`TOX_CONNECTION_on_off_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (227, 213, '1.0.28', 10028, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', 'CREATE INDEX `index_TOX_USER_STATUS_on_FriendList` ON `FriendList` (`TOX_USER_STATUS`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (228, 213, '1.0.28', 10028, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', 'CREATE INDEX `index_avatar_update_on_FriendList` ON `FriendList` (`avatar_update`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (229, 213, '1.0.28', 10028, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', 'CREATE INDEX `index_avatar_update_timestamp_on_FriendList` ON `FriendList` (`avatar_update_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (230, 213, '1.0.28', 10028, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', 'CREATE INDEX `index_notification_silent_on_FriendList` ON `FriendList` (`notification_silent`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (231, 213, '1.0.28', 10028, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', 'CREATE INDEX `index_sort_on_FriendList` ON `FriendList` (`sort`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (232, 213, '1.0.28', 10028, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', 'CREATE INDEX `index_last_online_timestamp_on_FriendList` ON `FriendList` (`last_online_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (233, 213, '1.0.28', 10028, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', 'CREATE INDEX `index_is_relay_on_FriendList` ON `FriendList` (`is_relay`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (234, 214, '1.0.28', 10028, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (235, 215, '1.0.28', 10028, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (236, 216, '1.0.29', 10029, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (237, 217, '1.0.29', 10029, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (238, 218, '1.0.31', 10031, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (239, 219, '1.0.35', 10035, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (240, 220, '1.0.38', 10038, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (241, 221, '1.0.53', 10053, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (242, 222, '1.0.69', 10069, '55BF94750A51333528593BAEA340BBA90B49EBEDE31A8C592B8E701397E2972D', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (243, 238, '1.0.79', 10079, 'B3C46C449D0242640D944047598C3763873E479E0376A7A9D4FE6869FB588953', 'CREATE TABLE `__temp_FriendList` (`name` TEXT, `alias_name` TEXT, `status_message` TEXT, `TOX_CONNECTION` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_real` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off_real` INTEGER NOT NULL DEFAULT 0, `TOX_USER_STATUS` INTEGER NOT NULL DEFAULT 0, `avatar_pathname` TEXT, `avatar_filename` TEXT, `avatar_update` BOOLEAN DEFAULT false, `avatar_update_timestamp` INTEGER NOT NULL DEFAULT - 1, `notification_silent` BOOLEAN DEFAULT false, `sort` INTEGER NOT NULL DEFAULT 0, `last_online_timestamp` INTEGER NOT NULL DEFAULT - 1, `added_timestamp` INTEGER NOT NULL DEFAULT - 1, `is_relay` BOOLEAN DEFAULT false, `tox_public_key_string` TEXT PRIMARY KEY)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (244, 238, '1.0.79', 10079, 'B3C46C449D0242640D944047598C3763873E479E0376A7A9D4FE6869FB588953', 'INSERT INTO `__temp_FriendList` (`name`, `alias_name`, `status_message`, `TOX_CONNECTION`, `TOX_CONNECTION_real`, `TOX_CONNECTION_on_off`, `TOX_CONNECTION_on_off_real`, `TOX_USER_STATUS`, `avatar_pathname`, `avatar_filename`, `avatar_update`, `avatar_update_timestamp`, `notification_silent`, `sort`, `last_online_timestamp`, `is_relay`, `tox_public_key_string`) SELECT `name`, `alias_name`, `status_message`, `TOX_CONNECTION`, `TOX_CONNECTION_real`, `TOX_CONNECTION_on_off`, `TOX_CONNECTION_on_off_real`, `TOX_USER_STATUS`, `avatar_pathname`, `avatar_filename`, `avatar_update`, `avatar_update_timestamp`, `notification_silent`, `sort`, `last_online_timestamp`, `is_relay`, `tox_public_key_string` FROM `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (245, 238, '1.0.79', 10079, 'B3C46C449D0242640D944047598C3763873E479E0376A7A9D4FE6869FB588953', 'DROP TABLE `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (246, 238, '1.0.79', 10079, 'B3C46C449D0242640D944047598C3763873E479E0376A7A9D4FE6869FB588953', 'ALTER TABLE `__temp_FriendList` RENAME TO `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (247, 238, '1.0.79', 10079, 'B3C46C449D0242640D944047598C3763873E479E0376A7A9D4FE6869FB588953', 'CREATE INDEX `index_alias_name_on_FriendList` ON `FriendList` (`alias_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (248, 238, '1.0.79', 10079, 'B3C46C449D0242640D944047598C3763873E479E0376A7A9D4FE6869FB588953', 'CREATE INDEX `index_TOX_CONNECTION_on_FriendList` ON `FriendList` (`TOX_CONNECTION`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (249, 238, '1.0.79', 10079, 'B3C46C449D0242640D944047598C3763873E479E0376A7A9D4FE6869FB588953', 'CREATE INDEX `index_TOX_CONNECTION_real_on_FriendList` ON `FriendList` (`TOX_CONNECTION_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (250, 238, '1.0.79', 10079, 'B3C46C449D0242640D944047598C3763873E479E0376A7A9D4FE6869FB588953', 'CREATE INDEX `index_TOX_CONNECTION_on_off_on_FriendList` ON `FriendList` (`TOX_CONNECTION_on_off`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (251, 238, '1.0.79', 10079, 'B3C46C449D0242640D944047598C3763873E479E0376A7A9D4FE6869FB588953', 'CREATE INDEX `index_TOX_CONNECTION_on_off_real_on_FriendList` ON `FriendList` (`TOX_CONNECTION_on_off_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (252, 238, '1.0.79', 10079, 'B3C46C449D0242640D944047598C3763873E479E0376A7A9D4FE6869FB588953', 'CREATE INDEX `index_TOX_USER_STATUS_on_FriendList` ON `FriendList` (`TOX_USER_STATUS`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (253, 238, '1.0.79', 10079, 'B3C46C449D0242640D944047598C3763873E479E0376A7A9D4FE6869FB588953', 'CREATE INDEX `index_avatar_update_on_FriendList` ON `FriendList` (`avatar_update`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (254, 238, '1.0.79', 10079, 'B3C46C449D0242640D944047598C3763873E479E0376A7A9D4FE6869FB588953', 'CREATE INDEX `index_avatar_update_timestamp_on_FriendList` ON `FriendList` (`avatar_update_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (255, 238, '1.0.79', 10079, 'B3C46C449D0242640D944047598C3763873E479E0376A7A9D4FE6869FB588953', 'CREATE INDEX `index_notification_silent_on_FriendList` ON `FriendList` (`notification_silent`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (256, 238, '1.0.79', 10079, 'B3C46C449D0242640D944047598C3763873E479E0376A7A9D4FE6869FB588953', 'CREATE INDEX `index_sort_on_FriendList` ON `FriendList` (`sort`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (257, 238, '1.0.79', 10079, 'B3C46C449D0242640D944047598C3763873E479E0376A7A9D4FE6869FB588953', 'CREATE INDEX `index_last_online_timestamp_on_FriendList` ON `FriendList` (`last_online_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (258, 238, '1.0.79', 10079, 'B3C46C449D0242640D944047598C3763873E479E0376A7A9D4FE6869FB588953', 'CREATE INDEX `index_added_timestamp_on_FriendList` ON `FriendList` (`added_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (259, 238, '1.0.79', 10079, 'B3C46C449D0242640D944047598C3763873E479E0376A7A9D4FE6869FB588953', 'CREATE INDEX `index_is_relay_on_FriendList` ON `FriendList` (`is_relay`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (260, 97, '1.0.80', 10080, 'B3C46C449D0242640D944047598C3763873E479E0376A7A9D4FE6869FB588953', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (261, 97, '1.0.81', 10081, 'E3D276466554DF1AB522CDC502DC93A47344CFB6702B20B7DA545958FCB68368', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (262, 109, '1.0.82', 10082, '49CBFCE48581565290AC82F9BEFE61A4DF6D8A632C4B2348B0FC0E1F2D3F8D8A', 'CREATE TABLE `__temp_ConferenceMessage` (`conference_identifier` TEXT NOT NULL DEFAULT - 1, `tox_peerpubkey` TEXT NOT NULL, `tox_peername` TEXT, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `sent_timestamp` INTEGER, `rcvd_timestamp` INTEGER, `read` BOOLEAN NOT NULL, `is_new` BOOLEAN NOT NULL, `text` TEXT, `was_synced` BOOLEAN, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (263, 109, '1.0.82', 10082, '49CBFCE48581565290AC82F9BEFE61A4DF6D8A632C4B2348B0FC0E1F2D3F8D8A', 'INSERT INTO `__temp_ConferenceMessage` (`conference_identifier`, `tox_peerpubkey`, `tox_peername`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `id`) SELECT `conference_identifier`, `tox_peerpubkey`, `tox_peername`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `id` FROM `ConferenceMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (264, 109, '1.0.82', 10082, '49CBFCE48581565290AC82F9BEFE61A4DF6D8A632C4B2348B0FC0E1F2D3F8D8A', 'DROP TABLE `ConferenceMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (265, 109, '1.0.82', 10082, '49CBFCE48581565290AC82F9BEFE61A4DF6D8A632C4B2348B0FC0E1F2D3F8D8A', 'ALTER TABLE `__temp_ConferenceMessage` RENAME TO `ConferenceMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (266, 109, '1.0.82', 10082, '49CBFCE48581565290AC82F9BEFE61A4DF6D8A632C4B2348B0FC0E1F2D3F8D8A', 'CREATE INDEX `index_conference_identifier_on_ConferenceMessage` ON `ConferenceMessage` (`conference_identifier`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (267, 109, '1.0.82', 10082, '49CBFCE48581565290AC82F9BEFE61A4DF6D8A632C4B2348B0FC0E1F2D3F8D8A', 'CREATE INDEX `index_tox_peerpubkey_on_ConferenceMessage` ON `ConferenceMessage` (`tox_peerpubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (268, 109, '1.0.82', 10082, '49CBFCE48581565290AC82F9BEFE61A4DF6D8A632C4B2348B0FC0E1F2D3F8D8A', 'CREATE INDEX `index_tox_peername_on_ConferenceMessage` ON `ConferenceMessage` (`tox_peername`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (269, 109, '1.0.82', 10082, '49CBFCE48581565290AC82F9BEFE61A4DF6D8A632C4B2348B0FC0E1F2D3F8D8A', 'CREATE INDEX `index_direction_on_ConferenceMessage` ON `ConferenceMessage` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (270, 109, '1.0.82', 10082, '49CBFCE48581565290AC82F9BEFE61A4DF6D8A632C4B2348B0FC0E1F2D3F8D8A', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_ConferenceMessage` ON `ConferenceMessage` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (271, 109, '1.0.82', 10082, '49CBFCE48581565290AC82F9BEFE61A4DF6D8A632C4B2348B0FC0E1F2D3F8D8A', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_ConferenceMessage` ON `ConferenceMessage` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (272, 109, '1.0.82', 10082, '49CBFCE48581565290AC82F9BEFE61A4DF6D8A632C4B2348B0FC0E1F2D3F8D8A', 'CREATE INDEX `index_rcvd_timestamp_on_ConferenceMessage` ON `ConferenceMessage` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (273, 109, '1.0.82', 10082, '49CBFCE48581565290AC82F9BEFE61A4DF6D8A632C4B2348B0FC0E1F2D3F8D8A', 'CREATE INDEX `index_is_new_on_ConferenceMessage` ON `ConferenceMessage` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (274, 109, '1.0.82', 10082, '49CBFCE48581565290AC82F9BEFE61A4DF6D8A632C4B2348B0FC0E1F2D3F8D8A', 'CREATE INDEX `index_was_synced_on_ConferenceMessage` ON `ConferenceMessage` (`was_synced`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (275, 126, '1.0.84', 10084, '222D57B68A8438D95F6E6534F9105FCC6EE0CA5C6CD28652974452AF57C055BE', 'CREATE TABLE `__temp_FriendList` (`name` TEXT, `alias_name` TEXT, `status_message` TEXT, `TOX_CONNECTION` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_real` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off_real` INTEGER NOT NULL DEFAULT 0, `TOX_USER_STATUS` INTEGER NOT NULL DEFAULT 0, `avatar_pathname` TEXT, `avatar_filename` TEXT, `avatar_update` BOOLEAN DEFAULT false, `avatar_update_timestamp` INTEGER NOT NULL DEFAULT - 1, `notification_silent` BOOLEAN DEFAULT false, `sort` INTEGER NOT NULL DEFAULT 0, `last_online_timestamp` INTEGER NOT NULL DEFAULT - 1, `last_online_timestamp_real` INTEGER NOT NULL DEFAULT - 1, `added_timestamp` INTEGER NOT NULL DEFAULT - 1, `is_relay` BOOLEAN DEFAULT false, `tox_public_key_string` TEXT PRIMARY KEY)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (276, 126, '1.0.84', 10084, '222D57B68A8438D95F6E6534F9105FCC6EE0CA5C6CD28652974452AF57C055BE', 'INSERT INTO `__temp_FriendList` (`name`, `alias_name`, `status_message`, `TOX_CONNECTION`, `TOX_CONNECTION_real`, `TOX_CONNECTION_on_off`, `TOX_CONNECTION_on_off_real`, `TOX_USER_STATUS`, `avatar_pathname`, `avatar_filename`, `avatar_update`, `avatar_update_timestamp`, `notification_silent`, `sort`, `last_online_timestamp`, `added_timestamp`, `is_relay`, `tox_public_key_string`) SELECT `name`, `alias_name`, `status_message`, `TOX_CONNECTION`, `TOX_CONNECTION_real`, `TOX_CONNECTION_on_off`, `TOX_CONNECTION_on_off_real`, `TOX_USER_STATUS`, `avatar_pathname`, `avatar_filename`, `avatar_update`, `avatar_update_timestamp`, `notification_silent`, `sort`, `last_online_timestamp`, `added_timestamp`, `is_relay`, `tox_public_key_string` FROM `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (277, 126, '1.0.84', 10084, '222D57B68A8438D95F6E6534F9105FCC6EE0CA5C6CD28652974452AF57C055BE', 'DROP TABLE `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (278, 126, '1.0.84', 10084, '222D57B68A8438D95F6E6534F9105FCC6EE0CA5C6CD28652974452AF57C055BE', 'ALTER TABLE `__temp_FriendList` RENAME TO `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (279, 126, '1.0.84', 10084, '222D57B68A8438D95F6E6534F9105FCC6EE0CA5C6CD28652974452AF57C055BE', 'CREATE INDEX `index_alias_name_on_FriendList` ON `FriendList` (`alias_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (280, 126, '1.0.84', 10084, '222D57B68A8438D95F6E6534F9105FCC6EE0CA5C6CD28652974452AF57C055BE', 'CREATE INDEX `index_TOX_CONNECTION_on_FriendList` ON `FriendList` (`TOX_CONNECTION`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (281, 126, '1.0.84', 10084, '222D57B68A8438D95F6E6534F9105FCC6EE0CA5C6CD28652974452AF57C055BE', 'CREATE INDEX `index_TOX_CONNECTION_real_on_FriendList` ON `FriendList` (`TOX_CONNECTION_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (282, 126, '1.0.84', 10084, '222D57B68A8438D95F6E6534F9105FCC6EE0CA5C6CD28652974452AF57C055BE', 'CREATE INDEX `index_TOX_CONNECTION_on_off_on_FriendList` ON `FriendList` (`TOX_CONNECTION_on_off`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (283, 126, '1.0.84', 10084, '222D57B68A8438D95F6E6534F9105FCC6EE0CA5C6CD28652974452AF57C055BE', 'CREATE INDEX `index_TOX_CONNECTION_on_off_real_on_FriendList` ON `FriendList` (`TOX_CONNECTION_on_off_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (284, 126, '1.0.84', 10084, '222D57B68A8438D95F6E6534F9105FCC6EE0CA5C6CD28652974452AF57C055BE', 'CREATE INDEX `index_TOX_USER_STATUS_on_FriendList` ON `FriendList` (`TOX_USER_STATUS`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (285, 126, '1.0.84', 10084, '222D57B68A8438D95F6E6534F9105FCC6EE0CA5C6CD28652974452AF57C055BE', 'CREATE INDEX `index_avatar_update_on_FriendList` ON `FriendList` (`avatar_update`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (286, 126, '1.0.84', 10084, '222D57B68A8438D95F6E6534F9105FCC6EE0CA5C6CD28652974452AF57C055BE', 'CREATE INDEX `index_avatar_update_timestamp_on_FriendList` ON `FriendList` (`avatar_update_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (287, 126, '1.0.84', 10084, '222D57B68A8438D95F6E6534F9105FCC6EE0CA5C6CD28652974452AF57C055BE', 'CREATE INDEX `index_notification_silent_on_FriendList` ON `FriendList` (`notification_silent`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (288, 126, '1.0.84', 10084, '222D57B68A8438D95F6E6534F9105FCC6EE0CA5C6CD28652974452AF57C055BE', 'CREATE INDEX `index_sort_on_FriendList` ON `FriendList` (`sort`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (289, 126, '1.0.84', 10084, '222D57B68A8438D95F6E6534F9105FCC6EE0CA5C6CD28652974452AF57C055BE', 'CREATE INDEX `index_last_online_timestamp_on_FriendList` ON `FriendList` (`last_online_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (290, 126, '1.0.84', 10084, '222D57B68A8438D95F6E6534F9105FCC6EE0CA5C6CD28652974452AF57C055BE', 'CREATE INDEX `index_last_online_timestamp_real_on_FriendList` ON `FriendList` (`last_online_timestamp_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (291, 126, '1.0.84', 10084, '222D57B68A8438D95F6E6534F9105FCC6EE0CA5C6CD28652974452AF57C055BE', 'CREATE INDEX `index_added_timestamp_on_FriendList` ON `FriendList` (`added_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (292, 126, '1.0.84', 10084, '222D57B68A8438D95F6E6534F9105FCC6EE0CA5C6CD28652974452AF57C055BE', 'CREATE INDEX `index_is_relay_on_FriendList` ON `FriendList` (`is_relay`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (293, 127, '1.0.86', 10086, '8C2297DC91AA040A136E0D202E3FF2104BE5107BDF87415DF8B08B5C4D02FD9E', 'CREATE INDEX `index_text_on_Message` ON `Message` (`text`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (294, 140, '1.0.93', 10093, 'D3ACD214B8B620DDBB4B797B752005D27C853A15A9ED37B6423601B928DD9854', 'CREATE TABLE `__temp_ConferenceMessage` (`message_id_tox` TEXT, `conference_identifier` TEXT NOT NULL DEFAULT - 1, `tox_peerpubkey` TEXT NOT NULL, `tox_peername` TEXT, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `sent_timestamp` INTEGER, `rcvd_timestamp` INTEGER, `read` BOOLEAN NOT NULL, `is_new` BOOLEAN NOT NULL, `text` TEXT, `was_synced` BOOLEAN, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (295, 140, '1.0.93', 10093, 'D3ACD214B8B620DDBB4B797B752005D27C853A15A9ED37B6423601B928DD9854', 'INSERT INTO `__temp_ConferenceMessage` (`conference_identifier`, `tox_peerpubkey`, `tox_peername`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `was_synced`, `id`) SELECT `conference_identifier`, `tox_peerpubkey`, `tox_peername`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `was_synced`, `id` FROM `ConferenceMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (296, 140, '1.0.93', 10093, 'D3ACD214B8B620DDBB4B797B752005D27C853A15A9ED37B6423601B928DD9854', 'DROP TABLE `ConferenceMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (297, 140, '1.0.93', 10093, 'D3ACD214B8B620DDBB4B797B752005D27C853A15A9ED37B6423601B928DD9854', 'ALTER TABLE `__temp_ConferenceMessage` RENAME TO `ConferenceMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (298, 140, '1.0.93', 10093, 'D3ACD214B8B620DDBB4B797B752005D27C853A15A9ED37B6423601B928DD9854', 'CREATE INDEX `index_message_id_tox_on_ConferenceMessage` ON `ConferenceMessage` (`message_id_tox`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (299, 140, '1.0.93', 10093, 'D3ACD214B8B620DDBB4B797B752005D27C853A15A9ED37B6423601B928DD9854', 'CREATE INDEX `index_conference_identifier_on_ConferenceMessage` ON `ConferenceMessage` (`conference_identifier`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (300, 140, '1.0.93', 10093, 'D3ACD214B8B620DDBB4B797B752005D27C853A15A9ED37B6423601B928DD9854', 'CREATE INDEX `index_tox_peerpubkey_on_ConferenceMessage` ON `ConferenceMessage` (`tox_peerpubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (301, 140, '1.0.93', 10093, 'D3ACD214B8B620DDBB4B797B752005D27C853A15A9ED37B6423601B928DD9854', 'CREATE INDEX `index_tox_peername_on_ConferenceMessage` ON `ConferenceMessage` (`tox_peername`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (302, 140, '1.0.93', 10093, 'D3ACD214B8B620DDBB4B797B752005D27C853A15A9ED37B6423601B928DD9854', 'CREATE INDEX `index_direction_on_ConferenceMessage` ON `ConferenceMessage` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (303, 140, '1.0.93', 10093, 'D3ACD214B8B620DDBB4B797B752005D27C853A15A9ED37B6423601B928DD9854', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_ConferenceMessage` ON `ConferenceMessage` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (304, 140, '1.0.93', 10093, 'D3ACD214B8B620DDBB4B797B752005D27C853A15A9ED37B6423601B928DD9854', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_ConferenceMessage` ON `ConferenceMessage` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (305, 140, '1.0.93', 10093, 'D3ACD214B8B620DDBB4B797B752005D27C853A15A9ED37B6423601B928DD9854', 'CREATE INDEX `index_rcvd_timestamp_on_ConferenceMessage` ON `ConferenceMessage` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (306, 140, '1.0.93', 10093, 'D3ACD214B8B620DDBB4B797B752005D27C853A15A9ED37B6423601B928DD9854', 'CREATE INDEX `index_is_new_on_ConferenceMessage` ON `ConferenceMessage` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (307, 140, '1.0.93', 10093, 'D3ACD214B8B620DDBB4B797B752005D27C853A15A9ED37B6423601B928DD9854', 'CREATE INDEX `index_was_synced_on_ConferenceMessage` ON `ConferenceMessage` (`was_synced`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (308, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE TABLE `__temp_Filetransfer` (`tox_public_key_string` TEXT NOT NULL, `direction` INTEGER NOT NULL, `file_number` INTEGER NOT NULL, `kind` INTEGER NOT NULL, `state` INTEGER NOT NULL, `ft_accepted` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_started` BOOLEAN NOT NULL DEFAULT false, `path_name` TEXT NOT NULL, `file_name` TEXT NOT NULL, `fos_open` BOOLEAN NOT NULL DEFAULT false, `filesize` INTEGER NOT NULL DEFAULT - 1, `current_position` INTEGER NOT NULL DEFAULT 0, `message_id` INTEGER NOT NULL DEFAULT - 1, `storage_frame_work` BOOLEAN NOT NULL DEFAULT false, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (309, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'INSERT INTO `__temp_Filetransfer` (`tox_public_key_string`, `direction`, `file_number`, `kind`, `state`, `ft_accepted`, `ft_outgoing_started`, `path_name`, `file_name`, `fos_open`, `filesize`, `current_position`, `message_id`, `id`) SELECT `tox_public_key_string`, `direction`, `file_number`, `kind`, `state`, `ft_accepted`, `ft_outgoing_started`, `path_name`, `file_name`, `fos_open`, `filesize`, `current_position`, `message_id`, `id` FROM `Filetransfer`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (310, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'DROP TABLE `Filetransfer`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (311, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'ALTER TABLE `__temp_Filetransfer` RENAME TO `Filetransfer`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (312, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_tox_public_key_string_on_Filetransfer` ON `Filetransfer` (`tox_public_key_string`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (313, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_direction_on_Filetransfer` ON `Filetransfer` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (314, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_file_number_on_Filetransfer` ON `Filetransfer` (`file_number`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (315, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_kind_on_Filetransfer` ON `Filetransfer` (`kind`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (316, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_state_on_Filetransfer` ON `Filetransfer` (`state`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (317, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_ft_accepted_on_Filetransfer` ON `Filetransfer` (`ft_accepted`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (318, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_ft_outgoing_started_on_Filetransfer` ON `Filetransfer` (`ft_outgoing_started`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (319, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_path_name_on_Filetransfer` ON `Filetransfer` (`path_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (320, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_file_name_on_Filetransfer` ON `Filetransfer` (`file_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (321, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_message_id_on_Filetransfer` ON `Filetransfer` (`message_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (322, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_storage_frame_work_on_Filetransfer` ON `Filetransfer` (`storage_frame_work`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (323, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE TABLE `__temp_Message` (`message_id` INTEGER NOT NULL, `tox_friendpubkey` TEXT NOT NULL, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `state` INTEGER NOT NULL DEFAULT 1, `ft_accepted` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_started` BOOLEAN NOT NULL DEFAULT false, `filedb_id` INTEGER NOT NULL DEFAULT - 1, `filetransfer_id` INTEGER NOT NULL DEFAULT - 1, `sent_timestamp` INTEGER DEFAULT 0, `sent_timestamp_ms` INTEGER DEFAULT 0, `rcvd_timestamp` INTEGER DEFAULT 0, `rcvd_timestamp_ms` INTEGER DEFAULT 0, `read` BOOLEAN NOT NULL, `send_retries` INTEGER NOT NULL DEFAULT 0, `is_new` BOOLEAN NOT NULL, `text` TEXT, `filename_fullpath` TEXT, `msg_id_hash` TEXT, `raw_msgv2_bytes` TEXT, `msg_version` INTEGER NOT NULL DEFAULT 0, `resend_count` INTEGER NOT NULL DEFAULT 2, `storage_frame_work` BOOLEAN NOT NULL DEFAULT false, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (324, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'INSERT INTO `__temp_Message` (`message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `send_retries`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `resend_count`, `id`) SELECT `message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `send_retries`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `resend_count`, `id` FROM `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (325, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'DROP TABLE `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (326, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'ALTER TABLE `__temp_Message` RENAME TO `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (327, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_message_id_on_Message` ON `Message` (`message_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (328, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_tox_friendpubkey_on_Message` ON `Message` (`tox_friendpubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (329, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_direction_on_Message` ON `Message` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (330, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_Message` ON `Message` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (331, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_Message` ON `Message` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (332, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_state_on_Message` ON `Message` (`state`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (333, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_ft_accepted_on_Message` ON `Message` (`ft_accepted`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (334, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_ft_outgoing_started_on_Message` ON `Message` (`ft_outgoing_started`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (335, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_filedb_id_on_Message` ON `Message` (`filedb_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (336, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_filetransfer_id_on_Message` ON `Message` (`filetransfer_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (337, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_rcvd_timestamp_on_Message` ON `Message` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (338, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_rcvd_timestamp_ms_on_Message` ON `Message` (`rcvd_timestamp_ms`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (339, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_send_retries_on_Message` ON `Message` (`send_retries`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (340, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_is_new_on_Message` ON `Message` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (341, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_text_on_Message` ON `Message` (`text`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (342, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_msg_id_hash_on_Message` ON `Message` (`msg_id_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (343, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_raw_msgv2_bytes_on_Message` ON `Message` (`raw_msgv2_bytes`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (344, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_msg_version_on_Message` ON `Message` (`msg_version`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (345, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_resend_count_on_Message` ON `Message` (`resend_count`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (346, 177, '1.0.96', 10096, '8D8D46FBE39647FA8633E2A74D73A697FD7549D8B8E8263860BFDC04980D1DC1', 'CREATE INDEX `index_storage_frame_work_on_Message` ON `Message` (`storage_frame_work`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (347, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'CREATE TABLE `__temp_Message` (`message_id` INTEGER NOT NULL, `tox_friendpubkey` TEXT NOT NULL, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `state` INTEGER NOT NULL DEFAULT 1, `ft_accepted` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_started` BOOLEAN NOT NULL DEFAULT false, `filedb_id` INTEGER NOT NULL DEFAULT - 1, `filetransfer_id` INTEGER NOT NULL DEFAULT - 1, `sent_timestamp` INTEGER DEFAULT 0, `sent_timestamp_ms` INTEGER DEFAULT 0, `rcvd_timestamp` INTEGER DEFAULT 0, `rcvd_timestamp_ms` INTEGER DEFAULT 0, `read` BOOLEAN NOT NULL, `send_retries` INTEGER NOT NULL DEFAULT 0, `is_new` BOOLEAN NOT NULL, `text` TEXT, `filename_fullpath` TEXT, `msg_id_hash` TEXT, `raw_msgv2_bytes` TEXT, `msg_version` INTEGER NOT NULL DEFAULT 0, `resend_count` INTEGER NOT NULL DEFAULT 2, `storage_frame_work` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_queued` BOOLEAN NOT NULL DEFAULT false, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (348, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'INSERT INTO `__temp_Message` (`message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `send_retries`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `resend_count`, `storage_frame_work`, `id`) SELECT `message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `send_retries`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `resend_count`, `storage_frame_work`, `id` FROM `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (349, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'DROP TABLE `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (350, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'ALTER TABLE `__temp_Message` RENAME TO `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (351, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'CREATE INDEX `index_message_id_on_Message` ON `Message` (`message_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (352, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'CREATE INDEX `index_tox_friendpubkey_on_Message` ON `Message` (`tox_friendpubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (353, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'CREATE INDEX `index_direction_on_Message` ON `Message` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (354, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_Message` ON `Message` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (355, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_Message` ON `Message` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (356, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'CREATE INDEX `index_state_on_Message` ON `Message` (`state`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (357, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'CREATE INDEX `index_ft_accepted_on_Message` ON `Message` (`ft_accepted`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (358, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'CREATE INDEX `index_ft_outgoing_started_on_Message` ON `Message` (`ft_outgoing_started`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (359, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'CREATE INDEX `index_filedb_id_on_Message` ON `Message` (`filedb_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (360, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'CREATE INDEX `index_filetransfer_id_on_Message` ON `Message` (`filetransfer_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (361, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'CREATE INDEX `index_rcvd_timestamp_on_Message` ON `Message` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (362, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'CREATE INDEX `index_rcvd_timestamp_ms_on_Message` ON `Message` (`rcvd_timestamp_ms`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (363, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'CREATE INDEX `index_send_retries_on_Message` ON `Message` (`send_retries`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (364, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'CREATE INDEX `index_is_new_on_Message` ON `Message` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (365, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'CREATE INDEX `index_text_on_Message` ON `Message` (`text`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (366, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'CREATE INDEX `index_msg_id_hash_on_Message` ON `Message` (`msg_id_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (367, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'CREATE INDEX `index_raw_msgv2_bytes_on_Message` ON `Message` (`raw_msgv2_bytes`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (368, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'CREATE INDEX `index_msg_version_on_Message` ON `Message` (`msg_version`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (369, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'CREATE INDEX `index_resend_count_on_Message` ON `Message` (`resend_count`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (370, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'CREATE INDEX `index_storage_frame_work_on_Message` ON `Message` (`storage_frame_work`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (371, 201, '1.0.99', 10099, '5478686FE30F990B21587423E40B6D37987AC971AFBB0617A840CEAA5119A17D', 'CREATE INDEX `index_ft_outgoing_queued_on_Message` ON `Message` (`ft_outgoing_queued`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (372, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE TABLE `__temp_Message` (`message_id` INTEGER NOT NULL, `tox_friendpubkey` TEXT NOT NULL, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `state` INTEGER NOT NULL DEFAULT 1, `ft_accepted` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_started` BOOLEAN NOT NULL DEFAULT false, `filedb_id` INTEGER NOT NULL DEFAULT - 1, `filetransfer_id` INTEGER NOT NULL DEFAULT - 1, `sent_timestamp` INTEGER DEFAULT 0, `sent_timestamp_ms` INTEGER DEFAULT 0, `rcvd_timestamp` INTEGER DEFAULT 0, `rcvd_timestamp_ms` INTEGER DEFAULT 0, `read` BOOLEAN NOT NULL, `send_retries` INTEGER NOT NULL DEFAULT 0, `is_new` BOOLEAN NOT NULL, `text` TEXT, `filename_fullpath` TEXT, `msg_id_hash` TEXT, `raw_msgv2_bytes` TEXT, `msg_version` INTEGER NOT NULL DEFAULT 0, `resend_count` INTEGER NOT NULL DEFAULT 2, `storage_frame_work` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_queued` BOOLEAN NOT NULL DEFAULT false, `msg_at_relay` BOOLEAN NOT NULL DEFAULT false, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (373, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'INSERT INTO `__temp_Message` (`message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `send_retries`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `resend_count`, `storage_frame_work`, `ft_outgoing_queued`, `id`) SELECT `message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `send_retries`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `resend_count`, `storage_frame_work`, `ft_outgoing_queued`, `id` FROM `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (374, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'DROP TABLE `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (375, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'ALTER TABLE `__temp_Message` RENAME TO `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (376, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE INDEX `index_message_id_on_Message` ON `Message` (`message_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (377, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE INDEX `index_tox_friendpubkey_on_Message` ON `Message` (`tox_friendpubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (378, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE INDEX `index_direction_on_Message` ON `Message` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (379, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_Message` ON `Message` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (380, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_Message` ON `Message` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (381, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE INDEX `index_state_on_Message` ON `Message` (`state`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (382, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE INDEX `index_ft_accepted_on_Message` ON `Message` (`ft_accepted`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (383, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE INDEX `index_ft_outgoing_started_on_Message` ON `Message` (`ft_outgoing_started`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (384, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE INDEX `index_filedb_id_on_Message` ON `Message` (`filedb_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (385, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE INDEX `index_filetransfer_id_on_Message` ON `Message` (`filetransfer_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (386, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE INDEX `index_rcvd_timestamp_on_Message` ON `Message` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (387, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE INDEX `index_rcvd_timestamp_ms_on_Message` ON `Message` (`rcvd_timestamp_ms`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (388, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE INDEX `index_send_retries_on_Message` ON `Message` (`send_retries`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (389, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE INDEX `index_is_new_on_Message` ON `Message` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (390, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE INDEX `index_text_on_Message` ON `Message` (`text`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (391, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE INDEX `index_msg_id_hash_on_Message` ON `Message` (`msg_id_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (392, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE INDEX `index_raw_msgv2_bytes_on_Message` ON `Message` (`raw_msgv2_bytes`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (393, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE INDEX `index_msg_version_on_Message` ON `Message` (`msg_version`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (394, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE INDEX `index_resend_count_on_Message` ON `Message` (`resend_count`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (395, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE INDEX `index_storage_frame_work_on_Message` ON `Message` (`storage_frame_work`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (396, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE INDEX `index_ft_outgoing_queued_on_Message` ON `Message` (`ft_outgoing_queued`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (397, 226, '1.0.101', 10101, 'DCE6D3D87F52B6602A44B6B4BEEF00E19F69579AD07999093F144BC01D00BE5C', 'CREATE INDEX `index_msg_at_relay_on_Message` ON `Message` (`msg_at_relay`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (398, 244, '1.0.112', 10112, '8FAE173FBD922A834E158D4BDE574DD46D7A4674239C4CBCD7A053BC80180989', 'CREATE TABLE `__temp_FriendList` (`name` TEXT, `alias_name` TEXT, `status_message` TEXT, `TOX_CONNECTION` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_real` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off_real` INTEGER NOT NULL DEFAULT 0, `TOX_USER_STATUS` INTEGER NOT NULL DEFAULT 0, `avatar_pathname` TEXT, `avatar_filename` TEXT, `avatar_update` BOOLEAN DEFAULT false, `avatar_update_timestamp` INTEGER NOT NULL DEFAULT - 1, `notification_silent` BOOLEAN DEFAULT false, `sort` INTEGER NOT NULL DEFAULT 0, `last_online_timestamp` INTEGER NOT NULL DEFAULT - 1, `last_online_timestamp_real` INTEGER NOT NULL DEFAULT - 1, `added_timestamp` INTEGER NOT NULL DEFAULT - 1, `is_relay` BOOLEAN DEFAULT false, `push_url` TEXT, `tox_public_key_string` TEXT PRIMARY KEY)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (399, 244, '1.0.112', 10112, '8FAE173FBD922A834E158D4BDE574DD46D7A4674239C4CBCD7A053BC80180989', 'INSERT INTO `__temp_FriendList` (`name`, `alias_name`, `status_message`, `TOX_CONNECTION`, `TOX_CONNECTION_real`, `TOX_CONNECTION_on_off`, `TOX_CONNECTION_on_off_real`, `TOX_USER_STATUS`, `avatar_pathname`, `avatar_filename`, `avatar_update`, `avatar_update_timestamp`, `notification_silent`, `sort`, `last_online_timestamp`, `last_online_timestamp_real`, `added_timestamp`, `is_relay`, `tox_public_key_string`) SELECT `name`, `alias_name`, `status_message`, `TOX_CONNECTION`, `TOX_CONNECTION_real`, `TOX_CONNECTION_on_off`, `TOX_CONNECTION_on_off_real`, `TOX_USER_STATUS`, `avatar_pathname`, `avatar_filename`, `avatar_update`, `avatar_update_timestamp`, `notification_silent`, `sort`, `last_online_timestamp`, `last_online_timestamp_real`, `added_timestamp`, `is_relay`, `tox_public_key_string` FROM `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (400, 244, '1.0.112', 10112, '8FAE173FBD922A834E158D4BDE574DD46D7A4674239C4CBCD7A053BC80180989', 'DROP TABLE `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (401, 244, '1.0.112', 10112, '8FAE173FBD922A834E158D4BDE574DD46D7A4674239C4CBCD7A053BC80180989', 'ALTER TABLE `__temp_FriendList` RENAME TO `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (402, 244, '1.0.112', 10112, '8FAE173FBD922A834E158D4BDE574DD46D7A4674239C4CBCD7A053BC80180989', 'CREATE INDEX `index_alias_name_on_FriendList` ON `FriendList` (`alias_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (403, 244, '1.0.112', 10112, '8FAE173FBD922A834E158D4BDE574DD46D7A4674239C4CBCD7A053BC80180989', 'CREATE INDEX `index_TOX_CONNECTION_on_FriendList` ON `FriendList` (`TOX_CONNECTION`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (404, 244, '1.0.112', 10112, '8FAE173FBD922A834E158D4BDE574DD46D7A4674239C4CBCD7A053BC80180989', 'CREATE INDEX `index_TOX_CONNECTION_real_on_FriendList` ON `FriendList` (`TOX_CONNECTION_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (405, 244, '1.0.112', 10112, '8FAE173FBD922A834E158D4BDE574DD46D7A4674239C4CBCD7A053BC80180989', 'CREATE INDEX `index_TOX_CONNECTION_on_off_on_FriendList` ON `FriendList` (`TOX_CONNECTION_on_off`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (406, 244, '1.0.112', 10112, '8FAE173FBD922A834E158D4BDE574DD46D7A4674239C4CBCD7A053BC80180989', 'CREATE INDEX `index_TOX_CONNECTION_on_off_real_on_FriendList` ON `FriendList` (`TOX_CONNECTION_on_off_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (407, 244, '1.0.112', 10112, '8FAE173FBD922A834E158D4BDE574DD46D7A4674239C4CBCD7A053BC80180989', 'CREATE INDEX `index_TOX_USER_STATUS_on_FriendList` ON `FriendList` (`TOX_USER_STATUS`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (408, 244, '1.0.112', 10112, '8FAE173FBD922A834E158D4BDE574DD46D7A4674239C4CBCD7A053BC80180989', 'CREATE INDEX `index_avatar_update_on_FriendList` ON `FriendList` (`avatar_update`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (409, 244, '1.0.112', 10112, '8FAE173FBD922A834E158D4BDE574DD46D7A4674239C4CBCD7A053BC80180989', 'CREATE INDEX `index_avatar_update_timestamp_on_FriendList` ON `FriendList` (`avatar_update_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (410, 244, '1.0.112', 10112, '8FAE173FBD922A834E158D4BDE574DD46D7A4674239C4CBCD7A053BC80180989', 'CREATE INDEX `index_notification_silent_on_FriendList` ON `FriendList` (`notification_silent`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (411, 244, '1.0.112', 10112, '8FAE173FBD922A834E158D4BDE574DD46D7A4674239C4CBCD7A053BC80180989', 'CREATE INDEX `index_sort_on_FriendList` ON `FriendList` (`sort`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (412, 244, '1.0.112', 10112, '8FAE173FBD922A834E158D4BDE574DD46D7A4674239C4CBCD7A053BC80180989', 'CREATE INDEX `index_last_online_timestamp_on_FriendList` ON `FriendList` (`last_online_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (413, 244, '1.0.112', 10112, '8FAE173FBD922A834E158D4BDE574DD46D7A4674239C4CBCD7A053BC80180989', 'CREATE INDEX `index_last_online_timestamp_real_on_FriendList` ON `FriendList` (`last_online_timestamp_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (414, 244, '1.0.112', 10112, '8FAE173FBD922A834E158D4BDE574DD46D7A4674239C4CBCD7A053BC80180989', 'CREATE INDEX `index_added_timestamp_on_FriendList` ON `FriendList` (`added_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (415, 244, '1.0.112', 10112, '8FAE173FBD922A834E158D4BDE574DD46D7A4674239C4CBCD7A053BC80180989', 'CREATE INDEX `index_is_relay_on_FriendList` ON `FriendList` (`is_relay`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (416, 244, '1.0.112', 10112, '8FAE173FBD922A834E158D4BDE574DD46D7A4674239C4CBCD7A053BC80180989', 'CREATE INDEX `index_push_url_on_FriendList` ON `FriendList` (`push_url`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (417, 263, '1.0.124', 10124, 'FB2D72CFBDD01F0B18238FB8AE0421E870E36D074A7F58F50652B2D8F69EAEAE', 'CREATE TABLE `__temp_FriendList` (`name` TEXT, `alias_name` TEXT, `status_message` TEXT, `TOX_CONNECTION` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_real` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off_real` INTEGER NOT NULL DEFAULT 0, `TOX_USER_STATUS` INTEGER NOT NULL DEFAULT 0, `avatar_pathname` TEXT, `avatar_filename` TEXT, `avatar_update` BOOLEAN DEFAULT false, `avatar_update_timestamp` INTEGER NOT NULL DEFAULT - 1, `notification_silent` BOOLEAN DEFAULT false, `sort` INTEGER NOT NULL DEFAULT 0, `last_online_timestamp` INTEGER NOT NULL DEFAULT - 1, `last_online_timestamp_real` INTEGER NOT NULL DEFAULT - 1, `added_timestamp` INTEGER NOT NULL DEFAULT - 1, `is_relay` BOOLEAN DEFAULT false, `push_url` TEXT, `capabilities` INTEGER NOT NULL DEFAULT 0, `tox_public_key_string` TEXT PRIMARY KEY)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (418, 263, '1.0.124', 10124, 'FB2D72CFBDD01F0B18238FB8AE0421E870E36D074A7F58F50652B2D8F69EAEAE', 'INSERT INTO `__temp_FriendList` (`name`, `alias_name`, `status_message`, `TOX_CONNECTION`, `TOX_CONNECTION_real`, `TOX_CONNECTION_on_off`, `TOX_CONNECTION_on_off_real`, `TOX_USER_STATUS`, `avatar_pathname`, `avatar_filename`, `avatar_update`, `avatar_update_timestamp`, `notification_silent`, `sort`, `last_online_timestamp`, `last_online_timestamp_real`, `added_timestamp`, `is_relay`, `push_url`, `tox_public_key_string`) SELECT `name`, `alias_name`, `status_message`, `TOX_CONNECTION`, `TOX_CONNECTION_real`, `TOX_CONNECTION_on_off`, `TOX_CONNECTION_on_off_real`, `TOX_USER_STATUS`, `avatar_pathname`, `avatar_filename`, `avatar_update`, `avatar_update_timestamp`, `notification_silent`, `sort`, `last_online_timestamp`, `last_online_timestamp_real`, `added_timestamp`, `is_relay`, `push_url`, `tox_public_key_string` FROM `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (419, 263, '1.0.124', 10124, 'FB2D72CFBDD01F0B18238FB8AE0421E870E36D074A7F58F50652B2D8F69EAEAE', 'DROP TABLE `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (420, 263, '1.0.124', 10124, 'FB2D72CFBDD01F0B18238FB8AE0421E870E36D074A7F58F50652B2D8F69EAEAE', 'ALTER TABLE `__temp_FriendList` RENAME TO `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (421, 263, '1.0.124', 10124, 'FB2D72CFBDD01F0B18238FB8AE0421E870E36D074A7F58F50652B2D8F69EAEAE', 'CREATE INDEX `index_alias_name_on_FriendList` ON `FriendList` (`alias_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (422, 263, '1.0.124', 10124, 'FB2D72CFBDD01F0B18238FB8AE0421E870E36D074A7F58F50652B2D8F69EAEAE', 'CREATE INDEX `index_TOX_CONNECTION_on_FriendList` ON `FriendList` (`TOX_CONNECTION`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (423, 263, '1.0.124', 10124, 'FB2D72CFBDD01F0B18238FB8AE0421E870E36D074A7F58F50652B2D8F69EAEAE', 'CREATE INDEX `index_TOX_CONNECTION_real_on_FriendList` ON `FriendList` (`TOX_CONNECTION_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (424, 263, '1.0.124', 10124, 'FB2D72CFBDD01F0B18238FB8AE0421E870E36D074A7F58F50652B2D8F69EAEAE', 'CREATE INDEX `index_TOX_CONNECTION_on_off_on_FriendList` ON `FriendList` (`TOX_CONNECTION_on_off`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (425, 263, '1.0.124', 10124, 'FB2D72CFBDD01F0B18238FB8AE0421E870E36D074A7F58F50652B2D8F69EAEAE', 'CREATE INDEX `index_TOX_CONNECTION_on_off_real_on_FriendList` ON `FriendList` (`TOX_CONNECTION_on_off_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (426, 263, '1.0.124', 10124, 'FB2D72CFBDD01F0B18238FB8AE0421E870E36D074A7F58F50652B2D8F69EAEAE', 'CREATE INDEX `index_TOX_USER_STATUS_on_FriendList` ON `FriendList` (`TOX_USER_STATUS`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (427, 263, '1.0.124', 10124, 'FB2D72CFBDD01F0B18238FB8AE0421E870E36D074A7F58F50652B2D8F69EAEAE', 'CREATE INDEX `index_avatar_update_on_FriendList` ON `FriendList` (`avatar_update`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (428, 263, '1.0.124', 10124, 'FB2D72CFBDD01F0B18238FB8AE0421E870E36D074A7F58F50652B2D8F69EAEAE', 'CREATE INDEX `index_avatar_update_timestamp_on_FriendList` ON `FriendList` (`avatar_update_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (429, 263, '1.0.124', 10124, 'FB2D72CFBDD01F0B18238FB8AE0421E870E36D074A7F58F50652B2D8F69EAEAE', 'CREATE INDEX `index_notification_silent_on_FriendList` ON `FriendList` (`notification_silent`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (430, 263, '1.0.124', 10124, 'FB2D72CFBDD01F0B18238FB8AE0421E870E36D074A7F58F50652B2D8F69EAEAE', 'CREATE INDEX `index_sort_on_FriendList` ON `FriendList` (`sort`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (431, 263, '1.0.124', 10124, 'FB2D72CFBDD01F0B18238FB8AE0421E870E36D074A7F58F50652B2D8F69EAEAE', 'CREATE INDEX `index_last_online_timestamp_on_FriendList` ON `FriendList` (`last_online_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (432, 263, '1.0.124', 10124, 'FB2D72CFBDD01F0B18238FB8AE0421E870E36D074A7F58F50652B2D8F69EAEAE', 'CREATE INDEX `index_last_online_timestamp_real_on_FriendList` ON `FriendList` (`last_online_timestamp_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (433, 263, '1.0.124', 10124, 'FB2D72CFBDD01F0B18238FB8AE0421E870E36D074A7F58F50652B2D8F69EAEAE', 'CREATE INDEX `index_added_timestamp_on_FriendList` ON `FriendList` (`added_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (434, 263, '1.0.124', 10124, 'FB2D72CFBDD01F0B18238FB8AE0421E870E36D074A7F58F50652B2D8F69EAEAE', 'CREATE INDEX `index_is_relay_on_FriendList` ON `FriendList` (`is_relay`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (435, 263, '1.0.124', 10124, 'FB2D72CFBDD01F0B18238FB8AE0421E870E36D074A7F58F50652B2D8F69EAEAE', 'CREATE INDEX `index_push_url_on_FriendList` ON `FriendList` (`push_url`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (436, 263, '1.0.124', 10124, 'FB2D72CFBDD01F0B18238FB8AE0421E870E36D074A7F58F50652B2D8F69EAEAE', 'CREATE INDEX `index_capabilities_on_FriendList` ON `FriendList` (`capabilities`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (437, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE TABLE `__temp_Message` (`message_id` INTEGER NOT NULL, `tox_friendpubkey` TEXT NOT NULL, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `state` INTEGER NOT NULL DEFAULT 1, `ft_accepted` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_started` BOOLEAN NOT NULL DEFAULT false, `filedb_id` INTEGER NOT NULL DEFAULT - 1, `filetransfer_id` INTEGER NOT NULL DEFAULT - 1, `sent_timestamp` INTEGER DEFAULT 0, `sent_timestamp_ms` INTEGER DEFAULT 0, `rcvd_timestamp` INTEGER DEFAULT 0, `rcvd_timestamp_ms` INTEGER DEFAULT 0, `read` BOOLEAN NOT NULL, `send_retries` INTEGER NOT NULL DEFAULT 0, `is_new` BOOLEAN NOT NULL, `text` TEXT, `filename_fullpath` TEXT, `msg_id_hash` TEXT, `raw_msgv2_bytes` TEXT, `msg_version` INTEGER NOT NULL DEFAULT 0, `resend_count` INTEGER NOT NULL DEFAULT 2, `storage_frame_work` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_queued` BOOLEAN NOT NULL DEFAULT false, `msg_at_relay` BOOLEAN NOT NULL DEFAULT false, `msg_idv3_hash` TEXT, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (438, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'INSERT INTO `__temp_Message` (`message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `send_retries`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `resend_count`, `storage_frame_work`, `ft_outgoing_queued`, `msg_at_relay`, `id`) SELECT `message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `send_retries`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `resend_count`, `storage_frame_work`, `ft_outgoing_queued`, `msg_at_relay`, `id` FROM `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (439, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'DROP TABLE `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (440, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'ALTER TABLE `__temp_Message` RENAME TO `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (441, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_message_id_on_Message` ON `Message` (`message_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (442, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_tox_friendpubkey_on_Message` ON `Message` (`tox_friendpubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (443, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_direction_on_Message` ON `Message` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (444, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_Message` ON `Message` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (445, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_Message` ON `Message` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (446, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_state_on_Message` ON `Message` (`state`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (447, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_ft_accepted_on_Message` ON `Message` (`ft_accepted`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (448, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_ft_outgoing_started_on_Message` ON `Message` (`ft_outgoing_started`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (449, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_filedb_id_on_Message` ON `Message` (`filedb_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (450, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_filetransfer_id_on_Message` ON `Message` (`filetransfer_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (451, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_rcvd_timestamp_on_Message` ON `Message` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (452, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_rcvd_timestamp_ms_on_Message` ON `Message` (`rcvd_timestamp_ms`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (453, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_send_retries_on_Message` ON `Message` (`send_retries`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (454, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_is_new_on_Message` ON `Message` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (455, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_text_on_Message` ON `Message` (`text`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (456, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_msg_id_hash_on_Message` ON `Message` (`msg_id_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (457, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_raw_msgv2_bytes_on_Message` ON `Message` (`raw_msgv2_bytes`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (458, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_msg_version_on_Message` ON `Message` (`msg_version`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (459, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_resend_count_on_Message` ON `Message` (`resend_count`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (460, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_storage_frame_work_on_Message` ON `Message` (`storage_frame_work`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (461, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_ft_outgoing_queued_on_Message` ON `Message` (`ft_outgoing_queued`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (462, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_msg_at_relay_on_Message` ON `Message` (`msg_at_relay`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (463, 289, '1.0.124', 10124, '89E677F6829A76FDBC57D5AFC13FFFD9EDBA43B45C8C6BD9FE2BE50989BD3EC1', 'CREATE INDEX `index_msg_idv3_hash_on_Message` ON `Message` (`msg_idv3_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (464, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE TABLE `__temp_Message` (`message_id` INTEGER NOT NULL, `tox_friendpubkey` TEXT NOT NULL, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `state` INTEGER NOT NULL DEFAULT 1, `ft_accepted` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_started` BOOLEAN NOT NULL DEFAULT false, `filedb_id` INTEGER NOT NULL DEFAULT - 1, `filetransfer_id` INTEGER NOT NULL DEFAULT - 1, `sent_timestamp` INTEGER DEFAULT 0, `sent_timestamp_ms` INTEGER DEFAULT 0, `rcvd_timestamp` INTEGER DEFAULT 0, `rcvd_timestamp_ms` INTEGER DEFAULT 0, `read` BOOLEAN NOT NULL, `send_retries` INTEGER NOT NULL DEFAULT 0, `is_new` BOOLEAN NOT NULL, `text` TEXT, `filename_fullpath` TEXT, `msg_id_hash` TEXT, `raw_msgv2_bytes` TEXT, `msg_version` INTEGER NOT NULL DEFAULT 0, `resend_count` INTEGER NOT NULL DEFAULT 2, `storage_frame_work` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_queued` BOOLEAN NOT NULL DEFAULT false, `msg_at_relay` BOOLEAN NOT NULL DEFAULT false, `msg_idv3_hash` TEXT, `sent_push` BOOLEAN, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (465, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'INSERT INTO `__temp_Message` (`message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `send_retries`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `resend_count`, `storage_frame_work`, `ft_outgoing_queued`, `msg_at_relay`, `msg_idv3_hash`, `id`) SELECT `message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `send_retries`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `resend_count`, `storage_frame_work`, `ft_outgoing_queued`, `msg_at_relay`, `msg_idv3_hash`, `id` FROM `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (466, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'DROP TABLE `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (467, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'ALTER TABLE `__temp_Message` RENAME TO `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (468, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_message_id_on_Message` ON `Message` (`message_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (469, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_tox_friendpubkey_on_Message` ON `Message` (`tox_friendpubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (470, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_direction_on_Message` ON `Message` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (471, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_Message` ON `Message` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (472, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_Message` ON `Message` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (473, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_state_on_Message` ON `Message` (`state`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (474, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_ft_accepted_on_Message` ON `Message` (`ft_accepted`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (475, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_ft_outgoing_started_on_Message` ON `Message` (`ft_outgoing_started`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (476, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_filedb_id_on_Message` ON `Message` (`filedb_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (477, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_filetransfer_id_on_Message` ON `Message` (`filetransfer_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (478, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_rcvd_timestamp_on_Message` ON `Message` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (479, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_rcvd_timestamp_ms_on_Message` ON `Message` (`rcvd_timestamp_ms`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (480, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_send_retries_on_Message` ON `Message` (`send_retries`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (481, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_is_new_on_Message` ON `Message` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (482, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_text_on_Message` ON `Message` (`text`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (483, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_msg_id_hash_on_Message` ON `Message` (`msg_id_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (484, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_raw_msgv2_bytes_on_Message` ON `Message` (`raw_msgv2_bytes`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (485, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_msg_version_on_Message` ON `Message` (`msg_version`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (486, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_resend_count_on_Message` ON `Message` (`resend_count`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (487, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_storage_frame_work_on_Message` ON `Message` (`storage_frame_work`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (488, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_ft_outgoing_queued_on_Message` ON `Message` (`ft_outgoing_queued`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (489, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_msg_at_relay_on_Message` ON `Message` (`msg_at_relay`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (490, 315, '1.0.124', 10124, '3A774FD5F0D947F64BEEB39F36EBC9DBE666E1AA916592281A8A631CCC3E2CAA', 'CREATE INDEX `index_msg_idv3_hash_on_Message` ON `Message` (`msg_idv3_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (491, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE TABLE `__temp_Message` (`message_id` INTEGER NOT NULL, `tox_friendpubkey` TEXT NOT NULL, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `state` INTEGER NOT NULL DEFAULT 1, `ft_accepted` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_started` BOOLEAN NOT NULL DEFAULT false, `filedb_id` INTEGER NOT NULL DEFAULT - 1, `filetransfer_id` INTEGER NOT NULL DEFAULT - 1, `sent_timestamp` INTEGER DEFAULT 0, `sent_timestamp_ms` INTEGER DEFAULT 0, `rcvd_timestamp` INTEGER DEFAULT 0, `rcvd_timestamp_ms` INTEGER DEFAULT 0, `read` BOOLEAN NOT NULL, `send_retries` INTEGER NOT NULL DEFAULT 0, `is_new` BOOLEAN NOT NULL, `text` TEXT, `filename_fullpath` TEXT, `msg_id_hash` TEXT, `raw_msgv2_bytes` TEXT, `msg_version` INTEGER NOT NULL DEFAULT 0, `resend_count` INTEGER NOT NULL DEFAULT 2, `storage_frame_work` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_queued` BOOLEAN NOT NULL DEFAULT false, `msg_at_relay` BOOLEAN NOT NULL DEFAULT false, `msg_idv3_hash` TEXT, `sent_push` INTEGER, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (492, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'INSERT INTO `__temp_Message` (`message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `send_retries`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `resend_count`, `storage_frame_work`, `ft_outgoing_queued`, `msg_at_relay`, `msg_idv3_hash`, `sent_push`, `id`) SELECT `message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `send_retries`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `resend_count`, `storage_frame_work`, `ft_outgoing_queued`, `msg_at_relay`, `msg_idv3_hash`, `sent_push`, `id` FROM `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (493, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'DROP TABLE `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (494, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'ALTER TABLE `__temp_Message` RENAME TO `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (495, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_message_id_on_Message` ON `Message` (`message_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (496, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_tox_friendpubkey_on_Message` ON `Message` (`tox_friendpubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (497, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_direction_on_Message` ON `Message` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (498, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_Message` ON `Message` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (499, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_Message` ON `Message` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (500, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_state_on_Message` ON `Message` (`state`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (501, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_ft_accepted_on_Message` ON `Message` (`ft_accepted`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (502, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_ft_outgoing_started_on_Message` ON `Message` (`ft_outgoing_started`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (503, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_filedb_id_on_Message` ON `Message` (`filedb_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (504, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_filetransfer_id_on_Message` ON `Message` (`filetransfer_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (505, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_rcvd_timestamp_on_Message` ON `Message` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (506, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_rcvd_timestamp_ms_on_Message` ON `Message` (`rcvd_timestamp_ms`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (507, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_send_retries_on_Message` ON `Message` (`send_retries`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (508, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_is_new_on_Message` ON `Message` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (509, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_text_on_Message` ON `Message` (`text`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (510, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_msg_id_hash_on_Message` ON `Message` (`msg_id_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (511, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_raw_msgv2_bytes_on_Message` ON `Message` (`raw_msgv2_bytes`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (512, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_msg_version_on_Message` ON `Message` (`msg_version`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (513, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_resend_count_on_Message` ON `Message` (`resend_count`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (514, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_storage_frame_work_on_Message` ON `Message` (`storage_frame_work`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (515, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_ft_outgoing_queued_on_Message` ON `Message` (`ft_outgoing_queued`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (516, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_msg_at_relay_on_Message` ON `Message` (`msg_at_relay`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (517, 341, '1.0.124', 10124, '42180F2715799AB5CF7E7AFA4EF714D601226416C1F48DAD917B686EC1DF3A61', 'CREATE INDEX `index_msg_idv3_hash_on_Message` ON `Message` (`msg_idv3_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (518, 361, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE TABLE `__temp_FriendList` (`name` TEXT, `alias_name` TEXT, `status_message` TEXT, `TOX_CONNECTION` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_real` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off_real` INTEGER NOT NULL DEFAULT 0, `TOX_USER_STATUS` INTEGER NOT NULL DEFAULT 0, `avatar_pathname` TEXT, `avatar_filename` TEXT, `avatar_update` BOOLEAN DEFAULT false, `avatar_update_timestamp` INTEGER NOT NULL DEFAULT - 1, `notification_silent` BOOLEAN DEFAULT false, `sort` INTEGER NOT NULL DEFAULT 0, `last_online_timestamp` INTEGER NOT NULL DEFAULT - 1, `last_online_timestamp_real` INTEGER NOT NULL DEFAULT - 1, `added_timestamp` INTEGER NOT NULL DEFAULT - 1, `is_relay` BOOLEAN DEFAULT false, `push_url` TEXT, `capabilities` INTEGER NOT NULL DEFAULT 0, `msgv3_capability` INTEGER NOT NULL DEFAULT 0, `tox_public_key_string` TEXT PRIMARY KEY)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (519, 361, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'INSERT INTO `__temp_FriendList` (`name`, `alias_name`, `status_message`, `TOX_CONNECTION`, `TOX_CONNECTION_real`, `TOX_CONNECTION_on_off`, `TOX_CONNECTION_on_off_real`, `TOX_USER_STATUS`, `avatar_pathname`, `avatar_filename`, `avatar_update`, `avatar_update_timestamp`, `notification_silent`, `sort`, `last_online_timestamp`, `last_online_timestamp_real`, `added_timestamp`, `is_relay`, `push_url`, `capabilities`, `tox_public_key_string`) SELECT `name`, `alias_name`, `status_message`, `TOX_CONNECTION`, `TOX_CONNECTION_real`, `TOX_CONNECTION_on_off`, `TOX_CONNECTION_on_off_real`, `TOX_USER_STATUS`, `avatar_pathname`, `avatar_filename`, `avatar_update`, `avatar_update_timestamp`, `notification_silent`, `sort`, `last_online_timestamp`, `last_online_timestamp_real`, `added_timestamp`, `is_relay`, `push_url`, `capabilities`, `tox_public_key_string` FROM `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (520, 361, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'DROP TABLE `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (521, 361, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'ALTER TABLE `__temp_FriendList` RENAME TO `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (522, 361, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_alias_name_on_FriendList` ON `FriendList` (`alias_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (523, 361, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_TOX_CONNECTION_on_FriendList` ON `FriendList` (`TOX_CONNECTION`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (524, 361, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_TOX_CONNECTION_real_on_FriendList` ON `FriendList` (`TOX_CONNECTION_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (525, 361, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_TOX_CONNECTION_on_off_on_FriendList` ON `FriendList` (`TOX_CONNECTION_on_off`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (526, 361, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_TOX_CONNECTION_on_off_real_on_FriendList` ON `FriendList` (`TOX_CONNECTION_on_off_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (527, 361, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_TOX_USER_STATUS_on_FriendList` ON `FriendList` (`TOX_USER_STATUS`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (528, 361, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_avatar_update_on_FriendList` ON `FriendList` (`avatar_update`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (529, 361, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_avatar_update_timestamp_on_FriendList` ON `FriendList` (`avatar_update_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (530, 361, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_notification_silent_on_FriendList` ON `FriendList` (`notification_silent`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (531, 361, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_sort_on_FriendList` ON `FriendList` (`sort`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (532, 361, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_last_online_timestamp_on_FriendList` ON `FriendList` (`last_online_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (533, 361, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_last_online_timestamp_real_on_FriendList` ON `FriendList` (`last_online_timestamp_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (534, 361, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_added_timestamp_on_FriendList` ON `FriendList` (`added_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (535, 361, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_is_relay_on_FriendList` ON `FriendList` (`is_relay`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (536, 361, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_push_url_on_FriendList` ON `FriendList` (`push_url`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (537, 361, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_capabilities_on_FriendList` ON `FriendList` (`capabilities`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (538, 361, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_msgv3_capability_on_FriendList` ON `FriendList` (`msgv3_capability`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (539, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE TABLE `__temp_Message` (`message_id` INTEGER NOT NULL, `tox_friendpubkey` TEXT NOT NULL, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `state` INTEGER NOT NULL DEFAULT 1, `ft_accepted` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_started` BOOLEAN NOT NULL DEFAULT false, `filedb_id` INTEGER NOT NULL DEFAULT - 1, `filetransfer_id` INTEGER NOT NULL DEFAULT - 1, `sent_timestamp` INTEGER DEFAULT 0, `sent_timestamp_ms` INTEGER DEFAULT 0, `rcvd_timestamp` INTEGER DEFAULT 0, `rcvd_timestamp_ms` INTEGER DEFAULT 0, `read` BOOLEAN NOT NULL, `send_retries` INTEGER NOT NULL DEFAULT 0, `is_new` BOOLEAN NOT NULL, `text` TEXT, `filename_fullpath` TEXT, `msg_id_hash` TEXT, `raw_msgv2_bytes` TEXT, `msg_version` INTEGER NOT NULL DEFAULT 0, `resend_count` INTEGER NOT NULL DEFAULT 5, `storage_frame_work` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_queued` BOOLEAN NOT NULL DEFAULT false, `msg_at_relay` BOOLEAN NOT NULL DEFAULT false, `msg_idv3_hash` TEXT, `sent_push` INTEGER, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (540, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'INSERT INTO `__temp_Message` (`message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `send_retries`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `resend_count`, `storage_frame_work`, `ft_outgoing_queued`, `msg_at_relay`, `msg_idv3_hash`, `sent_push`, `id`) SELECT `message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `send_retries`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `resend_count`, `storage_frame_work`, `ft_outgoing_queued`, `msg_at_relay`, `msg_idv3_hash`, `sent_push`, `id` FROM `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (541, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'DROP TABLE `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (542, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'ALTER TABLE `__temp_Message` RENAME TO `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (543, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_message_id_on_Message` ON `Message` (`message_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (544, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_tox_friendpubkey_on_Message` ON `Message` (`tox_friendpubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (545, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_direction_on_Message` ON `Message` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (546, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_Message` ON `Message` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (547, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_Message` ON `Message` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (548, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_state_on_Message` ON `Message` (`state`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (549, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_ft_accepted_on_Message` ON `Message` (`ft_accepted`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (550, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_ft_outgoing_started_on_Message` ON `Message` (`ft_outgoing_started`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (551, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_filedb_id_on_Message` ON `Message` (`filedb_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (552, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_filetransfer_id_on_Message` ON `Message` (`filetransfer_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (553, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_rcvd_timestamp_on_Message` ON `Message` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (554, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_rcvd_timestamp_ms_on_Message` ON `Message` (`rcvd_timestamp_ms`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (555, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_send_retries_on_Message` ON `Message` (`send_retries`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (556, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_is_new_on_Message` ON `Message` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (557, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_text_on_Message` ON `Message` (`text`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (558, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_msg_id_hash_on_Message` ON `Message` (`msg_id_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (559, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_raw_msgv2_bytes_on_Message` ON `Message` (`raw_msgv2_bytes`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (560, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_msg_version_on_Message` ON `Message` (`msg_version`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (561, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_resend_count_on_Message` ON `Message` (`resend_count`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (562, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_storage_frame_work_on_Message` ON `Message` (`storage_frame_work`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (563, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_ft_outgoing_queued_on_Message` ON `Message` (`ft_outgoing_queued`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (564, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_msg_at_relay_on_Message` ON `Message` (`msg_at_relay`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (565, 387, '1.0.124', 10124, '28F97CBBB34933883AC9DD565FCFEB516B7D126E343F018DFBCC8D791E01C59F', 'CREATE INDEX `index_msg_idv3_hash_on_Message` ON `Message` (`msg_idv3_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (566, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE TABLE `__temp_Message` (`message_id` INTEGER NOT NULL, `tox_friendpubkey` TEXT NOT NULL, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `state` INTEGER NOT NULL DEFAULT 1, `ft_accepted` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_started` BOOLEAN NOT NULL DEFAULT false, `filedb_id` INTEGER NOT NULL DEFAULT - 1, `filetransfer_id` INTEGER NOT NULL DEFAULT - 1, `sent_timestamp` INTEGER DEFAULT 0, `sent_timestamp_ms` INTEGER DEFAULT 0, `rcvd_timestamp` INTEGER DEFAULT 0, `rcvd_timestamp_ms` INTEGER DEFAULT 0, `read` BOOLEAN NOT NULL, `send_retries` INTEGER NOT NULL DEFAULT 0, `is_new` BOOLEAN NOT NULL, `text` TEXT, `filename_fullpath` TEXT, `msg_id_hash` TEXT, `raw_msgv2_bytes` TEXT, `msg_version` INTEGER NOT NULL DEFAULT 0, `resend_count` INTEGER NOT NULL DEFAULT 2, `storage_frame_work` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_queued` BOOLEAN NOT NULL DEFAULT false, `msg_at_relay` BOOLEAN NOT NULL DEFAULT false, `msg_idv3_hash` TEXT, `sent_push` INTEGER, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (567, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'INSERT INTO `__temp_Message` (`message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `send_retries`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `resend_count`, `storage_frame_work`, `ft_outgoing_queued`, `msg_at_relay`, `msg_idv3_hash`, `sent_push`, `id`) SELECT `message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `send_retries`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `resend_count`, `storage_frame_work`, `ft_outgoing_queued`, `msg_at_relay`, `msg_idv3_hash`, `sent_push`, `id` FROM `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (568, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'DROP TABLE `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (569, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'ALTER TABLE `__temp_Message` RENAME TO `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (570, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_message_id_on_Message` ON `Message` (`message_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (571, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_tox_friendpubkey_on_Message` ON `Message` (`tox_friendpubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (572, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_direction_on_Message` ON `Message` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (573, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_Message` ON `Message` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (574, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_Message` ON `Message` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (575, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_state_on_Message` ON `Message` (`state`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (576, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_ft_accepted_on_Message` ON `Message` (`ft_accepted`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (577, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_ft_outgoing_started_on_Message` ON `Message` (`ft_outgoing_started`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (578, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_filedb_id_on_Message` ON `Message` (`filedb_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (579, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_filetransfer_id_on_Message` ON `Message` (`filetransfer_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (580, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_rcvd_timestamp_on_Message` ON `Message` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (581, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_rcvd_timestamp_ms_on_Message` ON `Message` (`rcvd_timestamp_ms`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (582, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_send_retries_on_Message` ON `Message` (`send_retries`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (583, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_is_new_on_Message` ON `Message` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (584, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_text_on_Message` ON `Message` (`text`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (585, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_msg_id_hash_on_Message` ON `Message` (`msg_id_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (586, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_raw_msgv2_bytes_on_Message` ON `Message` (`raw_msgv2_bytes`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (587, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_msg_version_on_Message` ON `Message` (`msg_version`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (588, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_resend_count_on_Message` ON `Message` (`resend_count`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (589, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_storage_frame_work_on_Message` ON `Message` (`storage_frame_work`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (590, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_ft_outgoing_queued_on_Message` ON `Message` (`ft_outgoing_queued`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (591, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_msg_at_relay_on_Message` ON `Message` (`msg_at_relay`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (592, 413, '1.0.124', 10124, '11B463BE79753317799B6365FE659670BD89DC7113357B4330195038EB7EF8BE', 'CREATE INDEX `index_msg_idv3_hash_on_Message` ON `Message` (`msg_idv3_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (593, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE TABLE `__temp_Message` (`message_id` INTEGER NOT NULL, `tox_friendpubkey` TEXT NOT NULL, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `state` INTEGER NOT NULL DEFAULT 1, `ft_accepted` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_started` BOOLEAN NOT NULL DEFAULT false, `filedb_id` INTEGER NOT NULL DEFAULT - 1, `filetransfer_id` INTEGER NOT NULL DEFAULT - 1, `sent_timestamp` INTEGER DEFAULT 0, `sent_timestamp_ms` INTEGER DEFAULT 0, `rcvd_timestamp` INTEGER DEFAULT 0, `rcvd_timestamp_ms` INTEGER DEFAULT 0, `read` BOOLEAN NOT NULL, `send_retries` INTEGER NOT NULL DEFAULT 0, `is_new` BOOLEAN NOT NULL, `text` TEXT, `filename_fullpath` TEXT, `msg_id_hash` TEXT, `raw_msgv2_bytes` TEXT, `msg_version` INTEGER NOT NULL DEFAULT 0, `resend_count` INTEGER NOT NULL DEFAULT 4, `storage_frame_work` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_queued` BOOLEAN NOT NULL DEFAULT false, `msg_at_relay` BOOLEAN NOT NULL DEFAULT false, `msg_idv3_hash` TEXT, `sent_push` INTEGER, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (594, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'INSERT INTO `__temp_Message` (`message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `send_retries`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `resend_count`, `storage_frame_work`, `ft_outgoing_queued`, `msg_at_relay`, `msg_idv3_hash`, `sent_push`, `id`) SELECT `message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `send_retries`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `resend_count`, `storage_frame_work`, `ft_outgoing_queued`, `msg_at_relay`, `msg_idv3_hash`, `sent_push`, `id` FROM `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (595, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'DROP TABLE `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (596, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'ALTER TABLE `__temp_Message` RENAME TO `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (597, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_message_id_on_Message` ON `Message` (`message_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (598, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_tox_friendpubkey_on_Message` ON `Message` (`tox_friendpubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (599, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_direction_on_Message` ON `Message` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (600, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_Message` ON `Message` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (601, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_Message` ON `Message` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (602, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_state_on_Message` ON `Message` (`state`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (603, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_ft_accepted_on_Message` ON `Message` (`ft_accepted`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (604, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_ft_outgoing_started_on_Message` ON `Message` (`ft_outgoing_started`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (605, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_filedb_id_on_Message` ON `Message` (`filedb_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (606, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_filetransfer_id_on_Message` ON `Message` (`filetransfer_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (607, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_rcvd_timestamp_on_Message` ON `Message` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (608, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_rcvd_timestamp_ms_on_Message` ON `Message` (`rcvd_timestamp_ms`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (609, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_send_retries_on_Message` ON `Message` (`send_retries`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (610, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_is_new_on_Message` ON `Message` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (611, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_text_on_Message` ON `Message` (`text`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (612, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_msg_id_hash_on_Message` ON `Message` (`msg_id_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (613, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_raw_msgv2_bytes_on_Message` ON `Message` (`raw_msgv2_bytes`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (614, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_msg_version_on_Message` ON `Message` (`msg_version`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (615, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_resend_count_on_Message` ON `Message` (`resend_count`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (616, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_storage_frame_work_on_Message` ON `Message` (`storage_frame_work`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (617, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_ft_outgoing_queued_on_Message` ON `Message` (`ft_outgoing_queued`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (618, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_msg_at_relay_on_Message` ON `Message` (`msg_at_relay`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (619, 439, '1.0.127', 10127, '9671E4E5EAC7D5A8FA6DEAAA5EF08D6709B9EA53BFF4F00010DDA448698D9C13', 'CREATE INDEX `index_msg_idv3_hash_on_Message` ON `Message` (`msg_idv3_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (620, 458, '1.0.154', 10154, 'B79B57D3C3A22323A487CF298A79DE8DAF1FA6911A61F3D51581E51C549DE1B3', 'CREATE TABLE `GroupDB` (`who_invited__tox_public_key_string` TEXT NOT NULL, `name` TEXT , `peer_count` INTEGER NOT NULL DEFAULT -1, `own_peer_number` INTEGER NOT NULL DEFAULT -1, `privacy_state` INTEGER NOT NULL DEFAULT 0, `tox_group_number` INTEGER NOT NULL DEFAULT -1, `notification_silent` BOOLEAN DEFAULT false, `group_identifier` TEXT PRIMARY KEY)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (621, 458, '1.0.154', 10154, 'B79B57D3C3A22323A487CF298A79DE8DAF1FA6911A61F3D51581E51C549DE1B3', 'CREATE INDEX `index_who_invited__tox_public_key_string_on_GroupDB` ON `GroupDB` (`who_invited__tox_public_key_string`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (622, 458, '1.0.154', 10154, 'B79B57D3C3A22323A487CF298A79DE8DAF1FA6911A61F3D51581E51C549DE1B3', 'CREATE INDEX `index_name_on_GroupDB` ON `GroupDB` (`name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (623, 458, '1.0.154', 10154, 'B79B57D3C3A22323A487CF298A79DE8DAF1FA6911A61F3D51581E51C549DE1B3', 'CREATE INDEX `index_peer_count_on_GroupDB` ON `GroupDB` (`peer_count`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (624, 458, '1.0.154', 10154, 'B79B57D3C3A22323A487CF298A79DE8DAF1FA6911A61F3D51581E51C549DE1B3', 'CREATE INDEX `index_own_peer_number_on_GroupDB` ON `GroupDB` (`own_peer_number`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (625, 458, '1.0.154', 10154, 'B79B57D3C3A22323A487CF298A79DE8DAF1FA6911A61F3D51581E51C549DE1B3', 'CREATE INDEX `index_privacy_state_on_GroupDB` ON `GroupDB` (`privacy_state`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (626, 458, '1.0.154', 10154, 'B79B57D3C3A22323A487CF298A79DE8DAF1FA6911A61F3D51581E51C549DE1B3', 'CREATE INDEX `index_tox_group_number_on_GroupDB` ON `GroupDB` (`tox_group_number`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (627, 458, '1.0.154', 10154, 'B79B57D3C3A22323A487CF298A79DE8DAF1FA6911A61F3D51581E51C549DE1B3', 'CREATE INDEX `index_notification_silent_on_GroupDB` ON `GroupDB` (`notification_silent`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (628, 458, '1.0.154', 10154, 'B79B57D3C3A22323A487CF298A79DE8DAF1FA6911A61F3D51581E51C549DE1B3', 'CREATE TABLE `GroupMessage` (`message_id_tox` TEXT , `group_identifier` TEXT NOT NULL DEFAULT -1, `tox_group_peer_pubkey` TEXT NOT NULL, `tox_group_peername` TEXT , `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `sent_timestamp` INTEGER , `rcvd_timestamp` INTEGER , `read` BOOLEAN NOT NULL, `is_new` BOOLEAN NOT NULL, `text` TEXT , `was_synced` BOOLEAN , `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (629, 458, '1.0.154', 10154, 'B79B57D3C3A22323A487CF298A79DE8DAF1FA6911A61F3D51581E51C549DE1B3', 'CREATE INDEX `index_message_id_tox_on_GroupMessage` ON `GroupMessage` (`message_id_tox`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (630, 458, '1.0.154', 10154, 'B79B57D3C3A22323A487CF298A79DE8DAF1FA6911A61F3D51581E51C549DE1B3', 'CREATE INDEX `index_group_identifier_on_GroupMessage` ON `GroupMessage` (`group_identifier`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (631, 458, '1.0.154', 10154, 'B79B57D3C3A22323A487CF298A79DE8DAF1FA6911A61F3D51581E51C549DE1B3', 'CREATE INDEX `index_tox_group_peer_pubkey_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (632, 458, '1.0.154', 10154, 'B79B57D3C3A22323A487CF298A79DE8DAF1FA6911A61F3D51581E51C549DE1B3', 'CREATE INDEX `index_tox_group_peername_on_GroupMessage` ON `GroupMessage` (`tox_group_peername`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (633, 458, '1.0.154', 10154, 'B79B57D3C3A22323A487CF298A79DE8DAF1FA6911A61F3D51581E51C549DE1B3', 'CREATE INDEX `index_direction_on_GroupMessage` ON `GroupMessage` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (634, 458, '1.0.154', 10154, 'B79B57D3C3A22323A487CF298A79DE8DAF1FA6911A61F3D51581E51C549DE1B3', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_GroupMessage` ON `GroupMessage` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (635, 458, '1.0.154', 10154, 'B79B57D3C3A22323A487CF298A79DE8DAF1FA6911A61F3D51581E51C549DE1B3', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_GroupMessage` ON `GroupMessage` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (636, 458, '1.0.154', 10154, 'B79B57D3C3A22323A487CF298A79DE8DAF1FA6911A61F3D51581E51C549DE1B3', 'CREATE INDEX `index_rcvd_timestamp_on_GroupMessage` ON `GroupMessage` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (637, 458, '1.0.154', 10154, 'B79B57D3C3A22323A487CF298A79DE8DAF1FA6911A61F3D51581E51C549DE1B3', 'CREATE INDEX `index_is_new_on_GroupMessage` ON `GroupMessage` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (638, 458, '1.0.154', 10154, 'B79B57D3C3A22323A487CF298A79DE8DAF1FA6911A61F3D51581E51C549DE1B3', 'CREATE INDEX `index_was_synced_on_GroupMessage` ON `GroupMessage` (`was_synced`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (639, 469, '1.0.154', 10154, 'F0D13AE37502F237921D996B7FE33EFD6D54C660C704C39D63AD9CE90DB68720', 'CREATE TABLE `__temp_GroupDB` (`who_invited__tox_public_key_string` TEXT NOT NULL, `name` TEXT, `peer_count` INTEGER NOT NULL DEFAULT - 1, `own_peer_number` INTEGER NOT NULL DEFAULT - 1, `privacy_state` INTEGER NOT NULL DEFAULT 0, `tox_group_number` INTEGER NOT NULL DEFAULT - 1, `group_active` BOOLEAN NOT NULL DEFAULT false, `notification_silent` BOOLEAN DEFAULT false, `group_identifier` TEXT PRIMARY KEY)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (640, 469, '1.0.154', 10154, 'F0D13AE37502F237921D996B7FE33EFD6D54C660C704C39D63AD9CE90DB68720', 'INSERT INTO `__temp_GroupDB` (`who_invited__tox_public_key_string`, `name`, `peer_count`, `own_peer_number`, `privacy_state`, `tox_group_number`, `notification_silent`, `group_identifier`) SELECT `who_invited__tox_public_key_string`, `name`, `peer_count`, `own_peer_number`, `privacy_state`, `tox_group_number`, `notification_silent`, `group_identifier` FROM `GroupDB`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (641, 469, '1.0.154', 10154, 'F0D13AE37502F237921D996B7FE33EFD6D54C660C704C39D63AD9CE90DB68720', 'DROP TABLE `GroupDB`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (642, 469, '1.0.154', 10154, 'F0D13AE37502F237921D996B7FE33EFD6D54C660C704C39D63AD9CE90DB68720', 'ALTER TABLE `__temp_GroupDB` RENAME TO `GroupDB`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (643, 469, '1.0.154', 10154, 'F0D13AE37502F237921D996B7FE33EFD6D54C660C704C39D63AD9CE90DB68720', 'CREATE INDEX `index_who_invited__tox_public_key_string_on_GroupDB` ON `GroupDB` (`who_invited__tox_public_key_string`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (644, 469, '1.0.154', 10154, 'F0D13AE37502F237921D996B7FE33EFD6D54C660C704C39D63AD9CE90DB68720', 'CREATE INDEX `index_name_on_GroupDB` ON `GroupDB` (`name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (645, 469, '1.0.154', 10154, 'F0D13AE37502F237921D996B7FE33EFD6D54C660C704C39D63AD9CE90DB68720', 'CREATE INDEX `index_peer_count_on_GroupDB` ON `GroupDB` (`peer_count`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (646, 469, '1.0.154', 10154, 'F0D13AE37502F237921D996B7FE33EFD6D54C660C704C39D63AD9CE90DB68720', 'CREATE INDEX `index_own_peer_number_on_GroupDB` ON `GroupDB` (`own_peer_number`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (647, 469, '1.0.154', 10154, 'F0D13AE37502F237921D996B7FE33EFD6D54C660C704C39D63AD9CE90DB68720', 'CREATE INDEX `index_privacy_state_on_GroupDB` ON `GroupDB` (`privacy_state`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (648, 469, '1.0.154', 10154, 'F0D13AE37502F237921D996B7FE33EFD6D54C660C704C39D63AD9CE90DB68720', 'CREATE INDEX `index_tox_group_number_on_GroupDB` ON `GroupDB` (`tox_group_number`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (649, 469, '1.0.154', 10154, 'F0D13AE37502F237921D996B7FE33EFD6D54C660C704C39D63AD9CE90DB68720', 'CREATE INDEX `index_group_active_on_GroupDB` ON `GroupDB` (`group_active`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (650, 469, '1.0.154', 10154, 'F0D13AE37502F237921D996B7FE33EFD6D54C660C704C39D63AD9CE90DB68720', 'CREATE INDEX `index_notification_silent_on_GroupDB` ON `GroupDB` (`notification_silent`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (651, 481, '1.0.154', 10154, '2D9D90685A61F7B7DE9FAFD4AC247B6277672AA133360CE1A083918EBCAC8628', 'CREATE TABLE `__temp_GroupDB` (`who_invited__tox_public_key_string` TEXT NOT NULL, `name` TEXT, `topic` TEXT, `peer_count` INTEGER NOT NULL DEFAULT - 1, `own_peer_number` INTEGER NOT NULL DEFAULT - 1, `privacy_state` INTEGER NOT NULL DEFAULT 0, `tox_group_number` INTEGER NOT NULL DEFAULT - 1, `group_active` BOOLEAN NOT NULL DEFAULT false, `notification_silent` BOOLEAN DEFAULT false, `group_identifier` TEXT PRIMARY KEY)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (652, 481, '1.0.154', 10154, '2D9D90685A61F7B7DE9FAFD4AC247B6277672AA133360CE1A083918EBCAC8628', 'INSERT INTO `__temp_GroupDB` (`who_invited__tox_public_key_string`, `name`, `peer_count`, `own_peer_number`, `privacy_state`, `tox_group_number`, `group_active`, `notification_silent`, `group_identifier`) SELECT `who_invited__tox_public_key_string`, `name`, `peer_count`, `own_peer_number`, `privacy_state`, `tox_group_number`, `group_active`, `notification_silent`, `group_identifier` FROM `GroupDB`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (653, 481, '1.0.154', 10154, '2D9D90685A61F7B7DE9FAFD4AC247B6277672AA133360CE1A083918EBCAC8628', 'DROP TABLE `GroupDB`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (654, 481, '1.0.154', 10154, '2D9D90685A61F7B7DE9FAFD4AC247B6277672AA133360CE1A083918EBCAC8628', 'ALTER TABLE `__temp_GroupDB` RENAME TO `GroupDB`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (655, 481, '1.0.154', 10154, '2D9D90685A61F7B7DE9FAFD4AC247B6277672AA133360CE1A083918EBCAC8628', 'CREATE INDEX `index_who_invited__tox_public_key_string_on_GroupDB` ON `GroupDB` (`who_invited__tox_public_key_string`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (656, 481, '1.0.154', 10154, '2D9D90685A61F7B7DE9FAFD4AC247B6277672AA133360CE1A083918EBCAC8628', 'CREATE INDEX `index_name_on_GroupDB` ON `GroupDB` (`name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (657, 481, '1.0.154', 10154, '2D9D90685A61F7B7DE9FAFD4AC247B6277672AA133360CE1A083918EBCAC8628', 'CREATE INDEX `index_topic_on_GroupDB` ON `GroupDB` (`topic`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (658, 481, '1.0.154', 10154, '2D9D90685A61F7B7DE9FAFD4AC247B6277672AA133360CE1A083918EBCAC8628', 'CREATE INDEX `index_peer_count_on_GroupDB` ON `GroupDB` (`peer_count`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (659, 481, '1.0.154', 10154, '2D9D90685A61F7B7DE9FAFD4AC247B6277672AA133360CE1A083918EBCAC8628', 'CREATE INDEX `index_own_peer_number_on_GroupDB` ON `GroupDB` (`own_peer_number`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (660, 481, '1.0.154', 10154, '2D9D90685A61F7B7DE9FAFD4AC247B6277672AA133360CE1A083918EBCAC8628', 'CREATE INDEX `index_privacy_state_on_GroupDB` ON `GroupDB` (`privacy_state`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (661, 481, '1.0.154', 10154, '2D9D90685A61F7B7DE9FAFD4AC247B6277672AA133360CE1A083918EBCAC8628', 'CREATE INDEX `index_tox_group_number_on_GroupDB` ON `GroupDB` (`tox_group_number`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (662, 481, '1.0.154', 10154, '2D9D90685A61F7B7DE9FAFD4AC247B6277672AA133360CE1A083918EBCAC8628', 'CREATE INDEX `index_group_active_on_GroupDB` ON `GroupDB` (`group_active`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (663, 481, '1.0.154', 10154, '2D9D90685A61F7B7DE9FAFD4AC247B6277672AA133360CE1A083918EBCAC8628', 'CREATE INDEX `index_notification_silent_on_GroupDB` ON `GroupDB` (`notification_silent`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (664, 495, '1.0.154', 10154, '14C99CC2BCF65183505D1E4FC52500926117DFE43A321458A67E9DDB2F3A2E69', 'CREATE TABLE `__temp_GroupMessage` (`message_id_tox` TEXT, `group_identifier` TEXT NOT NULL DEFAULT - 1, `tox_group_peer_pubkey` TEXT NOT NULL, `private_message` INTEGER, `tox_group_peername` TEXT, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `sent_timestamp` INTEGER, `rcvd_timestamp` INTEGER, `read` BOOLEAN NOT NULL, `is_new` BOOLEAN NOT NULL, `text` TEXT, `was_synced` BOOLEAN, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (665, 495, '1.0.154', 10154, '14C99CC2BCF65183505D1E4FC52500926117DFE43A321458A67E9DDB2F3A2E69', 'INSERT INTO `__temp_GroupMessage` (`message_id_tox`, `group_identifier`, `tox_group_peer_pubkey`, `tox_group_peername`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `was_synced`, `id`) SELECT `message_id_tox`, `group_identifier`, `tox_group_peer_pubkey`, `tox_group_peername`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `was_synced`, `id` FROM `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (666, 495, '1.0.154', 10154, '14C99CC2BCF65183505D1E4FC52500926117DFE43A321458A67E9DDB2F3A2E69', 'DROP TABLE `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (667, 495, '1.0.154', 10154, '14C99CC2BCF65183505D1E4FC52500926117DFE43A321458A67E9DDB2F3A2E69', 'ALTER TABLE `__temp_GroupMessage` RENAME TO `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (668, 495, '1.0.154', 10154, '14C99CC2BCF65183505D1E4FC52500926117DFE43A321458A67E9DDB2F3A2E69', 'CREATE INDEX `index_message_id_tox_on_GroupMessage` ON `GroupMessage` (`message_id_tox`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (669, 495, '1.0.154', 10154, '14C99CC2BCF65183505D1E4FC52500926117DFE43A321458A67E9DDB2F3A2E69', 'CREATE INDEX `index_group_identifier_on_GroupMessage` ON `GroupMessage` (`group_identifier`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (670, 495, '1.0.154', 10154, '14C99CC2BCF65183505D1E4FC52500926117DFE43A321458A67E9DDB2F3A2E69', 'CREATE INDEX `index_tox_group_peer_pubkey_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (671, 495, '1.0.154', 10154, '14C99CC2BCF65183505D1E4FC52500926117DFE43A321458A67E9DDB2F3A2E69', 'CREATE INDEX `index_private_message_on_GroupMessage` ON `GroupMessage` (`private_message`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (672, 495, '1.0.154', 10154, '14C99CC2BCF65183505D1E4FC52500926117DFE43A321458A67E9DDB2F3A2E69', 'CREATE INDEX `index_tox_group_peername_on_GroupMessage` ON `GroupMessage` (`tox_group_peername`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (673, 495, '1.0.154', 10154, '14C99CC2BCF65183505D1E4FC52500926117DFE43A321458A67E9DDB2F3A2E69', 'CREATE INDEX `index_direction_on_GroupMessage` ON `GroupMessage` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (674, 495, '1.0.154', 10154, '14C99CC2BCF65183505D1E4FC52500926117DFE43A321458A67E9DDB2F3A2E69', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_GroupMessage` ON `GroupMessage` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (675, 495, '1.0.154', 10154, '14C99CC2BCF65183505D1E4FC52500926117DFE43A321458A67E9DDB2F3A2E69', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_GroupMessage` ON `GroupMessage` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (676, 495, '1.0.154', 10154, '14C99CC2BCF65183505D1E4FC52500926117DFE43A321458A67E9DDB2F3A2E69', 'CREATE INDEX `index_rcvd_timestamp_on_GroupMessage` ON `GroupMessage` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (677, 495, '1.0.154', 10154, '14C99CC2BCF65183505D1E4FC52500926117DFE43A321458A67E9DDB2F3A2E69', 'CREATE INDEX `index_is_new_on_GroupMessage` ON `GroupMessage` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (678, 495, '1.0.154', 10154, '14C99CC2BCF65183505D1E4FC52500926117DFE43A321458A67E9DDB2F3A2E69', 'CREATE INDEX `index_was_synced_on_GroupMessage` ON `GroupMessage` (`was_synced`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (679, 510, '1.0.154', 10154, '08E76E6069D1B4A7A23AD2E42C6B627BDF5856AC4C97DA48C643592E6A97A6C8', 'CREATE TABLE `__temp_GroupMessage` (`message_id_tox` TEXT, `group_identifier` TEXT NOT NULL DEFAULT - 1, `tox_group_peer_pubkey` TEXT NOT NULL, `private_message` INTEGER, `tox_group_peername` TEXT, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `sent_timestamp` INTEGER, `rcvd_timestamp` INTEGER, `read` BOOLEAN NOT NULL, `is_new` BOOLEAN NOT NULL, `text` TEXT, `was_synced` BOOLEAN, `msg_id_hash` TEXT, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (680, 510, '1.0.154', 10154, '08E76E6069D1B4A7A23AD2E42C6B627BDF5856AC4C97DA48C643592E6A97A6C8', 'INSERT INTO `__temp_GroupMessage` (`message_id_tox`, `group_identifier`, `tox_group_peer_pubkey`, `private_message`, `tox_group_peername`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `was_synced`, `id`) SELECT `message_id_tox`, `group_identifier`, `tox_group_peer_pubkey`, `private_message`, `tox_group_peername`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `was_synced`, `id` FROM `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (681, 510, '1.0.154', 10154, '08E76E6069D1B4A7A23AD2E42C6B627BDF5856AC4C97DA48C643592E6A97A6C8', 'DROP TABLE `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (682, 510, '1.0.154', 10154, '08E76E6069D1B4A7A23AD2E42C6B627BDF5856AC4C97DA48C643592E6A97A6C8', 'ALTER TABLE `__temp_GroupMessage` RENAME TO `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (683, 510, '1.0.154', 10154, '08E76E6069D1B4A7A23AD2E42C6B627BDF5856AC4C97DA48C643592E6A97A6C8', 'CREATE INDEX `index_message_id_tox_on_GroupMessage` ON `GroupMessage` (`message_id_tox`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (684, 510, '1.0.154', 10154, '08E76E6069D1B4A7A23AD2E42C6B627BDF5856AC4C97DA48C643592E6A97A6C8', 'CREATE INDEX `index_group_identifier_on_GroupMessage` ON `GroupMessage` (`group_identifier`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (685, 510, '1.0.154', 10154, '08E76E6069D1B4A7A23AD2E42C6B627BDF5856AC4C97DA48C643592E6A97A6C8', 'CREATE INDEX `index_tox_group_peer_pubkey_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (686, 510, '1.0.154', 10154, '08E76E6069D1B4A7A23AD2E42C6B627BDF5856AC4C97DA48C643592E6A97A6C8', 'CREATE INDEX `index_private_message_on_GroupMessage` ON `GroupMessage` (`private_message`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (687, 510, '1.0.154', 10154, '08E76E6069D1B4A7A23AD2E42C6B627BDF5856AC4C97DA48C643592E6A97A6C8', 'CREATE INDEX `index_tox_group_peername_on_GroupMessage` ON `GroupMessage` (`tox_group_peername`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (688, 510, '1.0.154', 10154, '08E76E6069D1B4A7A23AD2E42C6B627BDF5856AC4C97DA48C643592E6A97A6C8', 'CREATE INDEX `index_direction_on_GroupMessage` ON `GroupMessage` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (689, 510, '1.0.154', 10154, '08E76E6069D1B4A7A23AD2E42C6B627BDF5856AC4C97DA48C643592E6A97A6C8', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_GroupMessage` ON `GroupMessage` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (690, 510, '1.0.154', 10154, '08E76E6069D1B4A7A23AD2E42C6B627BDF5856AC4C97DA48C643592E6A97A6C8', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_GroupMessage` ON `GroupMessage` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (691, 510, '1.0.154', 10154, '08E76E6069D1B4A7A23AD2E42C6B627BDF5856AC4C97DA48C643592E6A97A6C8', 'CREATE INDEX `index_rcvd_timestamp_on_GroupMessage` ON `GroupMessage` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (692, 510, '1.0.154', 10154, '08E76E6069D1B4A7A23AD2E42C6B627BDF5856AC4C97DA48C643592E6A97A6C8', 'CREATE INDEX `index_is_new_on_GroupMessage` ON `GroupMessage` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (693, 510, '1.0.154', 10154, '08E76E6069D1B4A7A23AD2E42C6B627BDF5856AC4C97DA48C643592E6A97A6C8', 'CREATE INDEX `index_was_synced_on_GroupMessage` ON `GroupMessage` (`was_synced`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (694, 510, '1.0.154', 10154, '08E76E6069D1B4A7A23AD2E42C6B627BDF5856AC4C97DA48C643592E6A97A6C8', 'CREATE INDEX `index_msg_id_hash_on_GroupMessage` ON `GroupMessage` (`msg_id_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (695, 525, '1.0.157', 10157, 'D8844E96985281632E3EF2774955C0CFBB4AC47BE4FA596C7C1BF4BFE78AA953', 'CREATE TABLE `__temp_Filetransfer` (`tox_public_key_string` TEXT NOT NULL, `direction` INTEGER NOT NULL, `file_number` INTEGER NOT NULL, `kind` INTEGER NOT NULL, `state` INTEGER NOT NULL, `ft_accepted` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_started` BOOLEAN NOT NULL DEFAULT false, `path_name` TEXT NOT NULL, `file_name` TEXT NOT NULL, `fos_open` BOOLEAN NOT NULL DEFAULT false, `filesize` INTEGER NOT NULL DEFAULT - 1, `current_position` INTEGER NOT NULL DEFAULT 0, `message_id` INTEGER NOT NULL DEFAULT - 1, `storage_frame_work` BOOLEAN NOT NULL DEFAULT false, `tox_file_id_hex` TEXT, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (696, 525, '1.0.157', 10157, 'D8844E96985281632E3EF2774955C0CFBB4AC47BE4FA596C7C1BF4BFE78AA953', 'INSERT INTO `__temp_Filetransfer` (`tox_public_key_string`, `direction`, `file_number`, `kind`, `state`, `ft_accepted`, `ft_outgoing_started`, `path_name`, `file_name`, `fos_open`, `filesize`, `current_position`, `message_id`, `storage_frame_work`, `id`) SELECT `tox_public_key_string`, `direction`, `file_number`, `kind`, `state`, `ft_accepted`, `ft_outgoing_started`, `path_name`, `file_name`, `fos_open`, `filesize`, `current_position`, `message_id`, `storage_frame_work`, `id` FROM `Filetransfer`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (697, 525, '1.0.157', 10157, 'D8844E96985281632E3EF2774955C0CFBB4AC47BE4FA596C7C1BF4BFE78AA953', 'DROP TABLE `Filetransfer`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (698, 525, '1.0.157', 10157, 'D8844E96985281632E3EF2774955C0CFBB4AC47BE4FA596C7C1BF4BFE78AA953', 'ALTER TABLE `__temp_Filetransfer` RENAME TO `Filetransfer`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (699, 525, '1.0.157', 10157, 'D8844E96985281632E3EF2774955C0CFBB4AC47BE4FA596C7C1BF4BFE78AA953', 'CREATE INDEX `index_tox_public_key_string_on_Filetransfer` ON `Filetransfer` (`tox_public_key_string`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (700, 525, '1.0.157', 10157, 'D8844E96985281632E3EF2774955C0CFBB4AC47BE4FA596C7C1BF4BFE78AA953', 'CREATE INDEX `index_direction_on_Filetransfer` ON `Filetransfer` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (701, 525, '1.0.157', 10157, 'D8844E96985281632E3EF2774955C0CFBB4AC47BE4FA596C7C1BF4BFE78AA953', 'CREATE INDEX `index_file_number_on_Filetransfer` ON `Filetransfer` (`file_number`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (702, 525, '1.0.157', 10157, 'D8844E96985281632E3EF2774955C0CFBB4AC47BE4FA596C7C1BF4BFE78AA953', 'CREATE INDEX `index_kind_on_Filetransfer` ON `Filetransfer` (`kind`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (703, 525, '1.0.157', 10157, 'D8844E96985281632E3EF2774955C0CFBB4AC47BE4FA596C7C1BF4BFE78AA953', 'CREATE INDEX `index_state_on_Filetransfer` ON `Filetransfer` (`state`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (704, 525, '1.0.157', 10157, 'D8844E96985281632E3EF2774955C0CFBB4AC47BE4FA596C7C1BF4BFE78AA953', 'CREATE INDEX `index_ft_accepted_on_Filetransfer` ON `Filetransfer` (`ft_accepted`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (705, 525, '1.0.157', 10157, 'D8844E96985281632E3EF2774955C0CFBB4AC47BE4FA596C7C1BF4BFE78AA953', 'CREATE INDEX `index_ft_outgoing_started_on_Filetransfer` ON `Filetransfer` (`ft_outgoing_started`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (706, 525, '1.0.157', 10157, 'D8844E96985281632E3EF2774955C0CFBB4AC47BE4FA596C7C1BF4BFE78AA953', 'CREATE INDEX `index_path_name_on_Filetransfer` ON `Filetransfer` (`path_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (707, 525, '1.0.157', 10157, 'D8844E96985281632E3EF2774955C0CFBB4AC47BE4FA596C7C1BF4BFE78AA953', 'CREATE INDEX `index_file_name_on_Filetransfer` ON `Filetransfer` (`file_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (708, 525, '1.0.157', 10157, 'D8844E96985281632E3EF2774955C0CFBB4AC47BE4FA596C7C1BF4BFE78AA953', 'CREATE INDEX `index_message_id_on_Filetransfer` ON `Filetransfer` (`message_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (709, 525, '1.0.157', 10157, 'D8844E96985281632E3EF2774955C0CFBB4AC47BE4FA596C7C1BF4BFE78AA953', 'CREATE INDEX `index_storage_frame_work_on_Filetransfer` ON `Filetransfer` (`storage_frame_work`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (710, 525, '1.0.157', 10157, 'D8844E96985281632E3EF2774955C0CFBB4AC47BE4FA596C7C1BF4BFE78AA953', 'CREATE INDEX `index_tox_file_id_hex_on_Filetransfer` ON `Filetransfer` (`tox_file_id_hex`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (711, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE TABLE `__temp_Message` (`message_id` INTEGER NOT NULL, `tox_friendpubkey` TEXT NOT NULL, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `state` INTEGER NOT NULL DEFAULT 1, `ft_accepted` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_started` BOOLEAN NOT NULL DEFAULT false, `filedb_id` INTEGER NOT NULL DEFAULT - 1, `filetransfer_id` INTEGER NOT NULL DEFAULT - 1, `sent_timestamp` INTEGER DEFAULT 0, `sent_timestamp_ms` INTEGER DEFAULT 0, `rcvd_timestamp` INTEGER DEFAULT 0, `rcvd_timestamp_ms` INTEGER DEFAULT 0, `read` BOOLEAN NOT NULL, `send_retries` INTEGER NOT NULL DEFAULT 0, `is_new` BOOLEAN NOT NULL, `text` TEXT, `filename_fullpath` TEXT, `msg_id_hash` TEXT, `raw_msgv2_bytes` TEXT, `msg_version` INTEGER NOT NULL DEFAULT 0, `resend_count` INTEGER NOT NULL DEFAULT 4, `storage_frame_work` BOOLEAN NOT NULL DEFAULT false, `ft_outgoing_queued` BOOLEAN NOT NULL DEFAULT false, `msg_at_relay` BOOLEAN NOT NULL DEFAULT false, `msg_idv3_hash` TEXT, `sent_push` INTEGER, `filetransfer_kind` INTEGER DEFAULT 0, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (712, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'INSERT INTO `__temp_Message` (`message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `send_retries`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `resend_count`, `storage_frame_work`, `ft_outgoing_queued`, `msg_at_relay`, `msg_idv3_hash`, `sent_push`, `id`) SELECT `message_id`, `tox_friendpubkey`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `state`, `ft_accepted`, `ft_outgoing_started`, `filedb_id`, `filetransfer_id`, `sent_timestamp`, `sent_timestamp_ms`, `rcvd_timestamp`, `rcvd_timestamp_ms`, `read`, `send_retries`, `is_new`, `text`, `filename_fullpath`, `msg_id_hash`, `raw_msgv2_bytes`, `msg_version`, `resend_count`, `storage_frame_work`, `ft_outgoing_queued`, `msg_at_relay`, `msg_idv3_hash`, `sent_push`, `id` FROM `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (713, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'DROP TABLE `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (714, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'ALTER TABLE `__temp_Message` RENAME TO `Message`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (715, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_message_id_on_Message` ON `Message` (`message_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (716, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_tox_friendpubkey_on_Message` ON `Message` (`tox_friendpubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (717, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_direction_on_Message` ON `Message` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (718, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_Message` ON `Message` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (719, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_Message` ON `Message` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (720, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_state_on_Message` ON `Message` (`state`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (721, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_ft_accepted_on_Message` ON `Message` (`ft_accepted`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (722, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_ft_outgoing_started_on_Message` ON `Message` (`ft_outgoing_started`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (723, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_filedb_id_on_Message` ON `Message` (`filedb_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (724, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_filetransfer_id_on_Message` ON `Message` (`filetransfer_id`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (725, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_rcvd_timestamp_on_Message` ON `Message` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (726, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_rcvd_timestamp_ms_on_Message` ON `Message` (`rcvd_timestamp_ms`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (727, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_send_retries_on_Message` ON `Message` (`send_retries`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (728, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_is_new_on_Message` ON `Message` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (729, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_text_on_Message` ON `Message` (`text`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (730, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_msg_id_hash_on_Message` ON `Message` (`msg_id_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (731, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_raw_msgv2_bytes_on_Message` ON `Message` (`raw_msgv2_bytes`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (732, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_msg_version_on_Message` ON `Message` (`msg_version`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (733, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_resend_count_on_Message` ON `Message` (`resend_count`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (734, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_storage_frame_work_on_Message` ON `Message` (`storage_frame_work`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (735, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_ft_outgoing_queued_on_Message` ON `Message` (`ft_outgoing_queued`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (736, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_msg_at_relay_on_Message` ON `Message` (`msg_at_relay`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (737, 551, '1.0.157', 10157, '8B6486D2AFE29ADC74F4F3E9B2EA20C06DA5E3F7A3A1E4998697936654B37E97', 'CREATE INDEX `index_msg_idv3_hash_on_Message` ON `Message` (`msg_idv3_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (738, 567, '1.0.172', 10172, '1C777B45F7B2D447617C610AD1DB3E035C3E0A141FADEF57E71F43229C05F625', 'CREATE TABLE `__temp_GroupMessage` (`message_id_tox` TEXT, `group_identifier` TEXT NOT NULL DEFAULT - 1, `tox_group_peer_pubkey` TEXT NOT NULL, `private_message` INTEGER, `tox_group_peername` TEXT, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `sent_timestamp` INTEGER, `rcvd_timestamp` INTEGER, `read` BOOLEAN NOT NULL, `is_new` BOOLEAN NOT NULL, `text` TEXT, `was_synced` BOOLEAN, `msg_id_hash` TEXT, `sent_privately_to_tox_group_peer_pubkey` TEXT, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (739, 567, '1.0.172', 10172, '1C777B45F7B2D447617C610AD1DB3E035C3E0A141FADEF57E71F43229C05F625', 'INSERT INTO `__temp_GroupMessage` (`message_id_tox`, `group_identifier`, `tox_group_peer_pubkey`, `private_message`, `tox_group_peername`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `was_synced`, `msg_id_hash`, `id`) SELECT `message_id_tox`, `group_identifier`, `tox_group_peer_pubkey`, `private_message`, `tox_group_peername`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `was_synced`, `msg_id_hash`, `id` FROM `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (740, 567, '1.0.172', 10172, '1C777B45F7B2D447617C610AD1DB3E035C3E0A141FADEF57E71F43229C05F625', 'DROP TABLE `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (741, 567, '1.0.172', 10172, '1C777B45F7B2D447617C610AD1DB3E035C3E0A141FADEF57E71F43229C05F625', 'ALTER TABLE `__temp_GroupMessage` RENAME TO `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (742, 567, '1.0.172', 10172, '1C777B45F7B2D447617C610AD1DB3E035C3E0A141FADEF57E71F43229C05F625', 'CREATE INDEX `index_message_id_tox_on_GroupMessage` ON `GroupMessage` (`message_id_tox`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (743, 567, '1.0.172', 10172, '1C777B45F7B2D447617C610AD1DB3E035C3E0A141FADEF57E71F43229C05F625', 'CREATE INDEX `index_group_identifier_on_GroupMessage` ON `GroupMessage` (`group_identifier`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (744, 567, '1.0.172', 10172, '1C777B45F7B2D447617C610AD1DB3E035C3E0A141FADEF57E71F43229C05F625', 'CREATE INDEX `index_tox_group_peer_pubkey_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (745, 567, '1.0.172', 10172, '1C777B45F7B2D447617C610AD1DB3E035C3E0A141FADEF57E71F43229C05F625', 'CREATE INDEX `index_private_message_on_GroupMessage` ON `GroupMessage` (`private_message`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (746, 567, '1.0.172', 10172, '1C777B45F7B2D447617C610AD1DB3E035C3E0A141FADEF57E71F43229C05F625', 'CREATE INDEX `index_tox_group_peername_on_GroupMessage` ON `GroupMessage` (`tox_group_peername`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (747, 567, '1.0.172', 10172, '1C777B45F7B2D447617C610AD1DB3E035C3E0A141FADEF57E71F43229C05F625', 'CREATE INDEX `index_direction_on_GroupMessage` ON `GroupMessage` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (748, 567, '1.0.172', 10172, '1C777B45F7B2D447617C610AD1DB3E035C3E0A141FADEF57E71F43229C05F625', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_GroupMessage` ON `GroupMessage` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (749, 567, '1.0.172', 10172, '1C777B45F7B2D447617C610AD1DB3E035C3E0A141FADEF57E71F43229C05F625', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_GroupMessage` ON `GroupMessage` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (750, 567, '1.0.172', 10172, '1C777B45F7B2D447617C610AD1DB3E035C3E0A141FADEF57E71F43229C05F625', 'CREATE INDEX `index_rcvd_timestamp_on_GroupMessage` ON `GroupMessage` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (751, 567, '1.0.172', 10172, '1C777B45F7B2D447617C610AD1DB3E035C3E0A141FADEF57E71F43229C05F625', 'CREATE INDEX `index_is_new_on_GroupMessage` ON `GroupMessage` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (752, 567, '1.0.172', 10172, '1C777B45F7B2D447617C610AD1DB3E035C3E0A141FADEF57E71F43229C05F625', 'CREATE INDEX `index_was_synced_on_GroupMessage` ON `GroupMessage` (`was_synced`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (753, 567, '1.0.172', 10172, '1C777B45F7B2D447617C610AD1DB3E035C3E0A141FADEF57E71F43229C05F625', 'CREATE INDEX `index_msg_id_hash_on_GroupMessage` ON `GroupMessage` (`msg_id_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (754, 567, '1.0.172', 10172, '1C777B45F7B2D447617C610AD1DB3E035C3E0A141FADEF57E71F43229C05F625', 'CREATE INDEX `index_sent_privately_to_tox_group_peer_pubkey_on_GroupMessage` ON `GroupMessage` (`sent_privately_to_tox_group_peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (755, 568, '1.0.186', 10186, '1C777B45F7B2D447617C610AD1DB3E035C3E0A141FADEF57E71F43229C05F625', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (756, 589, '1.0.189', 10189, '5F1C355516A6184FB6832A4D5FE53E4DC3888D78E4D329494C0400F6C6E37254', 'CREATE TABLE `__temp_FriendList` (`name` TEXT, `alias_name` TEXT, `status_message` TEXT, `TOX_CONNECTION` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_real` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off_real` INTEGER NOT NULL DEFAULT 0, `TOX_USER_STATUS` INTEGER NOT NULL DEFAULT 0, `avatar_pathname` TEXT, `avatar_filename` TEXT, `avatar_ftid_hex` TEXT, `avatar_update` BOOLEAN DEFAULT false, `avatar_update_timestamp` INTEGER NOT NULL DEFAULT - 1, `notification_silent` BOOLEAN DEFAULT false, `sort` INTEGER NOT NULL DEFAULT 0, `last_online_timestamp` INTEGER NOT NULL DEFAULT - 1, `last_online_timestamp_real` INTEGER NOT NULL DEFAULT - 1, `added_timestamp` INTEGER NOT NULL DEFAULT - 1, `is_relay` BOOLEAN DEFAULT false, `push_url` TEXT, `capabilities` INTEGER NOT NULL DEFAULT 0, `msgv3_capability` INTEGER NOT NULL DEFAULT 0, `tox_public_key_string` TEXT PRIMARY KEY)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (757, 589, '1.0.189', 10189, '5F1C355516A6184FB6832A4D5FE53E4DC3888D78E4D329494C0400F6C6E37254', 'INSERT INTO `__temp_FriendList` (`name`, `alias_name`, `status_message`, `TOX_CONNECTION`, `TOX_CONNECTION_real`, `TOX_CONNECTION_on_off`, `TOX_CONNECTION_on_off_real`, `TOX_USER_STATUS`, `avatar_pathname`, `avatar_filename`, `avatar_update`, `avatar_update_timestamp`, `notification_silent`, `sort`, `last_online_timestamp`, `last_online_timestamp_real`, `added_timestamp`, `is_relay`, `push_url`, `capabilities`, `msgv3_capability`, `tox_public_key_string`) SELECT `name`, `alias_name`, `status_message`, `TOX_CONNECTION`, `TOX_CONNECTION_real`, `TOX_CONNECTION_on_off`, `TOX_CONNECTION_on_off_real`, `TOX_USER_STATUS`, `avatar_pathname`, `avatar_filename`, `avatar_update`, `avatar_update_timestamp`, `notification_silent`, `sort`, `last_online_timestamp`, `last_online_timestamp_real`, `added_timestamp`, `is_relay`, `push_url`, `capabilities`, `msgv3_capability`, `tox_public_key_string` FROM `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (758, 589, '1.0.189', 10189, '5F1C355516A6184FB6832A4D5FE53E4DC3888D78E4D329494C0400F6C6E37254', 'DROP TABLE `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (759, 589, '1.0.189', 10189, '5F1C355516A6184FB6832A4D5FE53E4DC3888D78E4D329494C0400F6C6E37254', 'ALTER TABLE `__temp_FriendList` RENAME TO `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (760, 589, '1.0.189', 10189, '5F1C355516A6184FB6832A4D5FE53E4DC3888D78E4D329494C0400F6C6E37254', 'CREATE INDEX `index_alias_name_on_FriendList` ON `FriendList` (`alias_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (761, 589, '1.0.189', 10189, '5F1C355516A6184FB6832A4D5FE53E4DC3888D78E4D329494C0400F6C6E37254', 'CREATE INDEX `index_TOX_CONNECTION_on_FriendList` ON `FriendList` (`TOX_CONNECTION`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (762, 589, '1.0.189', 10189, '5F1C355516A6184FB6832A4D5FE53E4DC3888D78E4D329494C0400F6C6E37254', 'CREATE INDEX `index_TOX_CONNECTION_real_on_FriendList` ON `FriendList` (`TOX_CONNECTION_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (763, 589, '1.0.189', 10189, '5F1C355516A6184FB6832A4D5FE53E4DC3888D78E4D329494C0400F6C6E37254', 'CREATE INDEX `index_TOX_CONNECTION_on_off_on_FriendList` ON `FriendList` (`TOX_CONNECTION_on_off`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (764, 589, '1.0.189', 10189, '5F1C355516A6184FB6832A4D5FE53E4DC3888D78E4D329494C0400F6C6E37254', 'CREATE INDEX `index_TOX_CONNECTION_on_off_real_on_FriendList` ON `FriendList` (`TOX_CONNECTION_on_off_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (765, 589, '1.0.189', 10189, '5F1C355516A6184FB6832A4D5FE53E4DC3888D78E4D329494C0400F6C6E37254', 'CREATE INDEX `index_TOX_USER_STATUS_on_FriendList` ON `FriendList` (`TOX_USER_STATUS`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (766, 589, '1.0.189', 10189, '5F1C355516A6184FB6832A4D5FE53E4DC3888D78E4D329494C0400F6C6E37254', 'CREATE INDEX `index_avatar_ftid_hex_on_FriendList` ON `FriendList` (`avatar_ftid_hex`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (767, 589, '1.0.189', 10189, '5F1C355516A6184FB6832A4D5FE53E4DC3888D78E4D329494C0400F6C6E37254', 'CREATE INDEX `index_avatar_update_on_FriendList` ON `FriendList` (`avatar_update`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (768, 589, '1.0.189', 10189, '5F1C355516A6184FB6832A4D5FE53E4DC3888D78E4D329494C0400F6C6E37254', 'CREATE INDEX `index_avatar_update_timestamp_on_FriendList` ON `FriendList` (`avatar_update_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (769, 589, '1.0.189', 10189, '5F1C355516A6184FB6832A4D5FE53E4DC3888D78E4D329494C0400F6C6E37254', 'CREATE INDEX `index_notification_silent_on_FriendList` ON `FriendList` (`notification_silent`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (770, 589, '1.0.189', 10189, '5F1C355516A6184FB6832A4D5FE53E4DC3888D78E4D329494C0400F6C6E37254', 'CREATE INDEX `index_sort_on_FriendList` ON `FriendList` (`sort`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (771, 589, '1.0.189', 10189, '5F1C355516A6184FB6832A4D5FE53E4DC3888D78E4D329494C0400F6C6E37254', 'CREATE INDEX `index_last_online_timestamp_on_FriendList` ON `FriendList` (`last_online_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (772, 589, '1.0.189', 10189, '5F1C355516A6184FB6832A4D5FE53E4DC3888D78E4D329494C0400F6C6E37254', 'CREATE INDEX `index_last_online_timestamp_real_on_FriendList` ON `FriendList` (`last_online_timestamp_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (773, 589, '1.0.189', 10189, '5F1C355516A6184FB6832A4D5FE53E4DC3888D78E4D329494C0400F6C6E37254', 'CREATE INDEX `index_added_timestamp_on_FriendList` ON `FriendList` (`added_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (774, 589, '1.0.189', 10189, '5F1C355516A6184FB6832A4D5FE53E4DC3888D78E4D329494C0400F6C6E37254', 'CREATE INDEX `index_is_relay_on_FriendList` ON `FriendList` (`is_relay`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (775, 589, '1.0.189', 10189, '5F1C355516A6184FB6832A4D5FE53E4DC3888D78E4D329494C0400F6C6E37254', 'CREATE INDEX `index_push_url_on_FriendList` ON `FriendList` (`push_url`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (776, 589, '1.0.189', 10189, '5F1C355516A6184FB6832A4D5FE53E4DC3888D78E4D329494C0400F6C6E37254', 'CREATE INDEX `index_capabilities_on_FriendList` ON `FriendList` (`capabilities`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (777, 589, '1.0.189', 10189, '5F1C355516A6184FB6832A4D5FE53E4DC3888D78E4D329494C0400F6C6E37254', 'CREATE INDEX `index_msgv3_capability_on_FriendList` ON `FriendList` (`msgv3_capability`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (778, 589, '1.0.189', 10189, '213C1EB5914F3140B24E3E25CB323DC0D337F4314256196045220FA125CA3CC7', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (779, 609, '1.0.195', 10195, '9167AA743B35326C8F349F500BCFE682EDBBF928AA6C36EBA6B5C5F8D522CCAF', 'CREATE TABLE `__temp_GroupMessage` (`message_id_tox` TEXT, `group_identifier` TEXT NOT NULL DEFAULT - 1, `tox_group_peer_pubkey` TEXT NOT NULL, `private_message` INTEGER, `tox_group_peername` TEXT, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `sent_timestamp` INTEGER, `rcvd_timestamp` INTEGER, `read` BOOLEAN NOT NULL, `is_new` BOOLEAN NOT NULL, `text` TEXT, `was_synced` BOOLEAN, `msg_id_hash` TEXT, `sent_privately_to_tox_group_peer_pubkey` TEXT, `path_name` TEXT, `file_name` TEXT, `filename_fullpath` TEXT, `filesize` INTEGER NOT NULL DEFAULT - 1, `storage_frame_work` BOOLEAN NOT NULL DEFAULT false, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (780, 609, '1.0.195', 10195, '9167AA743B35326C8F349F500BCFE682EDBBF928AA6C36EBA6B5C5F8D522CCAF', 'INSERT INTO `__temp_GroupMessage` (`message_id_tox`, `group_identifier`, `tox_group_peer_pubkey`, `private_message`, `tox_group_peername`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `was_synced`, `msg_id_hash`, `sent_privately_to_tox_group_peer_pubkey`, `id`) SELECT `message_id_tox`, `group_identifier`, `tox_group_peer_pubkey`, `private_message`, `tox_group_peername`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `was_synced`, `msg_id_hash`, `sent_privately_to_tox_group_peer_pubkey`, `id` FROM `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (781, 609, '1.0.195', 10195, '9167AA743B35326C8F349F500BCFE682EDBBF928AA6C36EBA6B5C5F8D522CCAF', 'DROP TABLE `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (782, 609, '1.0.195', 10195, '9167AA743B35326C8F349F500BCFE682EDBBF928AA6C36EBA6B5C5F8D522CCAF', 'ALTER TABLE `__temp_GroupMessage` RENAME TO `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (783, 609, '1.0.195', 10195, '9167AA743B35326C8F349F500BCFE682EDBBF928AA6C36EBA6B5C5F8D522CCAF', 'CREATE INDEX `index_message_id_tox_on_GroupMessage` ON `GroupMessage` (`message_id_tox`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (784, 609, '1.0.195', 10195, '9167AA743B35326C8F349F500BCFE682EDBBF928AA6C36EBA6B5C5F8D522CCAF', 'CREATE INDEX `index_group_identifier_on_GroupMessage` ON `GroupMessage` (`group_identifier`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (785, 609, '1.0.195', 10195, '9167AA743B35326C8F349F500BCFE682EDBBF928AA6C36EBA6B5C5F8D522CCAF', 'CREATE INDEX `index_tox_group_peer_pubkey_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (786, 609, '1.0.195', 10195, '9167AA743B35326C8F349F500BCFE682EDBBF928AA6C36EBA6B5C5F8D522CCAF', 'CREATE INDEX `index_private_message_on_GroupMessage` ON `GroupMessage` (`private_message`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (787, 609, '1.0.195', 10195, '9167AA743B35326C8F349F500BCFE682EDBBF928AA6C36EBA6B5C5F8D522CCAF', 'CREATE INDEX `index_tox_group_peername_on_GroupMessage` ON `GroupMessage` (`tox_group_peername`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (788, 609, '1.0.195', 10195, '9167AA743B35326C8F349F500BCFE682EDBBF928AA6C36EBA6B5C5F8D522CCAF', 'CREATE INDEX `index_direction_on_GroupMessage` ON `GroupMessage` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (789, 609, '1.0.195', 10195, '9167AA743B35326C8F349F500BCFE682EDBBF928AA6C36EBA6B5C5F8D522CCAF', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_GroupMessage` ON `GroupMessage` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (790, 609, '1.0.195', 10195, '9167AA743B35326C8F349F500BCFE682EDBBF928AA6C36EBA6B5C5F8D522CCAF', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_GroupMessage` ON `GroupMessage` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (791, 609, '1.0.195', 10195, '9167AA743B35326C8F349F500BCFE682EDBBF928AA6C36EBA6B5C5F8D522CCAF', 'CREATE INDEX `index_rcvd_timestamp_on_GroupMessage` ON `GroupMessage` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (792, 609, '1.0.195', 10195, '9167AA743B35326C8F349F500BCFE682EDBBF928AA6C36EBA6B5C5F8D522CCAF', 'CREATE INDEX `index_is_new_on_GroupMessage` ON `GroupMessage` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (793, 609, '1.0.195', 10195, '9167AA743B35326C8F349F500BCFE682EDBBF928AA6C36EBA6B5C5F8D522CCAF', 'CREATE INDEX `index_was_synced_on_GroupMessage` ON `GroupMessage` (`was_synced`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (794, 609, '1.0.195', 10195, '9167AA743B35326C8F349F500BCFE682EDBBF928AA6C36EBA6B5C5F8D522CCAF', 'CREATE INDEX `index_msg_id_hash_on_GroupMessage` ON `GroupMessage` (`msg_id_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (795, 609, '1.0.195', 10195, '9167AA743B35326C8F349F500BCFE682EDBBF928AA6C36EBA6B5C5F8D522CCAF', 'CREATE INDEX `index_sent_privately_to_tox_group_peer_pubkey_on_GroupMessage` ON `GroupMessage` (`sent_privately_to_tox_group_peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (796, 609, '1.0.195', 10195, '9167AA743B35326C8F349F500BCFE682EDBBF928AA6C36EBA6B5C5F8D522CCAF', 'CREATE INDEX `index_path_name_on_GroupMessage` ON `GroupMessage` (`path_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (797, 609, '1.0.195', 10195, '9167AA743B35326C8F349F500BCFE682EDBBF928AA6C36EBA6B5C5F8D522CCAF', 'CREATE INDEX `index_file_name_on_GroupMessage` ON `GroupMessage` (`file_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (798, 609, '1.0.195', 10195, '9167AA743B35326C8F349F500BCFE682EDBBF928AA6C36EBA6B5C5F8D522CCAF', 'CREATE INDEX `index_filesize_on_GroupMessage` ON `GroupMessage` (`filesize`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (799, 609, '1.0.195', 10195, '9167AA743B35326C8F349F500BCFE682EDBBF928AA6C36EBA6B5C5F8D522CCAF', 'CREATE INDEX `index_storage_frame_work_on_GroupMessage` ON `GroupMessage` (`storage_frame_work`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (800, 630, '1.0.195', 10195, '036732DF04BDF555DED6CCA67223D3EA2A7641C38A636622A1FFF79DC6E559CF', 'CREATE TABLE `__temp_GroupMessage` (`message_id_tox` TEXT, `group_identifier` TEXT NOT NULL DEFAULT - 1, `tox_group_peer_pubkey` TEXT NOT NULL, `private_message` INTEGER, `tox_group_peername` TEXT, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `sent_timestamp` INTEGER, `rcvd_timestamp` INTEGER, `read` BOOLEAN NOT NULL, `is_new` BOOLEAN NOT NULL, `text` TEXT, `was_synced` BOOLEAN, `TRIFA_SYNC_TYPE` INTEGER, `msg_id_hash` TEXT, `sent_privately_to_tox_group_peer_pubkey` TEXT, `path_name` TEXT, `file_name` TEXT, `filename_fullpath` TEXT, `filesize` INTEGER NOT NULL DEFAULT - 1, `storage_frame_work` BOOLEAN NOT NULL DEFAULT false, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (801, 630, '1.0.195', 10195, '036732DF04BDF555DED6CCA67223D3EA2A7641C38A636622A1FFF79DC6E559CF', 'INSERT INTO `__temp_GroupMessage` (`message_id_tox`, `group_identifier`, `tox_group_peer_pubkey`, `private_message`, `tox_group_peername`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `was_synced`, `msg_id_hash`, `sent_privately_to_tox_group_peer_pubkey`, `path_name`, `file_name`, `filename_fullpath`, `filesize`, `storage_frame_work`, `id`) SELECT `message_id_tox`, `group_identifier`, `tox_group_peer_pubkey`, `private_message`, `tox_group_peername`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `was_synced`, `msg_id_hash`, `sent_privately_to_tox_group_peer_pubkey`, `path_name`, `file_name`, `filename_fullpath`, `filesize`, `storage_frame_work`, `id` FROM `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (802, 630, '1.0.195', 10195, '036732DF04BDF555DED6CCA67223D3EA2A7641C38A636622A1FFF79DC6E559CF', 'DROP TABLE `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (803, 630, '1.0.195', 10195, '036732DF04BDF555DED6CCA67223D3EA2A7641C38A636622A1FFF79DC6E559CF', 'ALTER TABLE `__temp_GroupMessage` RENAME TO `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (804, 630, '1.0.195', 10195, '036732DF04BDF555DED6CCA67223D3EA2A7641C38A636622A1FFF79DC6E559CF', 'CREATE INDEX `index_message_id_tox_on_GroupMessage` ON `GroupMessage` (`message_id_tox`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (805, 630, '1.0.195', 10195, '036732DF04BDF555DED6CCA67223D3EA2A7641C38A636622A1FFF79DC6E559CF', 'CREATE INDEX `index_group_identifier_on_GroupMessage` ON `GroupMessage` (`group_identifier`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (806, 630, '1.0.195', 10195, '036732DF04BDF555DED6CCA67223D3EA2A7641C38A636622A1FFF79DC6E559CF', 'CREATE INDEX `index_tox_group_peer_pubkey_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (807, 630, '1.0.195', 10195, '036732DF04BDF555DED6CCA67223D3EA2A7641C38A636622A1FFF79DC6E559CF', 'CREATE INDEX `index_private_message_on_GroupMessage` ON `GroupMessage` (`private_message`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (808, 630, '1.0.195', 10195, '036732DF04BDF555DED6CCA67223D3EA2A7641C38A636622A1FFF79DC6E559CF', 'CREATE INDEX `index_tox_group_peername_on_GroupMessage` ON `GroupMessage` (`tox_group_peername`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (809, 630, '1.0.195', 10195, '036732DF04BDF555DED6CCA67223D3EA2A7641C38A636622A1FFF79DC6E559CF', 'CREATE INDEX `index_direction_on_GroupMessage` ON `GroupMessage` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (810, 630, '1.0.195', 10195, '036732DF04BDF555DED6CCA67223D3EA2A7641C38A636622A1FFF79DC6E559CF', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_GroupMessage` ON `GroupMessage` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (811, 630, '1.0.195', 10195, '036732DF04BDF555DED6CCA67223D3EA2A7641C38A636622A1FFF79DC6E559CF', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_GroupMessage` ON `GroupMessage` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (812, 630, '1.0.195', 10195, '036732DF04BDF555DED6CCA67223D3EA2A7641C38A636622A1FFF79DC6E559CF', 'CREATE INDEX `index_rcvd_timestamp_on_GroupMessage` ON `GroupMessage` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (813, 630, '1.0.195', 10195, '036732DF04BDF555DED6CCA67223D3EA2A7641C38A636622A1FFF79DC6E559CF', 'CREATE INDEX `index_is_new_on_GroupMessage` ON `GroupMessage` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (814, 630, '1.0.195', 10195, '036732DF04BDF555DED6CCA67223D3EA2A7641C38A636622A1FFF79DC6E559CF', 'CREATE INDEX `index_was_synced_on_GroupMessage` ON `GroupMessage` (`was_synced`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (815, 630, '1.0.195', 10195, '036732DF04BDF555DED6CCA67223D3EA2A7641C38A636622A1FFF79DC6E559CF', 'CREATE INDEX `index_TRIFA_SYNC_TYPE_on_GroupMessage` ON `GroupMessage` (`TRIFA_SYNC_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (816, 630, '1.0.195', 10195, '036732DF04BDF555DED6CCA67223D3EA2A7641C38A636622A1FFF79DC6E559CF', 'CREATE INDEX `index_msg_id_hash_on_GroupMessage` ON `GroupMessage` (`msg_id_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (817, 630, '1.0.195', 10195, '036732DF04BDF555DED6CCA67223D3EA2A7641C38A636622A1FFF79DC6E559CF', 'CREATE INDEX `index_sent_privately_to_tox_group_peer_pubkey_on_GroupMessage` ON `GroupMessage` (`sent_privately_to_tox_group_peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (818, 630, '1.0.195', 10195, '036732DF04BDF555DED6CCA67223D3EA2A7641C38A636622A1FFF79DC6E559CF', 'CREATE INDEX `index_path_name_on_GroupMessage` ON `GroupMessage` (`path_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (819, 630, '1.0.195', 10195, '036732DF04BDF555DED6CCA67223D3EA2A7641C38A636622A1FFF79DC6E559CF', 'CREATE INDEX `index_file_name_on_GroupMessage` ON `GroupMessage` (`file_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (820, 630, '1.0.195', 10195, '036732DF04BDF555DED6CCA67223D3EA2A7641C38A636622A1FFF79DC6E559CF', 'CREATE INDEX `index_filesize_on_GroupMessage` ON `GroupMessage` (`filesize`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (821, 630, '1.0.195', 10195, '036732DF04BDF555DED6CCA67223D3EA2A7641C38A636622A1FFF79DC6E559CF', 'CREATE INDEX `index_storage_frame_work_on_GroupMessage` ON `GroupMessage` (`storage_frame_work`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (822, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'CREATE TABLE `__temp_GroupMessage` (`message_id_tox` TEXT, `group_identifier` TEXT NOT NULL DEFAULT - 1, `tox_group_peer_pubkey` TEXT NOT NULL, `private_message` INTEGER, `tox_group_peername` TEXT, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `sent_timestamp` INTEGER, `rcvd_timestamp` INTEGER, `read` BOOLEAN NOT NULL, `is_new` BOOLEAN NOT NULL, `text` TEXT, `was_synced` BOOLEAN, `TRIFA_SYNC_TYPE` INTEGER, `sync_confirmations` INTEGER NOT NULL DEFAULT 0, `msg_id_hash` TEXT, `sent_privately_to_tox_group_peer_pubkey` TEXT, `path_name` TEXT, `file_name` TEXT, `filename_fullpath` TEXT, `filesize` INTEGER NOT NULL DEFAULT - 1, `storage_frame_work` BOOLEAN NOT NULL DEFAULT false, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (823, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'INSERT INTO `__temp_GroupMessage` (`message_id_tox`, `group_identifier`, `tox_group_peer_pubkey`, `private_message`, `tox_group_peername`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `was_synced`, `TRIFA_SYNC_TYPE`, `msg_id_hash`, `sent_privately_to_tox_group_peer_pubkey`, `path_name`, `file_name`, `filename_fullpath`, `filesize`, `storage_frame_work`, `id`) SELECT `message_id_tox`, `group_identifier`, `tox_group_peer_pubkey`, `private_message`, `tox_group_peername`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `was_synced`, `TRIFA_SYNC_TYPE`, `msg_id_hash`, `sent_privately_to_tox_group_peer_pubkey`, `path_name`, `file_name`, `filename_fullpath`, `filesize`, `storage_frame_work`, `id` FROM `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (824, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'DROP TABLE `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (825, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'ALTER TABLE `__temp_GroupMessage` RENAME TO `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (826, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'CREATE INDEX `index_message_id_tox_on_GroupMessage` ON `GroupMessage` (`message_id_tox`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (827, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'CREATE INDEX `index_group_identifier_on_GroupMessage` ON `GroupMessage` (`group_identifier`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (828, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'CREATE INDEX `index_tox_group_peer_pubkey_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (829, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'CREATE INDEX `index_private_message_on_GroupMessage` ON `GroupMessage` (`private_message`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (830, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'CREATE INDEX `index_tox_group_peername_on_GroupMessage` ON `GroupMessage` (`tox_group_peername`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (831, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'CREATE INDEX `index_direction_on_GroupMessage` ON `GroupMessage` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (832, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_GroupMessage` ON `GroupMessage` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (833, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_GroupMessage` ON `GroupMessage` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (834, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'CREATE INDEX `index_rcvd_timestamp_on_GroupMessage` ON `GroupMessage` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (835, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'CREATE INDEX `index_is_new_on_GroupMessage` ON `GroupMessage` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (836, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'CREATE INDEX `index_was_synced_on_GroupMessage` ON `GroupMessage` (`was_synced`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (837, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'CREATE INDEX `index_TRIFA_SYNC_TYPE_on_GroupMessage` ON `GroupMessage` (`TRIFA_SYNC_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (838, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'CREATE INDEX `index_sync_confirmations_on_GroupMessage` ON `GroupMessage` (`sync_confirmations`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (839, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'CREATE INDEX `index_msg_id_hash_on_GroupMessage` ON `GroupMessage` (`msg_id_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (840, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'CREATE INDEX `index_sent_privately_to_tox_group_peer_pubkey_on_GroupMessage` ON `GroupMessage` (`sent_privately_to_tox_group_peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (841, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'CREATE INDEX `index_path_name_on_GroupMessage` ON `GroupMessage` (`path_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (842, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'CREATE INDEX `index_file_name_on_GroupMessage` ON `GroupMessage` (`file_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (843, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'CREATE INDEX `index_filesize_on_GroupMessage` ON `GroupMessage` (`filesize`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (844, 652, '1.0.195', 10195, '23229DB6190329B792584D4F8486E4C6A832E84EE5E590E8D690ADED0B538366', 'CREATE INDEX `index_storage_frame_work_on_GroupMessage` ON `GroupMessage` (`storage_frame_work`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (845, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE TABLE `__temp_GroupMessage` (`message_id_tox` TEXT, `group_identifier` TEXT NOT NULL DEFAULT - 1, `tox_group_peer_pubkey` TEXT NOT NULL, `private_message` INTEGER, `tox_group_peername` TEXT, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `sent_timestamp` INTEGER, `rcvd_timestamp` INTEGER, `read` BOOLEAN NOT NULL, `is_new` BOOLEAN NOT NULL, `text` TEXT, `was_synced` BOOLEAN, `TRIFA_SYNC_TYPE` INTEGER, `sync_confirmations` INTEGER NOT NULL DEFAULT 0, `tox_group_peer_pubkey_syncer_01` TEXT, `tox_group_peer_pubkey_syncer_02` TEXT, `tox_group_peer_pubkey_syncer_03` TEXT, `msg_id_hash` TEXT, `sent_privately_to_tox_group_peer_pubkey` TEXT, `path_name` TEXT, `file_name` TEXT, `filename_fullpath` TEXT, `filesize` INTEGER NOT NULL DEFAULT - 1, `storage_frame_work` BOOLEAN NOT NULL DEFAULT false, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (846, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'INSERT INTO `__temp_GroupMessage` (`message_id_tox`, `group_identifier`, `tox_group_peer_pubkey`, `private_message`, `tox_group_peername`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `was_synced`, `TRIFA_SYNC_TYPE`, `sync_confirmations`, `msg_id_hash`, `sent_privately_to_tox_group_peer_pubkey`, `path_name`, `file_name`, `filename_fullpath`, `filesize`, `storage_frame_work`, `id`) SELECT `message_id_tox`, `group_identifier`, `tox_group_peer_pubkey`, `private_message`, `tox_group_peername`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `was_synced`, `TRIFA_SYNC_TYPE`, `sync_confirmations`, `msg_id_hash`, `sent_privately_to_tox_group_peer_pubkey`, `path_name`, `file_name`, `filename_fullpath`, `filesize`, `storage_frame_work`, `id` FROM `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (847, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'DROP TABLE `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (848, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'ALTER TABLE `__temp_GroupMessage` RENAME TO `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (849, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE INDEX `index_message_id_tox_on_GroupMessage` ON `GroupMessage` (`message_id_tox`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (850, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE INDEX `index_group_identifier_on_GroupMessage` ON `GroupMessage` (`group_identifier`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (851, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE INDEX `index_tox_group_peer_pubkey_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (852, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE INDEX `index_private_message_on_GroupMessage` ON `GroupMessage` (`private_message`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (853, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE INDEX `index_tox_group_peername_on_GroupMessage` ON `GroupMessage` (`tox_group_peername`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (854, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE INDEX `index_direction_on_GroupMessage` ON `GroupMessage` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (855, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_GroupMessage` ON `GroupMessage` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (856, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_GroupMessage` ON `GroupMessage` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (857, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE INDEX `index_rcvd_timestamp_on_GroupMessage` ON `GroupMessage` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (858, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE INDEX `index_is_new_on_GroupMessage` ON `GroupMessage` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (859, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE INDEX `index_was_synced_on_GroupMessage` ON `GroupMessage` (`was_synced`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (860, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE INDEX `index_TRIFA_SYNC_TYPE_on_GroupMessage` ON `GroupMessage` (`TRIFA_SYNC_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (861, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE INDEX `index_sync_confirmations_on_GroupMessage` ON `GroupMessage` (`sync_confirmations`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (862, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE INDEX `index_tox_group_peer_pubkey_syncer_01_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey_syncer_01`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (863, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE INDEX `index_tox_group_peer_pubkey_syncer_02_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey_syncer_02`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (864, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE INDEX `index_tox_group_peer_pubkey_syncer_03_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey_syncer_03`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (865, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE INDEX `index_msg_id_hash_on_GroupMessage` ON `GroupMessage` (`msg_id_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (866, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE INDEX `index_sent_privately_to_tox_group_peer_pubkey_on_GroupMessage` ON `GroupMessage` (`sent_privately_to_tox_group_peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (867, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE INDEX `index_path_name_on_GroupMessage` ON `GroupMessage` (`path_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (868, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE INDEX `index_file_name_on_GroupMessage` ON `GroupMessage` (`file_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (869, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE INDEX `index_filesize_on_GroupMessage` ON `GroupMessage` (`filesize`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (870, 677, '1.0.195', 10195, '0823AB6E90667FC12B21B17B5C6207CD6359167467DC271BDDAF71430FD7D3E4', 'CREATE INDEX `index_storage_frame_work_on_GroupMessage` ON `GroupMessage` (`storage_frame_work`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (871, 683, '1.0.203', 10203, 'E29DE53683FD9D517F5C445116FEE82BBC151D66925EAFCDFD62950BC0A539A3', 'CREATE TABLE `GroupPeerDB` (`group_identifier` TEXT NOT NULL, `tox_group_peer_pubkey` TEXT NOT NULL, `peer_name` TEXT , `last_update_timestamp` INTEGER NOT NULL DEFAULT -1, `first_join_timestamp` INTEGER NOT NULL DEFAULT -1, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (872, 683, '1.0.203', 10203, 'E29DE53683FD9D517F5C445116FEE82BBC151D66925EAFCDFD62950BC0A539A3', 'CREATE INDEX `index_group_identifier_on_GroupPeerDB` ON `GroupPeerDB` (`group_identifier`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (873, 683, '1.0.203', 10203, 'E29DE53683FD9D517F5C445116FEE82BBC151D66925EAFCDFD62950BC0A539A3', 'CREATE INDEX `index_tox_group_peer_pubkey_on_GroupPeerDB` ON `GroupPeerDB` (`tox_group_peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (874, 683, '1.0.203', 10203, 'E29DE53683FD9D517F5C445116FEE82BBC151D66925EAFCDFD62950BC0A539A3', 'CREATE INDEX `index_peer_name_on_GroupPeerDB` ON `GroupPeerDB` (`peer_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (875, 683, '1.0.203', 10203, 'E29DE53683FD9D517F5C445116FEE82BBC151D66925EAFCDFD62950BC0A539A3', 'CREATE INDEX `index_last_update_timestamp_on_GroupPeerDB` ON `GroupPeerDB` (`last_update_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (876, 683, '1.0.203', 10203, 'E29DE53683FD9D517F5C445116FEE82BBC151D66925EAFCDFD62950BC0A539A3', 'CREATE INDEX `index_first_join_timestamp_on_GroupPeerDB` ON `GroupPeerDB` (`first_join_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (877, 684, '1.0.203', 10203, 'E3EAA23F864B68FA6508C5D9F9B93A00D8E9F2AD070071D9111A29E88503F8C6', 'CREATE UNIQUE INDEX `index_group_identifier_tox_group_peer_pubkey_on_GroupPeerDB` ON `GroupPeerDB` (`group_identifier`, `tox_group_peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (878, 684, '1.0.205', 10205, 'FAFFC1637C1FF0003185E82B7A1FD9AF622370B7C75D78105B640F94B4303CEC', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (879, 694, '1.0.206', 10206, 'CE7BC814AD77EF5F902DB9303C35349964FA5AA34F55CB479A4033FAF1252551', 'CREATE TABLE `__temp_GroupPeerDB` (`group_identifier` TEXT NOT NULL, `tox_group_peer_pubkey` TEXT NOT NULL, `peer_name` TEXT, `last_update_timestamp` INTEGER NOT NULL DEFAULT - 1, `first_join_timestamp` INTEGER NOT NULL DEFAULT - 1, `Tox_Group_Role` INTEGER NOT NULL DEFAULT 2, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (880, 694, '1.0.206', 10206, 'CE7BC814AD77EF5F902DB9303C35349964FA5AA34F55CB479A4033FAF1252551', 'INSERT INTO `__temp_GroupPeerDB` (`group_identifier`, `tox_group_peer_pubkey`, `peer_name`, `last_update_timestamp`, `first_join_timestamp`, `id`) SELECT `group_identifier`, `tox_group_peer_pubkey`, `peer_name`, `last_update_timestamp`, `first_join_timestamp`, `id` FROM `GroupPeerDB`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (881, 694, '1.0.206', 10206, 'CE7BC814AD77EF5F902DB9303C35349964FA5AA34F55CB479A4033FAF1252551', 'DROP TABLE `GroupPeerDB`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (882, 694, '1.0.206', 10206, 'CE7BC814AD77EF5F902DB9303C35349964FA5AA34F55CB479A4033FAF1252551', 'ALTER TABLE `__temp_GroupPeerDB` RENAME TO `GroupPeerDB`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (883, 694, '1.0.206', 10206, 'CE7BC814AD77EF5F902DB9303C35349964FA5AA34F55CB479A4033FAF1252551', 'CREATE UNIQUE INDEX `index_group_identifier_tox_group_peer_pubkey_on_GroupPeerDB` ON `GroupPeerDB` (`group_identifier`, `tox_group_peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (884, 694, '1.0.206', 10206, 'CE7BC814AD77EF5F902DB9303C35349964FA5AA34F55CB479A4033FAF1252551', 'CREATE INDEX `index_group_identifier_on_GroupPeerDB` ON `GroupPeerDB` (`group_identifier`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (885, 694, '1.0.206', 10206, 'CE7BC814AD77EF5F902DB9303C35349964FA5AA34F55CB479A4033FAF1252551', 'CREATE INDEX `index_tox_group_peer_pubkey_on_GroupPeerDB` ON `GroupPeerDB` (`tox_group_peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (886, 694, '1.0.206', 10206, 'CE7BC814AD77EF5F902DB9303C35349964FA5AA34F55CB479A4033FAF1252551', 'CREATE INDEX `index_peer_name_on_GroupPeerDB` ON `GroupPeerDB` (`peer_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (887, 694, '1.0.206', 10206, 'CE7BC814AD77EF5F902DB9303C35349964FA5AA34F55CB479A4033FAF1252551', 'CREATE INDEX `index_last_update_timestamp_on_GroupPeerDB` ON `GroupPeerDB` (`last_update_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (888, 694, '1.0.206', 10206, 'CE7BC814AD77EF5F902DB9303C35349964FA5AA34F55CB479A4033FAF1252551', 'CREATE INDEX `index_first_join_timestamp_on_GroupPeerDB` ON `GroupPeerDB` (`first_join_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (889, 694, '1.0.206', 10206, 'CE7BC814AD77EF5F902DB9303C35349964FA5AA34F55CB479A4033FAF1252551', 'CREATE INDEX `index_Tox_Group_Role_on_GroupPeerDB` ON `GroupPeerDB` (`Tox_Group_Role`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (890, 695, '1.0.207', 10207, 'CE7BC814AD77EF5F902DB9303C35349964FA5AA34F55CB479A4033FAF1252551', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (891, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE TABLE `__temp_GroupMessage` (`message_id_tox` TEXT, `group_identifier` TEXT NOT NULL DEFAULT - 1, `tox_group_peer_pubkey` TEXT NOT NULL, `private_message` INTEGER, `tox_group_peername` TEXT, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `sent_timestamp` INTEGER, `rcvd_timestamp` INTEGER, `read` BOOLEAN NOT NULL, `is_new` BOOLEAN NOT NULL, `text` TEXT, `was_synced` BOOLEAN, `TRIFA_SYNC_TYPE` INTEGER, `sync_confirmations` INTEGER NOT NULL DEFAULT 0, `tox_group_peer_pubkey_syncer_01` TEXT, `tox_group_peer_pubkey_syncer_02` TEXT, `tox_group_peer_pubkey_syncer_03` TEXT, `tox_group_peer_pubkey_syncer_01_sent_timestamp` INTEGER, `tox_group_peer_pubkey_syncer_02_sent_timestamp` INTEGER, `tox_group_peer_pubkey_syncer_03_sent_timestamp` INTEGER, `msg_id_hash` TEXT, `sent_privately_to_tox_group_peer_pubkey` TEXT, `path_name` TEXT, `file_name` TEXT, `filename_fullpath` TEXT, `filesize` INTEGER NOT NULL DEFAULT - 1, `storage_frame_work` BOOLEAN NOT NULL DEFAULT false, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (892, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'INSERT INTO `__temp_GroupMessage` (`message_id_tox`, `group_identifier`, `tox_group_peer_pubkey`, `private_message`, `tox_group_peername`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `was_synced`, `TRIFA_SYNC_TYPE`, `sync_confirmations`, `tox_group_peer_pubkey_syncer_01`, `tox_group_peer_pubkey_syncer_02`, `tox_group_peer_pubkey_syncer_03`, `msg_id_hash`, `sent_privately_to_tox_group_peer_pubkey`, `path_name`, `file_name`, `filename_fullpath`, `filesize`, `storage_frame_work`, `id`) SELECT `message_id_tox`, `group_identifier`, `tox_group_peer_pubkey`, `private_message`, `tox_group_peername`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `was_synced`, `TRIFA_SYNC_TYPE`, `sync_confirmations`, `tox_group_peer_pubkey_syncer_01`, `tox_group_peer_pubkey_syncer_02`, `tox_group_peer_pubkey_syncer_03`, `msg_id_hash`, `sent_privately_to_tox_group_peer_pubkey`, `path_name`, `file_name`, `filename_fullpath`, `filesize`, `storage_frame_work`, `id` FROM `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (893, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'DROP TABLE `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (894, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'ALTER TABLE `__temp_GroupMessage` RENAME TO `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (895, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_message_id_tox_on_GroupMessage` ON `GroupMessage` (`message_id_tox`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (896, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_group_identifier_on_GroupMessage` ON `GroupMessage` (`group_identifier`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (897, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_tox_group_peer_pubkey_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (898, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_private_message_on_GroupMessage` ON `GroupMessage` (`private_message`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (899, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_tox_group_peername_on_GroupMessage` ON `GroupMessage` (`tox_group_peername`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (900, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_direction_on_GroupMessage` ON `GroupMessage` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (901, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_GroupMessage` ON `GroupMessage` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (902, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_GroupMessage` ON `GroupMessage` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (903, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_rcvd_timestamp_on_GroupMessage` ON `GroupMessage` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (904, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_is_new_on_GroupMessage` ON `GroupMessage` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (905, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_was_synced_on_GroupMessage` ON `GroupMessage` (`was_synced`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (906, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_TRIFA_SYNC_TYPE_on_GroupMessage` ON `GroupMessage` (`TRIFA_SYNC_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (907, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_sync_confirmations_on_GroupMessage` ON `GroupMessage` (`sync_confirmations`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (908, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_tox_group_peer_pubkey_syncer_01_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey_syncer_01`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (909, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_tox_group_peer_pubkey_syncer_02_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey_syncer_02`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (910, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_tox_group_peer_pubkey_syncer_03_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey_syncer_03`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (911, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_tox_group_peer_pubkey_syncer_01_sent_timestamp_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey_syncer_01_sent_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (912, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_tox_group_peer_pubkey_syncer_02_sent_timestamp_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey_syncer_02_sent_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (913, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_tox_group_peer_pubkey_syncer_03_sent_timestamp_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey_syncer_03_sent_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (914, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_msg_id_hash_on_GroupMessage` ON `GroupMessage` (`msg_id_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (915, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_sent_privately_to_tox_group_peer_pubkey_on_GroupMessage` ON `GroupMessage` (`sent_privately_to_tox_group_peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (916, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_path_name_on_GroupMessage` ON `GroupMessage` (`path_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (917, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_file_name_on_GroupMessage` ON `GroupMessage` (`file_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (918, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_filesize_on_GroupMessage` ON `GroupMessage` (`filesize`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (919, 723, '1.0.221', 10221, '2D6B7EAFEBB362791B4C3D8A9B19C9E56AE55D1E4577DC39FC68898D93DB354F', 'CREATE INDEX `index_storage_frame_work_on_GroupMessage` ON `GroupMessage` (`storage_frame_work`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (920, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'CREATE TABLE `__temp_FriendList` (`name` TEXT, `alias_name` TEXT, `status_message` TEXT, `TOX_CONNECTION` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_real` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off` INTEGER NOT NULL DEFAULT 0, `TOX_CONNECTION_on_off_real` INTEGER NOT NULL DEFAULT 0, `TOX_USER_STATUS` INTEGER NOT NULL DEFAULT 0, `avatar_pathname` TEXT, `avatar_filename` TEXT, `avatar_ftid_hex` TEXT, `avatar_update` BOOLEAN DEFAULT false, `avatar_update_timestamp` INTEGER NOT NULL DEFAULT - 1, `notification_silent` BOOLEAN DEFAULT false, `sort` INTEGER NOT NULL DEFAULT 0, `last_online_timestamp` INTEGER NOT NULL DEFAULT - 1, `last_online_timestamp_real` INTEGER NOT NULL DEFAULT - 1, `added_timestamp` INTEGER NOT NULL DEFAULT - 1, `is_relay` BOOLEAN DEFAULT false, `push_url` TEXT, `ip_addr_str` TEXT, `capabilities` INTEGER NOT NULL DEFAULT 0, `msgv3_capability` INTEGER NOT NULL DEFAULT 0, `tox_public_key_string` TEXT PRIMARY KEY)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (921, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'INSERT INTO `__temp_FriendList` (`name`, `alias_name`, `status_message`, `TOX_CONNECTION`, `TOX_CONNECTION_real`, `TOX_CONNECTION_on_off`, `TOX_CONNECTION_on_off_real`, `TOX_USER_STATUS`, `avatar_pathname`, `avatar_filename`, `avatar_ftid_hex`, `avatar_update`, `avatar_update_timestamp`, `notification_silent`, `sort`, `last_online_timestamp`, `last_online_timestamp_real`, `added_timestamp`, `is_relay`, `push_url`, `capabilities`, `msgv3_capability`, `tox_public_key_string`) SELECT `name`, `alias_name`, `status_message`, `TOX_CONNECTION`, `TOX_CONNECTION_real`, `TOX_CONNECTION_on_off`, `TOX_CONNECTION_on_off_real`, `TOX_USER_STATUS`, `avatar_pathname`, `avatar_filename`, `avatar_ftid_hex`, `avatar_update`, `avatar_update_timestamp`, `notification_silent`, `sort`, `last_online_timestamp`, `last_online_timestamp_real`, `added_timestamp`, `is_relay`, `push_url`, `capabilities`, `msgv3_capability`, `tox_public_key_string` FROM `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (922, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'DROP TABLE `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (923, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'ALTER TABLE `__temp_FriendList` RENAME TO `FriendList`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (924, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'CREATE INDEX `index_alias_name_on_FriendList` ON `FriendList` (`alias_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (925, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'CREATE INDEX `index_TOX_CONNECTION_on_FriendList` ON `FriendList` (`TOX_CONNECTION`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (926, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'CREATE INDEX `index_TOX_CONNECTION_real_on_FriendList` ON `FriendList` (`TOX_CONNECTION_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (927, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'CREATE INDEX `index_TOX_CONNECTION_on_off_on_FriendList` ON `FriendList` (`TOX_CONNECTION_on_off`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (928, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'CREATE INDEX `index_TOX_CONNECTION_on_off_real_on_FriendList` ON `FriendList` (`TOX_CONNECTION_on_off_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (929, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'CREATE INDEX `index_TOX_USER_STATUS_on_FriendList` ON `FriendList` (`TOX_USER_STATUS`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (930, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'CREATE INDEX `index_avatar_ftid_hex_on_FriendList` ON `FriendList` (`avatar_ftid_hex`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (931, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'CREATE INDEX `index_avatar_update_on_FriendList` ON `FriendList` (`avatar_update`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (932, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'CREATE INDEX `index_avatar_update_timestamp_on_FriendList` ON `FriendList` (`avatar_update_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (933, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'CREATE INDEX `index_notification_silent_on_FriendList` ON `FriendList` (`notification_silent`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (934, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'CREATE INDEX `index_sort_on_FriendList` ON `FriendList` (`sort`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (935, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'CREATE INDEX `index_last_online_timestamp_on_FriendList` ON `FriendList` (`last_online_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (936, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'CREATE INDEX `index_last_online_timestamp_real_on_FriendList` ON `FriendList` (`last_online_timestamp_real`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (937, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'CREATE INDEX `index_added_timestamp_on_FriendList` ON `FriendList` (`added_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (938, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'CREATE INDEX `index_is_relay_on_FriendList` ON `FriendList` (`is_relay`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (939, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'CREATE INDEX `index_push_url_on_FriendList` ON `FriendList` (`push_url`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (940, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'CREATE INDEX `index_ip_addr_str_on_FriendList` ON `FriendList` (`ip_addr_str`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (941, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'CREATE INDEX `index_capabilities_on_FriendList` ON `FriendList` (`capabilities`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (942, 745, '1.0.226', 10226, 'D907CEB7D00F0ACA9A87581D1D0ACD9258752600F171EFD0F1CF7C2446218AFE', 'CREATE INDEX `index_msgv3_capability_on_FriendList` ON `FriendList` (`msgv3_capability`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (943, 745, '1.0.229', 10229, '83DFA974882B0F6322C897964853DC6805ACA850C648891682E5F0E7D3A0A8CD', NULL, '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (944, 758, '1.0.240', 10240, '2B696D32FCE45B479603E162E43D949517877696AF606E70C8F5D4B9FA5C56D7', 'CREATE TABLE `__temp_GroupDB` (`who_invited__tox_public_key_string` TEXT NOT NULL, `name` TEXT, `topic` TEXT, `peer_count` INTEGER NOT NULL DEFAULT - 1, `own_peer_number` INTEGER NOT NULL DEFAULT - 1, `privacy_state` INTEGER NOT NULL DEFAULT 0, `tox_group_number` INTEGER NOT NULL DEFAULT - 1, `group_active` BOOLEAN NOT NULL DEFAULT false, `group_we_left` BOOLEAN NOT NULL DEFAULT false, `notification_silent` BOOLEAN DEFAULT false, `group_identifier` TEXT PRIMARY KEY)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (945, 758, '1.0.240', 10240, '2B696D32FCE45B479603E162E43D949517877696AF606E70C8F5D4B9FA5C56D7', 'INSERT INTO `__temp_GroupDB` (`who_invited__tox_public_key_string`, `name`, `topic`, `peer_count`, `own_peer_number`, `privacy_state`, `tox_group_number`, `group_active`, `notification_silent`, `group_identifier`) SELECT `who_invited__tox_public_key_string`, `name`, `topic`, `peer_count`, `own_peer_number`, `privacy_state`, `tox_group_number`, `group_active`, `notification_silent`, `group_identifier` FROM `GroupDB`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (946, 758, '1.0.240', 10240, '2B696D32FCE45B479603E162E43D949517877696AF606E70C8F5D4B9FA5C56D7', 'DROP TABLE `GroupDB`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (947, 758, '1.0.240', 10240, '2B696D32FCE45B479603E162E43D949517877696AF606E70C8F5D4B9FA5C56D7', 'ALTER TABLE `__temp_GroupDB` RENAME TO `GroupDB`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (948, 758, '1.0.240', 10240, '2B696D32FCE45B479603E162E43D949517877696AF606E70C8F5D4B9FA5C56D7', 'CREATE INDEX `index_who_invited__tox_public_key_string_on_GroupDB` ON `GroupDB` (`who_invited__tox_public_key_string`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (949, 758, '1.0.240', 10240, '2B696D32FCE45B479603E162E43D949517877696AF606E70C8F5D4B9FA5C56D7', 'CREATE INDEX `index_name_on_GroupDB` ON `GroupDB` (`name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (950, 758, '1.0.240', 10240, '2B696D32FCE45B479603E162E43D949517877696AF606E70C8F5D4B9FA5C56D7', 'CREATE INDEX `index_topic_on_GroupDB` ON `GroupDB` (`topic`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (951, 758, '1.0.240', 10240, '2B696D32FCE45B479603E162E43D949517877696AF606E70C8F5D4B9FA5C56D7', 'CREATE INDEX `index_peer_count_on_GroupDB` ON `GroupDB` (`peer_count`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (952, 758, '1.0.240', 10240, '2B696D32FCE45B479603E162E43D949517877696AF606E70C8F5D4B9FA5C56D7', 'CREATE INDEX `index_own_peer_number_on_GroupDB` ON `GroupDB` (`own_peer_number`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (953, 758, '1.0.240', 10240, '2B696D32FCE45B479603E162E43D949517877696AF606E70C8F5D4B9FA5C56D7', 'CREATE INDEX `index_privacy_state_on_GroupDB` ON `GroupDB` (`privacy_state`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (954, 758, '1.0.240', 10240, '2B696D32FCE45B479603E162E43D949517877696AF606E70C8F5D4B9FA5C56D7', 'CREATE INDEX `index_tox_group_number_on_GroupDB` ON `GroupDB` (`tox_group_number`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (955, 758, '1.0.240', 10240, '2B696D32FCE45B479603E162E43D949517877696AF606E70C8F5D4B9FA5C56D7', 'CREATE INDEX `index_group_active_on_GroupDB` ON `GroupDB` (`group_active`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (956, 758, '1.0.240', 10240, '2B696D32FCE45B479603E162E43D949517877696AF606E70C8F5D4B9FA5C56D7', 'CREATE INDEX `index_group_we_left_on_GroupDB` ON `GroupDB` (`group_we_left`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (957, 758, '1.0.240', 10240, '2B696D32FCE45B479603E162E43D949517877696AF606E70C8F5D4B9FA5C56D7', 'CREATE INDEX `index_notification_silent_on_GroupDB` ON `GroupDB` (`notification_silent`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (958, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE TABLE `__temp_GroupMessage` (`message_id_tox` TEXT, `group_identifier` TEXT NOT NULL DEFAULT - 1, `tox_group_peer_pubkey` TEXT NOT NULL, `tox_group_peer_role` INTEGER NOT NULL DEFAULT - 1, `private_message` INTEGER, `tox_group_peername` TEXT, `direction` INTEGER NOT NULL, `TOX_MESSAGE_TYPE` INTEGER NOT NULL, `TRIFA_MESSAGE_TYPE` INTEGER NOT NULL DEFAULT 0, `sent_timestamp` INTEGER, `rcvd_timestamp` INTEGER, `read` BOOLEAN NOT NULL, `is_new` BOOLEAN NOT NULL, `text` TEXT, `was_synced` BOOLEAN, `TRIFA_SYNC_TYPE` INTEGER, `sync_confirmations` INTEGER NOT NULL DEFAULT 0, `tox_group_peer_pubkey_syncer_01` TEXT, `tox_group_peer_pubkey_syncer_02` TEXT, `tox_group_peer_pubkey_syncer_03` TEXT, `tox_group_peer_pubkey_syncer_01_sent_timestamp` INTEGER, `tox_group_peer_pubkey_syncer_02_sent_timestamp` INTEGER, `tox_group_peer_pubkey_syncer_03_sent_timestamp` INTEGER, `msg_id_hash` TEXT, `sent_privately_to_tox_group_peer_pubkey` TEXT, `path_name` TEXT, `file_name` TEXT, `filename_fullpath` TEXT, `filesize` INTEGER NOT NULL DEFAULT - 1, `storage_frame_work` BOOLEAN NOT NULL DEFAULT false, `id` INTEGER PRIMARY KEY AUTOINCREMENT)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (959, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'INSERT INTO `__temp_GroupMessage` (`message_id_tox`, `group_identifier`, `tox_group_peer_pubkey`, `private_message`, `tox_group_peername`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `was_synced`, `TRIFA_SYNC_TYPE`, `sync_confirmations`, `tox_group_peer_pubkey_syncer_01`, `tox_group_peer_pubkey_syncer_02`, `tox_group_peer_pubkey_syncer_03`, `tox_group_peer_pubkey_syncer_01_sent_timestamp`, `tox_group_peer_pubkey_syncer_02_sent_timestamp`, `tox_group_peer_pubkey_syncer_03_sent_timestamp`, `msg_id_hash`, `sent_privately_to_tox_group_peer_pubkey`, `path_name`, `file_name`, `filename_fullpath`, `filesize`, `storage_frame_work`, `id`) SELECT `message_id_tox`, `group_identifier`, `tox_group_peer_pubkey`, `private_message`, `tox_group_peername`, `direction`, `TOX_MESSAGE_TYPE`, `TRIFA_MESSAGE_TYPE`, `sent_timestamp`, `rcvd_timestamp`, `read`, `is_new`, `text`, `was_synced`, `TRIFA_SYNC_TYPE`, `sync_confirmations`, `tox_group_peer_pubkey_syncer_01`, `tox_group_peer_pubkey_syncer_02`, `tox_group_peer_pubkey_syncer_03`, `tox_group_peer_pubkey_syncer_01_sent_timestamp`, `tox_group_peer_pubkey_syncer_02_sent_timestamp`, `tox_group_peer_pubkey_syncer_03_sent_timestamp`, `msg_id_hash`, `sent_privately_to_tox_group_peer_pubkey`, `path_name`, `file_name`, `filename_fullpath`, `filesize`, `storage_frame_work`, `id` FROM `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (960, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'DROP TABLE `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (961, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'ALTER TABLE `__temp_GroupMessage` RENAME TO `GroupMessage`', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (962, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_message_id_tox_on_GroupMessage` ON `GroupMessage` (`message_id_tox`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (963, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_group_identifier_on_GroupMessage` ON `GroupMessage` (`group_identifier`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (964, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_tox_group_peer_pubkey_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (965, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_tox_group_peer_role_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_role`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (966, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_private_message_on_GroupMessage` ON `GroupMessage` (`private_message`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (967, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_tox_group_peername_on_GroupMessage` ON `GroupMessage` (`tox_group_peername`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (968, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_direction_on_GroupMessage` ON `GroupMessage` (`direction`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (969, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_TOX_MESSAGE_TYPE_on_GroupMessage` ON `GroupMessage` (`TOX_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (970, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_TRIFA_MESSAGE_TYPE_on_GroupMessage` ON `GroupMessage` (`TRIFA_MESSAGE_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (971, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_rcvd_timestamp_on_GroupMessage` ON `GroupMessage` (`rcvd_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (972, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_is_new_on_GroupMessage` ON `GroupMessage` (`is_new`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (973, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_was_synced_on_GroupMessage` ON `GroupMessage` (`was_synced`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (974, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_TRIFA_SYNC_TYPE_on_GroupMessage` ON `GroupMessage` (`TRIFA_SYNC_TYPE`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (975, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_sync_confirmations_on_GroupMessage` ON `GroupMessage` (`sync_confirmations`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (976, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_tox_group_peer_pubkey_syncer_01_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey_syncer_01`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (977, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_tox_group_peer_pubkey_syncer_02_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey_syncer_02`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (978, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_tox_group_peer_pubkey_syncer_03_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey_syncer_03`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (979, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_tox_group_peer_pubkey_syncer_01_sent_timestamp_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey_syncer_01_sent_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (980, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_tox_group_peer_pubkey_syncer_02_sent_timestamp_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey_syncer_02_sent_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (981, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_tox_group_peer_pubkey_syncer_03_sent_timestamp_on_GroupMessage` ON `GroupMessage` (`tox_group_peer_pubkey_syncer_03_sent_timestamp`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (982, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_msg_id_hash_on_GroupMessage` ON `GroupMessage` (`msg_id_hash`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (983, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_sent_privately_to_tox_group_peer_pubkey_on_GroupMessage` ON `GroupMessage` (`sent_privately_to_tox_group_peer_pubkey`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (984, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_path_name_on_GroupMessage` ON `GroupMessage` (`path_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (985, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_file_name_on_GroupMessage` ON `GroupMessage` (`file_name`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (986, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_filesize_on_GroupMessage` ON `GroupMessage` (`filesize`)', '[]', NULL);
INSERT INTO "orma_schema_diff_migration_2" ("id", "db_version", "version_name", "version_code", "schema_hash", "sql", "args", "created_timestamp") VALUES (987, 787, '1.0.241', 10241, '0864F98C1A5BEB136AFD6937683A33F41ED25F687FAA3615CE84313E64C0B1CD', 'CREATE INDEX `index_storage_frame_work_on_GroupMessage` ON `GroupMessage` (`storage_frame_work`)', '[]', NULL);
