package com.zhangke.fread.status.ui.common

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.aspectRatio
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.drawWithContent
import androidx.compose.ui.graphics.Brush
import androidx.compose.ui.layout.ContentScale
import com.seiko.imageloader.ui.AutoSizeImage
import com.zhangke.fread.statusui.Res
import com.zhangke.fread.statusui.img_banner_background
import org.jetbrains.compose.resources.painterResource

private const val BANNER_ASPECT = 2.6F

@Composable
fun ProgressedBanner(
    modifier: Modifier,
    url: String?,
) {
    Box(modifier = modifier.aspectRatio(BANNER_ASPECT)) {
        Image(
            modifier = Modifier.fillMaxSize(),
            painter = painterResource(Res.drawable.img_banner_background),
            contentDescription = null,
            contentScale = ContentScale.Crop,
        )
        val maskColor = MaterialTheme.colorScheme.inverseSurface
        AutoSizeImage(
            url.orEmpty(),
            modifier = Modifier
                .fillMaxSize()
                .drawWithContent {
                    drawContent()
                    drawRect(
                        brush = Brush.verticalGradient(
                            colors = listOf(
                                maskColor.copy(alpha = 0.3F),
                                maskColor.copy(alpha = 0F),
                            ),
                        ),
                    )
                },
            contentScale = ContentScale.Crop,
            contentDescription = "banner",
        )
    }
}
