package com.zhangke.framework.utils

import android.content.ClipData
import android.content.ClipboardManager
import android.content.Context


object SystemUtils {

    fun getAppVersionName(context: Context): String {
        val pInfo = context.packageManager.getPackageInfo(context.packageName, 0)
        return pInfo.versionName.orEmpty()
    }

    fun getAppVersionCode(context: Context): String {
        val pInfo = context.packageManager.getPackageInfo(context.packageName, 0)
        return pInfo.versionCode.toString()
    }

    fun copyText(context: Context, text: String){
        val clipboard = context.getSystemService(Context.CLIPBOARD_SERVICE) as ClipboardManager
        val clip = ClipData.newPlainText("text", text)
        clipboard.setPrimaryClip(clip)
    }
}
