package com.zhangke.framework.serialize

import com.zhangke.framework.datetime.Instant
import kotlinx.serialization.KSerializer
import kotlinx.serialization.descriptors.PrimitiveKind
import kotlinx.serialization.descriptors.PrimitiveSerialDescriptor
import kotlinx.serialization.descriptors.SerialDescriptor
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder

object TimestampAsInstantSerializer : KSerializer<Instant> {
    override val descriptor: SerialDescriptor =
        PrimitiveSerialDescriptor("kotlinx.datetime.Instant", PrimitiveKind.LONG)

    override fun deserialize(decoder: Decoder): Instant {
        val timestamp = decoder.decodeLong()
        return Instant(kotlinx.datetime.Instant.fromEpochMilliseconds(timestamp))
    }

    override fun serialize(encoder: Encoder, value: Instant) {
        encoder.encodeLong(value.instant.toEpochMilliseconds())
    }
}
