package com.zell_mbc.publicartexplorer.screens

import android.content.Intent
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.SpanStyle
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.style.TextDecoration
import androidx.compose.ui.text.withStyle
import androidx.compose.ui.unit.dp
import androidx.core.net.toUri
import com.zell_mbc.publicartexplorer.ProjectDetails
import com.zell_mbc.publicartexplorer.R
import com.zell_mbc.publicartexplorer.ui.theme.link
import java.util.Calendar

@Composable
fun ProjectInfoSection() {
    val context = LocalContext.current
    val year = Calendar.getInstance().get(Calendar.YEAR)
    Surface(
        modifier = Modifier.fillMaxWidth(),
        tonalElevation = 6.dp,
        shape = MaterialTheme.shapes.medium
    ) {
        Column(
            modifier = Modifier.padding(16.dp),
            verticalArrangement = Arrangement.spacedBy(8.dp)
        ) {
            Text(text = stringResource(R.string.project), style = MaterialTheme.typography.titleMedium, color = MaterialTheme.colorScheme.primary)
            Text(
                buildAnnotatedString {
                    withStyle(SpanStyle(color = MaterialTheme.colorScheme.link, textDecoration = TextDecoration.Underline)) {
                        append(stringResource(id = R.string.THIRD_PARTY))
                    }
                },
                modifier = Modifier.clickable {
                    val browserIntent = Intent(Intent.ACTION_VIEW, ProjectDetails.THIRD_PARTY.toUri())
                    context.startActivity(browserIntent)
                },
                style = MaterialTheme.typography.bodySmall,
                color = MaterialTheme.colorScheme.link
            )

            Text(
                buildAnnotatedString {
                    withStyle(SpanStyle(color = MaterialTheme.colorScheme.link, textDecoration = TextDecoration.Underline)) {
                        append(stringResource(id = R.string.copyright, year))
                    }
                },
                modifier = Modifier.clickable {
                    // Handle open license URL here
                    val browserIntent = Intent(Intent.ACTION_VIEW, ProjectDetails.APP_LICENSE.toUri())
                    context.startActivity(browserIntent)
                },
                style = MaterialTheme.typography.bodySmall,
                color = MaterialTheme.colorScheme.link
            )
        }
    }
}
