package com.zell_mbc.publicartexplorer.helpers

import android.content.Context
import android.util.Log
import com.zell_mbc.publicartexplorer.R
import com.zell_mbc.publicartexplorer.httpCodeToStringRes

object HttpErrorHelper {

    private const val TAG = "HttpErrorHelper"

    enum class ErrorCategory {
        CLIENT,
        SERVER,
        OTHER
    }

    /**
     * Returns a localized message for the given HTTP status code.
     * Falls back to "HTTPS {code}" if no string is found.
     */
    fun getHttpErrorMessage(context: Context, code: Int): String {
        val resId = httpCodeToStringRes[code] ?: R.string.http_unknown
        return context.getString(resId, code)
    }

    /**
     * Returns the error category for a given HTTP status code.
     */
    fun getErrorCategory(code: Int): ErrorCategory {
        return when (code) {
            in 400..499 -> ErrorCategory.CLIENT
            in 500..599 -> ErrorCategory.SERVER
            else -> ErrorCategory.OTHER
        }
    }

    fun getHttpErrorInfo(context: Context, code: Int): Pair<String, ErrorCategory> {
        val message = getHttpErrorMessage(context, code)
        val category = getErrorCategory(code)
        Log.d(TAG, "HTTP $code -> [$category] $message")
        return message to category
    }
}
