package com.zell_mbc.publicartexplorer.helpers

import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.layout.width
import androidx.compose.material3.*
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.WifiOff
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import com.zell_mbc.publicartexplorer.data.ViewModel
import com.zell_mbc.publicartexplorer.httpCodeToStringRes
import com.zell_mbc.publicartexplorer.R

@Composable
fun HttpAlertDialog(viewModel: ViewModel) {
    if (viewModel.showHttpAlertDialog != 0) {
        AlertDialog(
            onDismissRequest = { viewModel.showHttpAlertDialog = 0 },
            title = {
                Row(verticalAlignment = Alignment.CenterVertically) {
                    Icon(
                        imageVector = Icons.Default.WifiOff,
                        contentDescription = "Internet unavailable",
                        tint = MaterialTheme.colorScheme.error,
                        modifier = Modifier.size(24.dp)
                    )
                    Spacer(modifier = Modifier.width(8.dp))
                    Text(stringResource(R.string.error))
                }
            },
            text = {
                val resId = httpCodeToStringRes[viewModel.showHttpAlertDialog] ?: R.string.http_unknown
                Text(stringResource(resId))
            },
            confirmButton = {
                OutlinedButton(onClick = { viewModel.showHttpAlertDialog = 0 }) {
                    Text(stringResource(R.string.ok))
                }
            }
        )
    }
}
