package com.zell_mbc.publicartexplorer.helpers

import android.content.Context
import android.util.Log
import com.zell_mbc.publicartexplorer.sharedOkHttpClient
import okhttp3.OkHttpClient
import coil3.imageLoader
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext

suspend fun clearImageCaches(context: Context) {
    withContext(Dispatchers.IO) {
        // Clear Coil caches
        val imageLoader = context.imageLoader
        //var keys = imageLoader.memoryCache?.keys
        //Log.d("DEBUG", "Memory cache keys: $keys")
        imageLoader.memoryCache?.clear()
        imageLoader.diskCache?.clear()
        //keys = imageLoader.memoryCache?.keys
        //Log.d("DEBUG", "Memory cache keys: $keys")

        // Clear OkHttp cache
        sharedOkHttpClient.cache?.evictAll()
        sharedOkHttpClient.cache?.directory?.deleteRecursively()
    }
}
