package com.zell_mbc.publicartexplorer

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.activity.enableEdgeToEdge
import androidx.compose.ui.Modifier
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.runtime.*
import com.zell_mbc.publicartexplorer.ui.theme.PublicArtExplorerTheme
import androidx.activity.viewModels
import androidx.compose.foundation.isSystemInDarkTheme
import androidx.compose.foundation.layout.systemBarsPadding
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import com.google.accompanist.permissions.ExperimentalPermissionsApi
import com.zell_mbc.publicartexplorer.onboarding.OnboardingPage
import com.zell_mbc.publicartexplorer.data.ViewModel
import com.zell_mbc.publicartexplorer.helpers.NetworkStatusTracker
import com.zell_mbc.publicartexplorer.onboarding.AppStart
import com.zell_mbc.publicartexplorer.screens.DarkThemeOption
import com.zell_mbc.publicartexplorer.screens.MainScaffold
import com.zell_mbc.publicartexplorer.screens.ThemeState

class MainActivity : ComponentActivity() {
    val viewModel by viewModels<ViewModel>()

    @OptIn(ExperimentalPermissionsApi::class)
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        enableEdgeToEdge()

        System.setProperty("java.net.preferIPv4Stack", "true") // Saw issues with images not loading because the OS used IP6?!

        setContent {
            var appStart by remember { mutableStateOf((applicationContext as PublicArtExplorer).appStart) } // Needed to trigger recomposition

            val isDarkTheme = when (DarkThemeOption.entries[viewModel.darkMode]) {
                DarkThemeOption.Light -> false
                DarkThemeOption.Dark -> true
                DarkThemeOption.FollowSystem -> isSystemInDarkTheme()
            }
            //appStart = AppStart.FIRST_TIME_APP
            PublicArtExplorerTheme(darkTheme = isDarkTheme, contrast = ThemeState.contrast) {
                if (appStart == AppStart.FIRST_TIME_APP) {
                    Surface(modifier = Modifier.fillMaxSize().systemBarsPadding(), // <-- handles top/bottom insets
                        color = MaterialTheme.colorScheme.background) {
                        OnboardingPage(context = this, setValue = {
                            appStart = it // Trigger recomposition
                            (applicationContext as PublicArtExplorer).appStart = AppStart.NORMAL // Without this a recomposition would lead to the Onboarding page again
                        })
                   }
                }
                else MainScaffold(viewModel)
            }
        }
    }
}